/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.util.UUID;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConfigurableWebBrowser
extends WebBrowser {
    private final UUID id;
    @NotNull
    private BrowserFamily family;
    @NotNull
    private String name;
    private boolean active;
    private String path;
    private BrowserSpecificSettings specificSettings;

    public ConfigurableWebBrowser() {
        this(UUID.randomUUID(), BrowserFamily.CHROME);
    }

    public ConfigurableWebBrowser(@NotNull UUID id, @NotNull BrowserFamily family) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/browsers/ConfigurableWebBrowser", "<init>"));
        }
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/ide/browsers/ConfigurableWebBrowser", "<init>"));
        }
        this(id, family, family.getName(), family.getExecutionPath(), true, family.createBrowserSpecificSettings());
    }

    public ConfigurableWebBrowser(@NotNull UUID id, @NotNull BrowserFamily family, @NotNull String name, @Nullable String path, boolean active, @Nullable BrowserSpecificSettings specificSettings) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/browsers/ConfigurableWebBrowser", "<init>"));
        }
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/ide/browsers/ConfigurableWebBrowser", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/browsers/ConfigurableWebBrowser", "<init>"));
        }
        this.id = id;
        this.family = family;
        this.name = name;
        this.path = StringUtil.nullize((String)path);
        this.active = active;
        this.specificSettings = specificSettings;
    }

    public void setName(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/browsers/ConfigurableWebBrowser", "setName"));
        }
        this.name = value;
    }

    public void setFamily(@NotNull BrowserFamily value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/browsers/ConfigurableWebBrowser", "setFamily"));
        }
        this.family = value;
    }

    @NotNull
    public Icon getIcon() {
        if (this.family == BrowserFamily.CHROME) {
            if (WebBrowserManager.isYandexBrowser(this)) {
                Icon icon = AllIcons.Xml.Browsers.Yandex16;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/ConfigurableWebBrowser", "getIcon"));
                }
                return icon;
            }
            if (this.checkNameAndPath("Dartium") || this.checkNameAndPath("Chromium")) {
                Icon icon = AllIcons.Xml.Browsers.Chromium16;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/ConfigurableWebBrowser", "getIcon"));
                }
                return icon;
            }
            if (this.checkNameAndPath("Canary")) {
                Icon icon = AllIcons.Xml.Browsers.Canary16;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/ConfigurableWebBrowser", "getIcon"));
                }
                return icon;
            }
            if (this.checkNameAndPath("Opera")) {
                Icon icon = AllIcons.Xml.Browsers.Opera16;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/ConfigurableWebBrowser", "getIcon"));
                }
                return icon;
            }
            if (this.checkNameAndPath("node-webkit") || this.checkNameAndPath("nw") || this.checkNameAndPath("nwjs")) {
                Icon icon = AllIcons.Xml.Browsers.Nwjs16;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/ConfigurableWebBrowser", "getIcon"));
                }
                return icon;
            }
        }
        Icon icon = this.family.getIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/ConfigurableWebBrowser", "getIcon"));
        }
        return icon;
    }

    private boolean checkNameAndPath(@NotNull String what) {
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/ide/browsers/ConfigurableWebBrowser", "checkNameAndPath"));
        }
        return WebBrowserManager.checkNameAndPath(what, this);
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public void setPath(@Nullable String value) {
        this.path = PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)value));
    }

    @Nullable
    public BrowserSpecificSettings getSpecificSettings() {
        return this.specificSettings;
    }

    public void setSpecificSettings(@Nullable BrowserSpecificSettings value) {
        this.specificSettings = value;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurableWebBrowser)) {
            return false;
        }
        ConfigurableWebBrowser browser = (ConfigurableWebBrowser)((Object)o);
        return this.getId().equals(browser.getId()) && this.family.equals((Object)browser.family) && this.active == browser.active && Comparing.strEqual((String)this.name, (String)browser.name) && Comparing.equal((String)this.path, (String)browser.path) && Comparing.equal((Object)this.specificSettings, (Object)browser.specificSettings);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/ConfigurableWebBrowser", "getName"));
        }
        return string;
    }

    @NotNull
    public final UUID getId() {
        UUID uUID = this.id;
        if (uUID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/ConfigurableWebBrowser", "getId"));
        }
        return uUID;
    }

    @NotNull
    public BrowserFamily getFamily() {
        BrowserFamily browserFamily = this.family;
        if (browserFamily == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/ConfigurableWebBrowser", "getFamily"));
        }
        return browserFamily;
    }

    @NotNull
    public String getBrowserNotFoundMessage() {
        String string = IdeBundle.message((String)"error.0.browser.path.not.specified", (Object[])new Object[]{this.getName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/ConfigurableWebBrowser", "getBrowserNotFoundMessage"));
        }
        return string;
    }

    public String toString() {
        return this.getName() + " (" + this.getPath() + ")";
    }
}

