/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class CalleeMethodsTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public CalleeMethodsTreeStructure(Project project2, PsiMethod method, String scopeType) {
        super(project2, new CallHierarchyNodeDescriptor(project2, null, (PsiElement)method, true, false));
        this.myScopeType = scopeType;
    }

    @Override
    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiMethod[] overridingMethods;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/hierarchy/call/CalleeMethodsTreeStructure", "buildChildren"));
        }
        PsiMember enclosingElement = ((CallHierarchyNodeDescriptor)descriptor).getEnclosingElement();
        if (!(enclosingElement instanceof PsiMethod)) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/call/CalleeMethodsTreeStructure", "buildChildren"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        PsiMethod method = (PsiMethod)enclosingElement;
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            CalleeMethodsTreeStructure.visitor((PsiElement)body, methods);
        }
        PsiMethod baseMethod = (PsiMethod)((CallHierarchyNodeDescriptor)this.getBaseDescriptor()).getTargetElement();
        PsiClass baseClass = baseMethod.getContainingClass();
        HashMap methodToDescriptorMap = new HashMap();
        ArrayList<CallHierarchyNodeDescriptor> result2 = new ArrayList<CallHierarchyNodeDescriptor>();
        for (PsiMethod calledMethod : methods) {
            if (!this.isInScope((PsiElement)baseClass, (PsiElement)calledMethod, this.myScopeType)) continue;
            CallHierarchyNodeDescriptor d = (CallHierarchyNodeDescriptor)((Object)methodToDescriptorMap.get((Object)calledMethod));
            if (d == null) {
                d = new CallHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)calledMethod, false, false);
                methodToDescriptorMap.put((Object)calledMethod, (Object)d);
                result2.add(d);
                continue;
            }
            d.incrementUsageCount();
        }
        for (PsiMethod overridingMethod : overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
            CallHierarchyNodeDescriptor node;
            if (!this.isInScope((PsiElement)baseClass, (PsiElement)overridingMethod, this.myScopeType) || result2.contains((Object)(node = new CallHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)overridingMethod, false, false)))) continue;
            result2.add(node);
        }
        Object[] objectArray = ArrayUtil.toObjectArray(result2);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/call/CalleeMethodsTreeStructure", "buildChildren"));
        }
        return objectArray;
    }

    private static void visitor(PsiElement element, ArrayList<PsiMethod> methods) {
        PsiElement[] children2;
        for (PsiElement child : children2 = element.getChildren()) {
            PsiNewExpression newExpression;
            PsiMethod method;
            CalleeMethodsTreeStructure.visitor(child, methods);
            if (child instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)child;
                PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
                PsiMethod method2 = (PsiMethod)methodExpression.resolve();
                if (method2 == null) continue;
                methods.add(method2);
                continue;
            }
            if (!(child instanceof PsiNewExpression) || (method = (newExpression = (PsiNewExpression)child).resolveConstructor()) == null) continue;
            methods.add(method);
        }
    }
}

