/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarListWrapper;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.SelectInNavBarTarget;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;

public class ShowNavBarAction
extends AnAction
implements DumbAware,
PopupAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext context = e.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project2 != null) {
            UISettings uiSettings = UISettings.getInstance();
            if (uiSettings.SHOW_NAVIGATION_BAR && !uiSettings.PRESENTATION_MODE) {
                new SelectInNavBarTarget(project2).select(null, false);
            } else {
                Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
                if (!ShowNavBarAction.isInsideNavBar(component)) {
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
                    NavBarPanel toolbarPanel = new NavBarPanel(project2, false);
                    toolbarPanel.showHint(editor, context);
                }
            }
        }
    }

    private static boolean isInsideNavBar(Component c) {
        return c == null || c instanceof NavBarPanel || UIUtil.getParentOfType(NavBarListWrapper.class, (Component)c) != null;
    }

    public void update(AnActionEvent e) {
        boolean enabled = e.getData(CommonDataKeys.PROJECT) != null;
        e.getPresentation().setEnabled(enabled);
    }
}

