/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.net.IOExceptionDialog;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class InstallPluginAction
extends AnAction
implements DumbAware {
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();
    private static final Set<IdeaPluginDescriptor> ourInstallingNodes = new HashSet<IdeaPluginDescriptor>();
    private final PluginManagerMain myHost;
    private final PluginManagerMain myInstalled;

    public InstallPluginAction(PluginManagerMain mgr, PluginManagerMain installed) {
        super(IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]), IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]), AllIcons.Actions.Install);
        this.myHost = mgr;
        this.myInstalled = installed;
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        Presentation presentation = e.getPresentation();
        IdeaPluginDescriptor[] selection = this.getPluginTable().getSelectedObjects();
        boolean bl = enabled = selection != null;
        if (enabled) {
            for (IdeaPluginDescriptor descr : selection) {
                presentation.setText(IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]));
                presentation.setDescription(IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]));
                enabled &= !ourInstallingNodes.contains(descr);
                if (descr instanceof PluginNode) {
                    enabled &= !PluginManagerColumnInfo.isDownloaded((PluginNode)descr);
                    if (((PluginNode)descr).getStatus() != 1) continue;
                    presentation.setText(IdeBundle.message((String)"action.update.plugin", (Object[])new Object[0]));
                    presentation.setDescription(IdeBundle.message((String)"action.update.plugin", (Object[])new Object[0]));
                    enabled &= ourState.hasNewerVersion(descr.getPluginId());
                    continue;
                }
                if (!(descr instanceof IdeaPluginDescriptorImpl)) continue;
                presentation.setText(IdeBundle.message((String)"action.update.plugin", (Object[])new Object[0]));
                presentation.setDescription(IdeBundle.message((String)"action.update.plugin", (Object[])new Object[0]));
                PluginId id = descr.getPluginId();
                enabled = enabled && ourState.hasNewerVersion(id);
            }
        }
        presentation.setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        this.install(null);
    }

    public static boolean isInstalling(IdeaPluginDescriptor node) {
        return ourInstallingNodes.contains(node);
    }

    public void install(@Nullable Runnable onSuccess) {
        this.install(onSuccess, null, false);
    }

    public void install(@Nullable Runnable onSuccess, @Nullable Runnable cleanup, boolean confirmed) {
        IdeaPluginDescriptor[] selection = this.getPluginTable().getSelectedObjects();
        if (confirmed || this.userConfirm(selection)) {
            ArrayList<PluginNode> list = new ArrayList<PluginNode>();
            for (IdeaPluginDescriptor descr : selection) {
                PluginNode pluginNode = null;
                if (descr instanceof PluginNode) {
                    pluginNode = (PluginNode)descr;
                } else if (descr instanceof IdeaPluginDescriptorImpl) {
                    PluginId pluginId = descr.getPluginId();
                    pluginNode = new PluginNode(pluginId);
                    pluginNode.setName(descr.getName());
                    pluginNode.setDepends(Arrays.asList(descr.getDependentPluginIds()), descr.getOptionalDependentPluginIds());
                    pluginNode.setSize("-1");
                    pluginNode.setRepositoryName("__unknown_repository__");
                }
                if (pluginNode == null) continue;
                list.add(pluginNode);
                ourInstallingNodes.add(pluginNode);
            }
            InstalledPluginsTableModel installedModel = (InstalledPluginsTableModel)this.myInstalled.getPluginsModel();
            PluginManagerMain.PluginEnabler.UI pluginEnabler = new PluginManagerMain.PluginEnabler.UI(installedModel);
            if (PluginManagerMain.suggestToEnableInstalledDependantPlugins(pluginEnabler, list)) {
                this.myInstalled.setRequireShutdown(true);
            }
            try {
                Runnable onInstallRunnable = () -> {
                    for (PluginNode node : list) {
                        installedModel.appendOrUpdateDescriptor(node);
                    }
                    if (!this.myInstalled.isDisposed()) {
                        this.getPluginTable().updateUI();
                        this.myInstalled.setRequireShutdown(true);
                    } else {
                        boolean needToRestart = false;
                        for (PluginNode node : list) {
                            IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin(node.getPluginId());
                            if (pluginDescriptor != null && !pluginDescriptor.isEnabled()) continue;
                            needToRestart = true;
                            break;
                        }
                        if (needToRestart) {
                            PluginManagerMain.notifyPluginsUpdated(null);
                        }
                    }
                    if (onSuccess != null) {
                        onSuccess.run();
                    }
                };
                Runnable cleanupRunnable = () -> {
                    ourInstallingNodes.removeAll(list);
                    if (cleanup != null) {
                        cleanup.run();
                    }
                };
                List<IdeaPluginDescriptor> plugins2 = this.myHost.getPluginsModel().getAllPlugins();
                PluginManagerMain.downloadPlugins(list, PluginManagerMain.mapToPluginIds(plugins2), onInstallRunnable, cleanupRunnable);
            }
            catch (IOException e1) {
                ourInstallingNodes.removeAll(list);
                PluginManagerMain.LOG.error((Throwable)e1);
                SwingUtilities.invokeLater(() -> IOExceptionDialog.showErrorDialog((String)IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]), (String)IdeBundle.message((String)"error.plugin.download.failed", (Object[])new Object[0])));
            }
        }
    }

    public PluginTable getPluginTable() {
        return this.myHost.getPluginTable();
    }

    private boolean userConfirm(IdeaPluginDescriptor[] selection) {
        String message = selection.length == 1 ? (selection[0] instanceof IdeaPluginDescriptorImpl ? IdeBundle.message((String)"prompt.update.plugin", (Object[])new Object[]{selection[0].getName()}) : IdeBundle.message((String)"prompt.download.and.install.plugin", (Object[])new Object[]{selection[0].getName()})) : IdeBundle.message((String)"prompt.install.several.plugins", (Object[])new Object[]{selection.length});
        return Messages.showYesNoDialog((Component)this.myHost.getMainPanel(), (String)message, (String)IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }
}

