/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.ToDoRootNode;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;

public class ScopeBasedTodosTreeStructure
extends TodoTreeStructure {
    private final ScopeChooserCombo myScopes;

    public ScopeBasedTodosTreeStructure(Project project2, ScopeChooserCombo scopes) {
        super(project2);
        this.myScopes = scopes;
    }

    @Override
    public boolean accept(PsiFile psiFile) {
        if (!psiFile.isValid()) {
            return false;
        }
        boolean isAffected = false;
        SearchScope scope = this.myScopes.getSelectedScope();
        if (scope instanceof GlobalSearchScope) {
            isAffected = ((GlobalSearchScope)scope).contains(psiFile.getVirtualFile());
        }
        return isAffected && (this.myTodoFilter != null && this.myTodoFilter.accept(this.mySearchHelper, psiFile) || this.myTodoFilter == null && this.mySearchHelper.getTodoItemsCount(psiFile) > 0);
    }

    @Override
    public boolean getIsPackagesShown() {
        return this.myArePackagesShown;
    }

    @Override
    Object getFirstSelectableElement() {
        return ((ToDoRootNode)this.myRootElement).getSummaryNode();
    }

    @Override
    protected AbstractTreeNode createRootElement() {
        return new ToDoRootNode(this.myProject, new Object(), this.myBuilder, this.mySummaryElement);
    }
}

