/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.application.options.SkipSelfSearchComponent;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.GlassPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBList;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchUtil {
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");
    private static final Pattern QUOTED = Pattern.compile("\\\"([^\\\"]+)\\\"");
    public static final String HIGHLIGHT_WITH_BORDER = "searchUtil.highlightWithBorder";
    public static final String STYLE_END = "</style>";

    private SearchUtil() {
    }

    public static void processProjectConfigurables(Project project2, HashMap<SearchableConfigurable, TreeSet<OptionDescription>> options) {
        SearchUtil.processConfigurables(ShowSettingsUtilImpl.getConfigurables(project2, false), options);
    }

    private static void processConfigurables(Configurable[] configurables, HashMap<SearchableConfigurable, TreeSet<OptionDescription>> options) {
        for (Configurable configurable : configurables) {
            if (!(configurable instanceof SearchableConfigurable)) continue;
            TreeSet<OptionDescription> configurableOptions = new TreeSet<OptionDescription>();
            if (configurable instanceof Configurable.Composite) {
                Configurable[] children2 = ((Configurable.Composite)configurable).getConfigurables();
                SearchUtil.processConfigurables(children2, options);
            }
            if (configurable instanceof SearchableConfigurable.Parent && !((SearchableConfigurable.Parent)configurable).isVisible()) continue;
            options.put((SearchableConfigurable)configurable, configurableOptions);
            if (configurable instanceof MasterDetails) {
                MasterDetails md = (MasterDetails)configurable;
                md.initUi();
                SearchUtil._processComponent(configurable, configurableOptions, md.getMaster());
                SearchUtil._processComponent(configurable, configurableOptions, md.getDetails().getComponent());
                continue;
            }
            SearchUtil._processComponent(configurable, configurableOptions, configurable.createComponent());
        }
    }

    private static void _processComponent(Configurable configurable, TreeSet<OptionDescription> configurableOptions, JComponent component) {
        if (component == null) {
            return;
        }
        SearchUtil.processUILabel(configurable.getDisplayName(), configurableOptions, null);
        SearchUtil.processComponent(component, configurableOptions, null);
    }

    public static void processComponent(JComponent component, Set<OptionDescription> configurableOptions, @NonNls String path) {
        block15: {
            block14: {
                String buttonTitle;
                TitledBorder titledBorder;
                String title;
                if (component instanceof SkipSelfSearchComponent) {
                    return;
                }
                Border border = component.getBorder();
                if (border instanceof TitledBorder && (title = (titledBorder = (TitledBorder)border).getTitle()) != null) {
                    SearchUtil.processUILabel(title, configurableOptions, path);
                }
                if (component instanceof JLabel) {
                    String label = ((JLabel)component).getText();
                    if (label != null) {
                        SearchUtil.processUILabel(label, configurableOptions, path);
                    }
                } else if (component instanceof JCheckBox) {
                    String checkBoxTitle = ((JCheckBox)component).getText();
                    if (checkBoxTitle != null) {
                        SearchUtil.processUILabel(checkBoxTitle, configurableOptions, path);
                    }
                } else if (component instanceof JRadioButton) {
                    String radioButtonTitle = ((JRadioButton)component).getText();
                    if (radioButtonTitle != null) {
                        SearchUtil.processUILabel(radioButtonTitle, configurableOptions, path);
                    }
                } else if (component instanceof JButton && (buttonTitle = ((JButton)component).getText()) != null) {
                    SearchUtil.processUILabel(buttonTitle, configurableOptions, path);
                }
                if (!(component instanceof JTabbedPane)) break block14;
                JTabbedPane tabbedPane = (JTabbedPane)component;
                int tabCount = tabbedPane.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    String title2 = path != null ? path + '.' + tabbedPane.getTitleAt(i) : tabbedPane.getTitleAt(i);
                    SearchUtil.processUILabel(title2, configurableOptions, title2);
                    Component tabComponent = tabbedPane.getComponentAt(i);
                    if (!(tabComponent instanceof JComponent)) continue;
                    SearchUtil.processComponent((JComponent)tabComponent, configurableOptions, title2);
                }
                break block15;
            }
            Component[] components = component.getComponents();
            if (components == null) break block15;
            for (Component child : components) {
                if (!(child instanceof JComponent)) continue;
                SearchUtil.processComponent((JComponent)child, configurableOptions, path);
            }
        }
    }

    private static void processUILabel(@NonNls String title, Set<OptionDescription> configurableOptions, String path) {
        Set words = SearchableOptionsRegistrar.getInstance().getProcessedWordsWithoutStemming(title);
        String regex = "[\\W&&[^\\p{Punct}\\p{Blank}]]";
        for (String option : words) {
            configurableOptions.add(new OptionDescription(option, HTML_PATTERN.matcher(title).replaceAll(" ").replaceAll("[\\W&&[^\\p{Punct}\\p{Blank}]]", " "), path));
        }
    }

    public static Runnable lightOptions(SearchableConfigurable configurable, JComponent component, String option, GlassPanel glassPanel) {
        return () -> {
            if (!SearchUtil.traverseComponentsTree(configurable, glassPanel, component, option, true)) {
                SearchUtil.traverseComponentsTree(configurable, glassPanel, component, option, false);
            }
        };
    }

    private static int getSelection(String tabIdx, JTabbedPane tabbedPane) {
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            Set pathWords = searchableOptionsRegistrar.getProcessedWords(tabIdx);
            String title = tabbedPane.getTitleAt(i);
            if (!pathWords.isEmpty()) {
                Set titleWords = searchableOptionsRegistrar.getProcessedWords(title);
                pathWords.removeAll(titleWords);
                if (!pathWords.isEmpty()) continue;
                return i;
            }
            if (!tabIdx.equalsIgnoreCase(title)) continue;
            return i;
        }
        return -1;
    }

    public static int getSelection(String tabIdx, TabbedPaneWrapper tabbedPane) {
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            Set pathWords = searchableOptionsRegistrar.getProcessedWords(tabIdx);
            String title = tabbedPane.getTitleAt(i);
            Set titleWords = searchableOptionsRegistrar.getProcessedWords(title);
            pathWords.removeAll(titleWords);
            if (!pathWords.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private static boolean traverseComponentsTree(SearchableConfigurable configurable, GlassPanel glassPanel, JComponent rootComponent, String option, boolean force) {
        Component[] components;
        int index;
        String path;
        rootComponent.putClientProperty(HIGHLIGHT_WITH_BORDER, null);
        if (option == null || option.trim().length() == 0) {
            return false;
        }
        boolean highlight = false;
        if (rootComponent instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)rootComponent;
            if (SearchUtil.isComponentHighlighted(checkBox.getText(), option, force, configurable)) {
                highlight = true;
                glassPanel.addSpotlight(checkBox);
            }
        } else if (rootComponent instanceof JRadioButton) {
            JRadioButton radioButton = (JRadioButton)rootComponent;
            if (SearchUtil.isComponentHighlighted(radioButton.getText(), option, force, configurable)) {
                highlight = true;
                glassPanel.addSpotlight(radioButton);
            }
        } else if (rootComponent instanceof JLabel) {
            JLabel label = (JLabel)rootComponent;
            if (SearchUtil.isComponentHighlighted(label.getText(), option, force, configurable)) {
                highlight = true;
                glassPanel.addSpotlight(label);
            }
        } else if (rootComponent instanceof JButton) {
            JButton button = (JButton)rootComponent;
            if (SearchUtil.isComponentHighlighted(button.getText(), option, force, configurable)) {
                highlight = true;
                glassPanel.addSpotlight(button);
            }
        } else if (rootComponent instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)rootComponent;
            path = SearchableOptionsRegistrar.getInstance().getInnerPath(configurable, option);
            if (path != null && (index = SearchUtil.getSelection(path, tabbedPane)) > -1 && index < tabbedPane.getTabCount() && tabbedPane.getTabComponentAt(index) instanceof JComponent) {
                glassPanel.addSpotlight((JComponent)tabbedPane.getTabComponentAt(index));
            }
        } else if (rootComponent instanceof TabbedPaneWrapper.TabbedPaneHolder) {
            TabbedPaneWrapper tabbedPaneWrapper = ((TabbedPaneWrapper.TabbedPaneHolder)rootComponent).getTabbedPaneWrapper();
            path = SearchableOptionsRegistrar.getInstance().getInnerPath(configurable, option);
            if (path != null && (index = SearchUtil.getSelection(path, tabbedPaneWrapper)) > -1 && index < tabbedPaneWrapper.getTabCount()) {
                glassPanel.addSpotlight((JComponent)tabbedPaneWrapper.getTabComponentAt(index));
            }
        }
        for (Component component : components = rootComponent.getComponents()) {
            String title;
            Border border;
            if (!(component instanceof JComponent)) continue;
            boolean innerHighlight = SearchUtil.traverseComponentsTree(configurable, glassPanel, (JComponent)component, option, force);
            if (!highlight && !innerHighlight && (border = rootComponent.getBorder()) instanceof TitledBorder && SearchUtil.isComponentHighlighted(title = ((TitledBorder)border).getTitle(), option, force, configurable)) {
                highlight = true;
                glassPanel.addSpotlight(rootComponent);
                rootComponent.putClientProperty(HIGHLIGHT_WITH_BORDER, Boolean.TRUE);
            }
            if (!innerHighlight) continue;
            highlight = true;
        }
        return highlight;
    }

    public static boolean isComponentHighlighted(String text, String option, boolean force, SearchableConfigurable configurable) {
        Set options;
        if (text == null || option == null || option.length() == 0) {
            return false;
        }
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set words = searchableOptionsRegistrar.getProcessedWords(option);
        Set set = options = configurable != null ? searchableOptionsRegistrar.replaceSynonyms(words, configurable) : words;
        if (options == null || options.isEmpty()) {
            return text.toLowerCase().indexOf(option.toLowerCase()) != -1;
        }
        Set tokens = searchableOptionsRegistrar.getProcessedWords(text);
        if (!force) {
            options.retainAll(tokens);
            boolean highlight = !options.isEmpty();
            return highlight || text.toLowerCase().indexOf(option.toLowerCase()) != -1;
        }
        options.removeAll(tokens);
        return options.isEmpty();
    }

    public static String markup(@NonNls @NotNull String textToMarkup, @Nullable String filter) {
        String foot;
        String head;
        if (textToMarkup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textToMarkup", "com/intellij/ide/ui/search/SearchUtil", "markup"));
        }
        if (filter == null || filter.length() == 0) {
            return textToMarkup;
        }
        int bodyStart = textToMarkup.indexOf("<body>");
        int bodyEnd = textToMarkup.indexOf("</body>");
        if (bodyStart >= 0) {
            head = textToMarkup.substring(0, bodyStart += "<body>".length());
            foot = bodyEnd >= 0 ? textToMarkup.substring(bodyEnd) : "";
            textToMarkup = textToMarkup.substring(bodyStart, bodyEnd);
        } else {
            foot = "";
            head = "";
        }
        Pattern insideHtmlTagPattern = Pattern.compile("[<[^<>]*>]*<[^<>]*");
        SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
        HashSet<String> quoted = new HashSet<String>();
        filter = SearchUtil.processFilter(SearchUtil.quoteStrictOccurrences(textToMarkup, filter), quoted);
        Set options = registrar.getProcessedWords(filter);
        Set words = registrar.getProcessedWords(textToMarkup);
        for (String option : options) {
            if (!words.contains(option)) continue;
            textToMarkup = SearchUtil.markup(textToMarkup, insideHtmlTagPattern, option);
        }
        for (String stripped : quoted) {
            if (registrar.isStopWord(stripped)) continue;
            textToMarkup = SearchUtil.markup(textToMarkup, insideHtmlTagPattern, stripped);
        }
        return head + textToMarkup + foot;
    }

    private static String quoteStrictOccurrences(String textToMarkup, String filter) {
        String cur = "";
        String s = textToMarkup.toLowerCase();
        for (String part : filter.split(" ")) {
            cur = s.contains(part) ? cur + "\"" + part + "\" " : cur + part + " ";
        }
        return cur;
    }

    private static String markup(@NonNls String textToMarkup, Pattern insideHtmlTagPattern, String option) {
        int styleIdx = textToMarkup.indexOf("<style");
        int styleEndIdx = textToMarkup.indexOf(STYLE_END);
        if (styleIdx < 0 || styleEndIdx < 0) {
            return SearchUtil.markupInText(textToMarkup, insideHtmlTagPattern, option);
        }
        return SearchUtil.markup(textToMarkup.substring(0, styleIdx), insideHtmlTagPattern, option) + SearchUtil.markup(textToMarkup.substring(styleEndIdx + STYLE_END.length()), insideHtmlTagPattern, option);
    }

    private static String markupInText(String textToMarkup, Pattern insideHtmlTagPattern, String option) {
        int idx;
        String result2 = "";
        int beg = 0;
        while ((idx = StringUtil.indexOfIgnoreCase((String)textToMarkup, (String)option, (int)beg)) != -1) {
            String prefix = textToMarkup.substring(beg, idx);
            String toMark = textToMarkup.substring(idx, idx + option.length());
            if (insideHtmlTagPattern.matcher(prefix).matches()) {
                int lastIdx = textToMarkup.indexOf(">", idx);
                result2 = result2 + prefix + textToMarkup.substring(idx, lastIdx + 1);
                beg = lastIdx + 1;
                continue;
            }
            result2 = result2 + prefix + "<font color='#ffffff' bgColor='#1d5da7'>" + toMark + "</font>";
            beg = idx + option.length();
        }
        result2 = result2 + textToMarkup.substring(beg);
        return result2;
    }

    public static void appendFragments(String filter, @NonNls String text, @SimpleTextAttributes.StyleAttributeConstant int style, Color foreground, Color background, SimpleColoredComponent textRenderer) {
        if (text == null) {
            return;
        }
        if (filter == null || filter.length() == 0) {
            textRenderer.append(text, new SimpleTextAttributes(background, foreground, (Color)JBColor.RED, style));
        } else {
            HashSet<String> quoted = new HashSet<String>();
            filter = SearchUtil.processFilter(SearchUtil.quoteStrictOccurrences(text, filter), quoted);
            TreeMap<Integer, String> indx = new TreeMap<Integer, String>();
            for (String stripped : quoted) {
                int idx;
                int beg = 0;
                while ((idx = StringUtil.indexOfIgnoreCase((String)text, (String)stripped, (int)beg)) != -1) {
                    indx.put(idx, text.substring(idx, idx + stripped.length()));
                    beg = idx + stripped.length();
                }
            }
            ArrayList<String> selectedWords = new ArrayList<String>();
            int pos = 0;
            for (Integer index : indx.keySet()) {
                String stripped = (String)indx.get(index);
                int start = index;
                if (pos > start) {
                    String highlighted = (String)selectedWords.get(selectedWords.size() - 1);
                    if (highlighted.length() >= stripped.length()) continue;
                    selectedWords.remove(highlighted);
                }
                SearchUtil.appendSelectedWords(text, selectedWords, pos, start, filter);
                selectedWords.add(stripped);
                pos = start + stripped.length();
            }
            SearchUtil.appendSelectedWords(text, selectedWords, pos, text.length(), filter);
            int idx = 0;
            for (String word : selectedWords) {
                String before = (text = text.substring(idx)).substring(0, text.indexOf(word));
                if (before.length() > 0) {
                    textRenderer.append(before, new SimpleTextAttributes(background, foreground, null, style));
                }
                idx = text.indexOf(word) + word.length();
                textRenderer.append(text.substring(idx - word.length(), idx), new SimpleTextAttributes(background, foreground, null, style | 0x40));
            }
            String after2 = text.substring(idx, text.length());
            if (after2.length() > 0) {
                textRenderer.append(after2, new SimpleTextAttributes(background, foreground, null, style));
            }
        }
    }

    private static void appendSelectedWords(String text, List<String> selectedWords, int pos, int end, String filter) {
        if (pos < end) {
            String[] words;
            Set filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter);
            for (String word : words = text.substring(pos, end).split("[\\W&&[^-]]+")) {
                if (!filters.contains(PorterStemmerUtil.stem(word.toLowerCase()))) continue;
                selectedWords.add(word);
            }
        }
    }

    @Nullable
    private static JBPopup createPopup(final ConfigurableSearchTextField searchField, final JBPopup[] activePopup, Alarm showHintAlarm, Consumer<String> selectConfigurable, Project project2, int down) {
        String filter = searchField.getText();
        if (filter == null || filter.length() == 0) {
            return null;
        }
        Map hints = SearchableOptionsRegistrar.getInstance().findPossibleExtension(filter, project2);
        DefaultListModel<String> model = new DefaultListModel<String>();
        JBList list = new JBList(model);
        for (String groupName : hints.keySet()) {
            model.addElement(groupName);
            Set descriptions = (Set)hints.get(groupName);
            if (descriptions == null) continue;
            for (String hit : descriptions) {
                if (hit == null) continue;
                model.addElement((String)new OptionDescription(null, groupName, hit, null));
            }
        }
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof String) {
                    this.setText("------ " + value + " ------");
                } else if (value instanceof OptionDescription) {
                    this.setText(((OptionDescription)value).getHit());
                }
                return rendererComponent;
            }
        });
        if (model.size() > 0) {
            Runnable onChosen = () -> SearchUtil.lambda$createPopup$2((JList)list, searchField, showHintAlarm, selectConfigurable);
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setItemChoosenCallback(onChosen).setRequestFocus(down != 0).createPopup();
            list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() != 10 && e.getKeyCode() != 38 && e.getKeyCode() != 40 && e.getKeyCode() != 33 && e.getKeyCode() != 34) {
                        searchField.requestFocusInWindow();
                        if (SearchUtil.cancelPopups(activePopup) && e.getKeyCode() == 27) {
                            return;
                        }
                        if (e.getKeyChar() != '\uffff') {
                            searchField.process(new KeyEvent((Component)((Object)searchField), 400, e.getWhen(), e.getModifiers(), 0, e.getKeyChar()));
                        }
                    }
                }
            });
            if (down > 0) {
                if (list.getSelectedIndex() < list.getModel().getSize() - 1) {
                    list.setSelectedIndex(list.getSelectedIndex() + 1);
                }
            } else if (down < 0 && list.getSelectedIndex() > 0) {
                list.setSelectedIndex(list.getSelectedIndex() - 1);
            }
            return popup;
        }
        return null;
    }

    private static boolean cancelPopups(JBPopup[] activePopup) {
        for (JBPopup popup : activePopup) {
            if (popup == null || !popup.isVisible()) continue;
            popup.cancel();
            return true;
        }
        return false;
    }

    public static List<Set<String>> findKeys(String filter, Set<String> quoted) {
        filter = SearchUtil.processFilter(filter.toLowerCase(), quoted);
        ArrayList<Set<String>> keySetList = new ArrayList<Set<String>>();
        SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set words = optionsRegistrar.getProcessedWords(filter);
        for (String word : words) {
            Set<OptionDescription> descriptions = ((SearchableOptionsRegistrarImpl)optionsRegistrar).getAcceptableDescriptions(word);
            HashSet<String> keySet = new HashSet<String>();
            if (descriptions != null) {
                for (OptionDescription description : descriptions) {
                    keySet.add(description.getPath());
                }
            }
            keySetList.add(keySet);
        }
        if (keySetList.isEmpty() && !StringUtil.isEmptyOrSpaces((String)filter)) {
            keySetList.add(Collections.singleton(filter));
        }
        return keySetList;
    }

    public static String processFilter(String filter, Set<String> quoted) {
        String withoutQuoted = "";
        int beg = 0;
        Matcher matcher = QUOTED.matcher(filter);
        while (matcher.find()) {
            int start = matcher.start(1);
            withoutQuoted = withoutQuoted + " " + filter.substring(beg, start);
            beg = matcher.end(1);
            String trimmed = filter.substring(start, beg).trim();
            if (trimmed.length() <= 0) continue;
            quoted.add(trimmed);
        }
        return withoutQuoted + " " + filter.substring(beg);
    }

    public static List<Configurable> expand(ConfigurableGroup[] groups) {
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        for (ConfigurableGroup eachGroup : groups) {
            result2.addAll(SearchUtil.expandGroup(eachGroup));
        }
        return result2;
    }

    public static List<Configurable> expandGroup(ConfigurableGroup group) {
        Object[] configurables = group.getConfigurables();
        ArrayList<Configurable> result2 = new ArrayList();
        ContainerUtil.addAll(result2, (Object[])configurables);
        for (Object each : configurables) {
            SearchUtil.addChildren((Configurable)each, result2);
        }
        result2 = ContainerUtil.filter(result2, configurable -> !(configurable instanceof SearchableConfigurable.Parent) || ((SearchableConfigurable.Parent)configurable).isVisible());
        return result2;
    }

    private static void addChildren(Configurable configurable, List<Configurable> list) {
        if (configurable instanceof Configurable.Composite) {
            Configurable[] kids;
            for (Configurable eachKid : kids = ((Configurable.Composite)configurable).getConfigurables()) {
                list.add(eachKid);
                SearchUtil.addChildren(eachKid, list);
            }
        }
    }

    private static /* synthetic */ void lambda$createPopup$2(JList list, ConfigurableSearchTextField searchField, Alarm showHintAlarm, Consumer selectConfigurable) {
        Object selectedValue = list.getSelectedValue();
        if (selectedValue instanceof OptionDescription) {
            OptionDescription description = (OptionDescription)selectedValue;
            searchField.setText(description.getHit());
            searchField.addCurrentTextToHistory();
            SwingUtilities.invokeLater(() -> {
                showHintAlarm.cancelAllRequests();
                selectConfigurable.consume((Object)description.getConfigurableId());
            });
        }
    }

    public static class ConfigurableSearchTextField
    extends SearchTextFieldWithStoredHistory {
        public ConfigurableSearchTextField() {
            super("ALL_CONFIGURABLES_PANEL_SEARCH_HISTORY");
        }

        public void process(KeyEvent e) {
            ((SearchTextField.TextFieldWithProcessing)this.getTextEditor()).processKeyEvent(e);
        }
    }
}

