/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.structureView.newStructureView.TreeActionWrapper;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.structureView.newStructureView.TreeModelWrapper;
import com.intellij.ide.util.ActionShortcutProvider;
import com.intellij.ide.util.FileStructureFilter;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.StructureViewCompositeModel;
import com.intellij.ide.util.TreeStructureActionsOwner;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.SmartTreeStructure;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeStructureUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBTreeWithHintProvider;
import com.intellij.ui.PlaceProvider;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.SpeedSearchObjectWithWeight;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.treeStructure.AlwaysExpandedTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStructurePopup
implements Disposable,
TreeActionsOwner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.FileStructurePopup");
    private final Project myProject;
    private final StructureViewModel myTreeModel;
    private final StructureViewModel myBaseTreeModel;
    private final TreeStructureActionsOwner myTreeActionsOwner;
    private PsiFile myPsiFile;
    private JBPopup myPopup;
    @NonNls
    private static final String narrowDownPropertyKey = "FileStructurePopup.narrowDown";
    private final FileStructureTree myTree;
    private final FilteringTreeBuilder myAbstractTreeBuilder;
    private String myTitle;
    private final TreeSpeedSearch mySpeedSearch;
    private final SmartTreeStructure myTreeStructure;
    private int myPreferredWidth;
    private final FilteringTreeStructure myFilteringStructure;
    private final PsiElement myInitialPsiElement;
    private final Map<Class, JCheckBox> myCheckBoxes;
    private final List<JCheckBox> myAutoClicked;
    private String myTestSearchFilter;
    private final ActionCallback myTreeHasBuilt;
    private boolean myInitialNodeIsLeaf;
    private final List<Pair<String, JCheckBox>> myTriggeredCheckboxes;
    private final TreeExpander myTreeExpander;
    @NotNull
    private final FileEditor myFileEditor;
    private final StructureView myStructureViewDelegate;
    private boolean myCanClose;

    public FileStructurePopup(@NotNull Project project2, @NotNull FileEditor fileEditor, @NotNull StructureView structureView, boolean applySortAndFilter) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/FileStructurePopup", "<init>"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/ide/util/FileStructurePopup", "<init>"));
        }
        if (structureView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structureView", "com/intellij/ide/util/FileStructurePopup", "<init>"));
        }
        this.myCheckBoxes = new HashMap<Class, JCheckBox>();
        this.myAutoClicked = new ArrayList<JCheckBox>();
        this.myTreeHasBuilt = new ActionCallback();
        this.myTriggeredCheckboxes = new ArrayList<Pair<String, JCheckBox>>();
        this.myCanClose = true;
        this.myProject = project2;
        this.myFileEditor = fileEditor;
        this.myStructureViewDelegate = structureView;
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).disableUpdateByTimer((Disposable)this);
        IdeFocusManager.getInstance((Project)this.myProject).typeAheadUntil(this.myTreeHasBuilt);
        Disposer.register((Disposable)this, (Disposable)this.myStructureViewDelegate);
        if (this.myFileEditor instanceof TextEditor) {
            Editor e = ((TextEditor)this.myFileEditor).getEditor();
            this.myPsiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(e.getDocument());
        }
        if (this.myStructureViewDelegate instanceof StructureViewComposite) {
            StructureViewComposite.StructureViewDescriptor[] views = ((StructureViewComposite)this.myStructureViewDelegate).getStructureViews();
            this.myBaseTreeModel = new StructureViewCompositeModel(this.myPsiFile, views);
            Disposer.register((Disposable)this, (Disposable)((Disposable)this.myBaseTreeModel));
        } else {
            this.myBaseTreeModel = this.myStructureViewDelegate.getTreeModel();
        }
        if (applySortAndFilter) {
            this.myTreeActionsOwner = new TreeStructureActionsOwner(this.myBaseTreeModel);
            this.myTreeModel = new TreeModelWrapper(this.myBaseTreeModel, this.myTreeActionsOwner);
        } else {
            this.myTreeActionsOwner = null;
            this.myTreeModel = this.myStructureViewDelegate.getTreeModel();
        }
        this.myTreeStructure = new SmartTreeStructure(project2, (TreeModel)this.myTreeModel){

            @Override
            public void rebuildTree() {
                if (ApplicationManager.getApplication().isUnitTestMode() || !FileStructurePopup.this.myPopup.isDisposed()) {
                    super.rebuildTree();
                }
            }

            public boolean isToBuildChildrenInBackground(Object element) {
                return this.getRootElement() == element;
            }

            @Override
            protected TreeElementWrapper createTree() {
                return new StructureViewComponent.StructureViewTreeElementWrapper(this.myProject, this.myModel.getRoot(), this.myModel);
            }

            @NonNls
            public String toString() {
                return "structure view tree structure(model=" + FileStructurePopup.this.myTreeModel + ")";
            }
        };
        this.myTree = new FileStructureTree(this.myTreeStructure.getRootElement(), false);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.myTree.setTransferHandler(new TransferHandler(){

            @Override
            public boolean importData(@NotNull TransferHandler.TransferSupport support) {
                if (support == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/ide/util/FileStructurePopup$2", "importData"));
                }
                String s = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
                if (s != null && !FileStructurePopup.this.mySpeedSearch.isPopupActive()) {
                    FileStructurePopup.this.mySpeedSearch.showPopup(s);
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent component) {
                Set nodes = FileStructurePopup.this.myAbstractTreeBuilder.getSelectedElements();
                if (nodes.isEmpty()) {
                    return null;
                }
                ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)nodes.size());
                for (Object o : nodes) {
                    if (!(o instanceof FilteringTreeStructure.FilteringNode)) continue;
                    FilteringTreeStructure.FilteringNode node = (FilteringTreeStructure.FilteringNode)o;
                    PsiElement psi = FileStructurePopup.this.getPsi(node);
                    ContainerUtil.addIfNotNull((Collection)result2, (Object)Pair.create((Object)node, (Object)psi));
                }
                Set psiSelection = ContainerUtil.map2LinkedSet((Collection)result2, (Function)Functions.pairSecond());
                String text = StringUtil.join((Collection)result2, pair -> {
                    PsiElement psi = (PsiElement)pair.second;
                    String defaultPresentation = ((FilteringTreeStructure.FilteringNode)pair.first).getPresentation().getPresentableText();
                    if (psi == null) {
                        return defaultPresentation;
                    }
                    for (PsiElement p = psi.getParent(); p != null; p = p.getParent()) {
                        if (!psiSelection.contains(p)) continue;
                        return null;
                    }
                    return (String)ObjectUtils.chooseNotNull((Object)psi.getText(), (Object)defaultPresentation);
                }, (String)"\n");
                String htmlText = "<body>\n" + text + "\n</body>";
                return new TextTransferable(XmlStringUtil.wrapInHtml((CharSequence)htmlText), text);
            }

            @Override
            public int getSourceActions(JComponent component) {
                return 1;
            }
        });
        this.mySpeedSearch = new MyTreeSpeedSearch();
        this.mySpeedSearch.setComparator(new SpeedSearchComparator(false, true){

            @Override
            @NotNull
            protected MinusculeMatcher createMatcher(@NotNull String pattern) {
                if (pattern == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/FileStructurePopup$3", "createMatcher"));
                }
                MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)pattern).withSeparators(" ()").build();
                if (minusculeMatcher == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/FileStructurePopup$3", "createMatcher"));
                }
                return minusculeMatcher;
            }
        });
        FileStructurePopupFilter filter = new FileStructurePopupFilter();
        this.myFilteringStructure = new FilteringTreeStructure((ElementFilter)filter, (AbstractTreeStructure)this.myTreeStructure, ApplicationManager.getApplication().isUnitTestMode());
        this.myAbstractTreeBuilder = new FilteringTreeBuilder(this.myTree, filter, (AbstractTreeStructure)this.myFilteringStructure, null){

            public void initRootNode() {
            }

            protected boolean validateNode(Object child) {
                return StructureViewComponent.isValid(child);
            }

            public void revalidateTree() {
            }

            public boolean isToEnsureSelectionOnFocusGained() {
                return false;
            }
        };
        this.myTreeExpander = new DefaultTreeExpander((JTree)((Object)this.myTree));
        final ModelListener modelListener = new ModelListener(){

            public void onModelChanged() {
                FileStructurePopup.this.myAbstractTreeBuilder.queueUpdate();
            }
        };
        this.myTreeModel.addModelListener(modelListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                FileStructurePopup.this.myTreeModel.removeModelListener(modelListener);
            }
        });
        this.myAbstractTreeBuilder.getUi().getUpdater().setDelay(1);
        this.myInitialPsiElement = this.getCurrentElement(this.myPsiFile);
        Disposer.register((Disposable)this, (Disposable)this.myAbstractTreeBuilder);
        TreeUtil.installActions((JTree)((Object)this.myTree));
    }

    public void show() {
        JComponent panel = this.createCenterPanel();
        MnemonicHelper.init((Component)panel);
        boolean shouldSetWidth = DimensionService.getInstance().getSize(FileStructurePopup.getDimensionServiceKey(), this.myProject) == null;
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(panel, null).setTitle(this.myTitle).setResizable(true).setModalContext(false).setFocusable(true).setRequestFocus(true).setMovable(true).setBelongsToGlobalPopupStack(true).setCancelKeyEnabled(false).setDimensionServiceKey(null, FileStructurePopup.getDimensionServiceKey(), false).setCancelCallback(() -> {
            DimensionService.getInstance().setLocation(FileStructurePopup.getDimensionServiceKey(), this.myPopup.getLocationOnScreen(), this.myProject);
            return this.myCanClose;
        }).createPopup();
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PopupUpdateProcessor updateProcessor;
                if (FileStructurePopup.this.myPopup.isVisible() && (updateProcessor = (PopupUpdateProcessor)((Object)FileStructurePopup.this.myPopup.getUserData(PopupUpdateProcessor.class))) != null) {
                    AbstractTreeNode node = FileStructurePopup.this.getSelectedNode();
                    updateProcessor.updatePopup(node);
                }
            }
        });
        Disposer.register((Disposable)this.myPopup, (Disposable)this);
        Disposer.register((Disposable)this.myPopup, (Disposable)new Disposable(){

            public void dispose() {
                if (!FileStructurePopup.this.myTreeHasBuilt.isDone()) {
                    FileStructurePopup.this.myTreeHasBuilt.setRejected();
                }
            }
        });
        this.myTree.getEmptyText().setText("Loading...");
        Point location = DimensionService.getInstance().getLocation(FileStructurePopup.getDimensionServiceKey(), this.myProject);
        if (location != null) {
            this.myPopup.showInScreenCoordinates((Component)this.myFileEditor.getComponent(), location);
        } else {
            this.myPopup.showCenteredInCurrentWindow(this.myProject);
        }
        ((AbstractPopup)this.myPopup).setShowHints(true);
        if (shouldSetWidth) {
            this.myPopup.setSize(new Dimension(this.myPreferredWidth + 10, this.myPopup.getSize().height));
        }
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)this.myTree), true);
        SwingUtilities.windowForComponent(this.myPopup.getContent()).addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                FileStructurePopup.this.myPopup.cancel();
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ApplicationManager.getApplication().runReadAction(() -> this.myFilteringStructure.rebuild());
            SwingUtilities.invokeLater(() -> {
                this.myAbstractTreeBuilder.queueUpdate().doWhenDone(() -> {
                    this.myTreeHasBuilt.setDone();
                    SwingUtilities.invokeLater(() -> {
                        if (this.myAbstractTreeBuilder.isDisposed()) {
                            return;
                        }
                        if (this.selectPsiElement(this.myInitialPsiElement) == null) {
                            TreeUtil.ensureSelection((JTree)this.myAbstractTreeBuilder.getTree());
                            this.myAbstractTreeBuilder.revalidateTree();
                        }
                    });
                });
                this.installUpdater();
            });
        });
    }

    private void installUpdater() {
        if (ApplicationManager.getApplication().isUnitTestMode() || this.myPopup.isDisposed()) {
            return;
        }
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myPopup);
        alarm.addRequest(new Runnable(){
            String filter = "";

            @Override
            public void run() {
                alarm.cancelAllRequests();
                String prefix = FileStructurePopup.this.mySpeedSearch.getEnteredPrefix();
                FileStructurePopup.this.myTree.getEmptyText().setText(StringUtil.isEmpty((String)prefix) ? "Nothing to show" : "Can't find '" + prefix + "'");
                if (prefix == null) {
                    prefix = "";
                }
                if (!this.filter.equals(prefix)) {
                    boolean isBackspace = prefix.length() < this.filter.length();
                    this.filter = prefix;
                    FileStructurePopup.this.myAbstractTreeBuilder.refilter(null, false, false).doWhenProcessed(() -> SwingUtilities.invokeLater(() -> {
                        if (FileStructurePopup.this.myAbstractTreeBuilder.isDisposed()) {
                            return;
                        }
                        FileStructurePopup.this.myTree.repaint();
                        if (isBackspace && FileStructurePopup.this.handleBackspace(this.filter)) {
                            return;
                        }
                        if (FileStructurePopup.this.myFilteringStructure.getRootElement().getChildren().length == 0) {
                            for (JCheckBox box : FileStructurePopup.this.myCheckBoxes.values()) {
                                if (box.isSelected()) continue;
                                FileStructurePopup.this.myAutoClicked.add(box);
                                FileStructurePopup.this.myTriggeredCheckboxes.add(0, Pair.create((Object)this.filter, (Object)box));
                                box.doClick();
                                this.filter = "";
                                break;
                            }
                        }
                    }));
                }
                if (!alarm.isDisposed()) {
                    alarm.addRequest((Runnable)this, 300);
                }
            }
        }, 300);
    }

    private boolean handleBackspace(String filter) {
        Pair<String, JCheckBox> next;
        boolean clicked = false;
        Iterator<Pair<String, JCheckBox>> iterator = this.myTriggeredCheckboxes.iterator();
        while (iterator.hasNext() && ((String)(next = iterator.next()).getFirst()).length() >= filter.length()) {
            if (((String)next.getFirst()).length() < filter.length()) continue;
            iterator.remove();
            ((JCheckBox)next.getSecond()).doClick();
            clicked = true;
        }
        return clicked;
    }

    @Nullable
    public FilteringTreeStructure.FilteringNode selectPsiElement(PsiElement element) {
        Set<PsiElement> parents = FileStructurePopup.getAllParents(element);
        FilteringTreeStructure.FilteringNode node = (FilteringTreeStructure.FilteringNode)this.myAbstractTreeBuilder.getRootElement();
        if (element != null && node != null && this.myStructureViewDelegate instanceof StructureViewComposite) {
            parents.remove(element.getContainingFile());
            List fileNodes = node.children();
            for (FilteringTreeStructure.FilteringNode fileNode : fileNodes) {
                FilteringTreeStructure.FilteringNode found = this.findNode(parents, fileNode);
                if (found == null || found == fileNode) continue;
                return found;
            }
        } else {
            FilteringTreeStructure.FilteringNode found = this.findNode(parents, node);
            if (found == null) {
                TreeUtil.ensureSelection((JTree)((Object)this.myTree));
            }
            return found;
        }
        TreeUtil.ensureSelection((JTree)((Object)this.myTree));
        return null;
    }

    private FilteringTreeStructure.FilteringNode findNode(Set<PsiElement> parents, FilteringTreeStructure.FilteringNode node) {
        while (node != null) {
            boolean changed = false;
            for (FilteringTreeStructure.FilteringNode n : node.children()) {
                PsiElement psiElement = this.getPsi(n);
                if (psiElement == null || !parents.contains(psiElement)) continue;
                node = n;
                changed = true;
                break;
            }
            if (changed) continue;
            this.myAbstractTreeBuilder.select((Object)node);
            if (this.myAbstractTreeBuilder.getSelectedElements().isEmpty()) {
                TreeUtil.selectFirstNode((JTree)((Object)this.myTree));
            }
            this.myInitialNodeIsLeaf = node.getChildren().length == 0;
            return node;
        }
        return null;
    }

    private static Set<PsiElement> getAllParents(PsiElement element) {
        HashSet<PsiElement> parents = new HashSet<PsiElement>();
        while (element != null) {
            parents.add(element);
            if (element instanceof PsiFile) break;
            element = element.getParent();
        }
        return parents;
    }

    @Nullable
    private PsiElement getPsi(FilteringTreeStructure.FilteringNode n) {
        Object element;
        TreeElement value;
        Object delegate = n.getDelegate();
        if (delegate instanceof StructureViewComponent.StructureViewTreeElementWrapper && (value = (TreeElement)((StructureViewComponent.StructureViewTreeElementWrapper)((Object)delegate)).getValue()) instanceof StructureViewTreeElement && (element = ((StructureViewTreeElement)value).getValue()) instanceof PsiElement) {
            return (PsiElement)element;
        }
        return null;
    }

    public void dispose() {
    }

    private static boolean isShouldNarrowDown() {
        return PropertiesComponent.getInstance().getBoolean(narrowDownPropertyKey, true);
    }

    @NonNls
    protected static String getDimensionServiceKey() {
        return "StructurePopup";
    }

    @Nullable
    public PsiElement getCurrentElement(@Nullable PsiFile psiFile) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        Object elementAtCursor = this.myTreeModel.getCurrentEditorElement();
        if (elementAtCursor instanceof PsiElement) {
            return (PsiElement)elementAtCursor;
        }
        if (psiFile != null && this.myFileEditor instanceof TextEditor) {
            return psiFile.getViewProvider().findElementAt(((TextEditor)this.myFileEditor).getEditor().getCaretModel().getOffset());
        }
        return null;
    }

    public JComponent createCenterPanel() {
        ArrayList<FileStructureFilter> fileStructureFilters = new ArrayList<FileStructureFilter>();
        ArrayList<FileStructureNodeProvider> fileStructureNodeProviders = new ArrayList<FileStructureNodeProvider>();
        if (this.myTreeActionsOwner != null) {
            for (Filter filter : this.myBaseTreeModel.getFilters()) {
                if (!(filter instanceof FileStructureFilter)) continue;
                FileStructureFilter fsFilter = (FileStructureFilter)filter;
                this.myTreeActionsOwner.setActionIncluded((TreeAction)fsFilter, true);
                fileStructureFilters.add(fsFilter);
            }
            if (this.myBaseTreeModel instanceof ProvidingTreeModel) {
                for (NodeProvider provider : ((ProvidingTreeModel)this.myBaseTreeModel).getNodeProviders()) {
                    if (!(provider instanceof FileStructureNodeProvider)) continue;
                    fileStructureNodeProviders.add((FileStructureNodeProvider)provider);
                }
            }
        }
        final JPanel panel = new JPanel(new BorderLayout());
        JPanel comboPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        Object[] F4 = ActionManager.getInstance().getAction("EditSource").getShortcutSet().getShortcuts();
        Object[] ENTER = CustomShortcutSet.fromString((String[])new String[]{"ENTER"}).getShortcuts();
        CustomShortcutSet shortcutSet = new CustomShortcutSet((Shortcut[])ArrayUtil.mergeArrays((Object[])F4, (Object[])ENTER));
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                boolean succeeded = FileStructurePopup.this.navigateSelectedElement();
                if (succeeded) {
                    this.unregisterCustomShortcutSet(panel);
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)shortcutSet, (JComponent)panel);
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                if (FileStructurePopup.this.mySpeedSearch != null && FileStructurePopup.this.mySpeedSearch.isPopupActive()) {
                    FileStructurePopup.this.mySpeedSearch.hidePopup();
                } else {
                    FileStructurePopup.this.myPopup.cancel();
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ESCAPE"}), (JComponent)((Object)this.myTree));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/FileStructurePopup$13", "onClick"));
                }
                TreePath path = FileStructurePopup.this.myTree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return false;
                }
                FileStructurePopup.this.navigateSelectedElement();
                return true;
            }
        }.installOn((Component)((Object)this.myTree));
        for (FileStructureFilter filter : fileStructureFilters) {
            this.addCheckbox(comboPanel, (TreeAction)filter);
        }
        for (FileStructureNodeProvider provider : fileStructureNodeProviders) {
            this.addCheckbox(comboPanel, (TreeAction)provider);
        }
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add(comboPanel);
        topPanel.add((Component)this.createSettingsButton(), "East");
        this.myPreferredWidth = Math.max(comboPanel.getPreferredSize().width, JBUI.scale((int)350));
        panel.add((Component)topPanel, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myAbstractTreeBuilder.getTree());
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)10));
        panel.add((Component)scrollPane, "Center");
        DataManager.registerDataProvider((JComponent)panel, (DataProvider)new DataProvider(){

            public Object getData(@NonNls String dataId) {
                if (CommonDataKeys.PROJECT.is(dataId)) {
                    return FileStructurePopup.this.myProject;
                }
                if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                    return FileStructurePopup.this.myFileEditor;
                }
                if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                    Object node = ContainerUtil.getFirstItem((Collection)FileStructurePopup.this.myAbstractTreeBuilder.getSelectedElements());
                    if (!(node instanceof FilteringTreeStructure.FilteringNode)) {
                        return null;
                    }
                    return FileStructurePopup.this.getPsi((FilteringTreeStructure.FilteringNode)node);
                }
                if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                    return ContainerUtil.toArray((Collection)FileStructurePopup.this.getPsiElementsFromSelection(), (ArrayFactory)PsiElement.ARRAY_FACTORY);
                }
                if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
                    return FileStructurePopup.this.myPopup;
                }
                if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
                    return FileStructurePopup.this.myTreeExpander;
                }
                return null;
            }
        });
        panel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FileStructurePopup.this.myPopup.cancel();
            }
        });
        return panel;
    }

    @NotNull
    private List<PsiElement> getPsiElementsFromSelection() {
        Set nodes = this.myAbstractTreeBuilder.getSelectedElements();
        if (nodes.isEmpty()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/FileStructurePopup", "getPsiElementsFromSelection"));
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)nodes.size());
        for (Object o : nodes) {
            if (!(o instanceof FilteringTreeStructure.FilteringNode)) continue;
            ContainerUtil.addIfNotNull((Collection)result2, (Object)this.getPsi((FilteringTreeStructure.FilteringNode)o));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/FileStructurePopup", "getPsiElementsFromSelection"));
        }
        return arrayList;
    }

    @NotNull
    protected JComponent createSettingsButton() {
        final JLabel label = new JLabel(AllIcons.General.SecondaryGroup);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/FileStructurePopup$16", "onClick"));
                }
                DefaultActionGroup group = new DefaultActionGroup();
                group.add((AnAction)new ToggleAction(IdeBundle.message((String)"checkbox.narrow.down.on.typing", (Object[])new Object[0])){

                    public boolean isSelected(AnActionEvent e) {
                        return FileStructurePopup.isShouldNarrowDown();
                    }

                    public void setSelected(AnActionEvent e, boolean state) {
                        PropertiesComponent.getInstance().setValue(FileStructurePopup.narrowDownPropertyKey, Boolean.toString(state));
                        if (FileStructurePopup.this.mySpeedSearch.isPopupActive() && !StringUtil.isEmpty((String)FileStructurePopup.this.mySpeedSearch.getEnteredPrefix())) {
                            FileStructurePopup.this.myAbstractTreeBuilder.queueUpdate();
                        }
                    }
                });
                DataManager dataManager = DataManager.getInstance();
                assert (dataManager != null);
                ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataManager.getDataContext((Component)label), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
                popup.addListener(new JBPopupListener(){

                    public void beforeShown(LightweightWindowEvent event) {
                    }

                    public void onClosed(LightweightWindowEvent event) {
                        FileStructurePopup.this.myCanClose = true;
                    }
                });
                FileStructurePopup.this.myCanClose = false;
                popup.showUnderneathOf((Component)label);
                return true;
            }
        }.installOn((Component)label);
        JLabel jLabel = label;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/FileStructurePopup", "createSettingsButton"));
        }
        return jLabel;
    }

    protected void addFilters(DefaultActionGroup group) {
        Filter[] filters;
        for (Filter filter : filters = this.myTreeModel.getFilters()) {
            group.add((AnAction)new TreeActionWrapper((TreeAction)filter, this));
        }
    }

    protected void addGroupers(DefaultActionGroup group) {
        Grouper[] groupers;
        for (Grouper grouper : groupers = this.myTreeModel.getGroupers()) {
            group.add((AnAction)new TreeActionWrapper((TreeAction)grouper, this));
        }
    }

    protected void addSorters(DefaultActionGroup group) {
        Sorter[] sorters;
        for (Sorter sorter : sorters = this.myTreeModel.getSorters()) {
            if (!sorter.isVisible()) continue;
            group.add((AnAction)new TreeActionWrapper((TreeAction)sorter, this));
        }
        if (sorters.length > 0) {
            group.addSeparator();
        }
    }

    @Nullable
    private AbstractTreeNode getSelectedNode() {
        Object component;
        TreePath path = this.myTree.getSelectionPath();
        if (path != null && (component = path.getLastPathComponent()) instanceof DefaultMutableTreeNode && (component = ((DefaultMutableTreeNode)component).getUserObject()) instanceof FilteringTreeStructure.FilteringNode && (component = ((FilteringTreeStructure.FilteringNode)component).getDelegate()) instanceof AbstractTreeNode) {
            return (AbstractTreeNode)component;
        }
        return null;
    }

    public boolean navigateSelectedElement() {
        AbstractTreeNode selectedNode = this.getSelectedNode();
        if (ApplicationManager.getApplication().isInternal()) {
            String enteredPrefix = this.getSpeedSearch().getEnteredPrefix();
            String itemText = FileStructurePopup.getSpeedSearchText(selectedNode);
            if (StringUtil.isNotEmpty((String)enteredPrefix) && StringUtil.isNotEmpty((String)itemText)) {
                LOG.info("Chosen in file structure popup by prefix '" + enteredPrefix + "': '" + itemText + "'");
            }
        }
        Ref succeeded = new Ref();
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            if (selectedNode != null) {
                if (selectedNode.canNavigateToSource()) {
                    this.myPopup.cancel();
                    selectedNode.navigate(true);
                    succeeded.set((Object)true);
                } else {
                    succeeded.set((Object)false);
                }
            } else {
                succeeded.set((Object)false);
            }
            IdeDocumentHistory.getInstance(this.myProject).includeCurrentCommandAsNavigation();
        }, "Navigate", null);
        return (Boolean)succeeded.get();
    }

    private void addCheckbox(JPanel panel, final TreeAction action) {
        boolean isRevertedStructureFilter;
        String text;
        String string = action instanceof FileStructureFilter ? ((FileStructureFilter)action).getCheckBoxText() : (text = action instanceof FileStructureNodeProvider ? ((FileStructureNodeProvider)action).getCheckBoxText() : null);
        if (text == null) {
            return;
        }
        Shortcut[] shortcuts = FileStructurePopup.extractShortcutFor(action);
        final JCheckBox chkFilter = new JCheckBox();
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)chkFilter);
        boolean selected = FileStructurePopup.getDefaultValue(action);
        chkFilter.setSelected(selected);
        boolean bl = isRevertedStructureFilter = action instanceof FileStructureFilter && ((FileStructureFilter)action).isReverted();
        this.myTreeActionsOwner.setActionIncluded(action, isRevertedStructureFilter ? !selected : selected);
        chkFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = chkFilter.isSelected();
                if (!FileStructurePopup.this.myAutoClicked.contains(chkFilter)) {
                    FileStructurePopup.saveState(action, state);
                }
                FileStructurePopup.this.myTreeActionsOwner.setActionIncluded(action, isRevertedStructureFilter ? !state : state);
                Object selection = ContainerUtil.getFirstItem((Collection)FileStructurePopup.this.myAbstractTreeBuilder.getSelectedElements());
                if (selection instanceof FilteringTreeStructure.FilteringNode) {
                    selection = ((FilteringTreeStructure.FilteringNode)selection).getDelegate();
                }
                FileStructurePopup.this.myTreeStructure.rebuildTree();
                FileStructurePopup.this.myFilteringStructure.rebuild();
                Object sel = selection;
                Runnable runnable2 = () -> ApplicationManager.getApplication().runReadAction(() -> FileStructurePopup.this.myAbstractTreeBuilder.refilter(sel, true, false).doWhenProcessed(() -> {
                    if (FileStructurePopup.this.mySpeedSearch.isPopupActive()) {
                        FileStructurePopup.this.mySpeedSearch.refreshSelection();
                    }
                }));
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    runnable2.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(runnable2);
                }
            }
        });
        chkFilter.setFocusable(false);
        if (shortcuts.length > 0) {
            text = text + " (" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + ")";
            new DumbAwareAction(){

                public void actionPerformed(AnActionEvent e) {
                    chkFilter.doClick();
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)((Object)this.myTree));
        }
        chkFilter.setText(text);
        panel.add(chkFilter);
        this.myCheckBoxes.put(action.getClass(), chkFilter);
    }

    @NotNull
    static Shortcut[] extractShortcutFor(@NotNull TreeAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ide/util/FileStructurePopup", "extractShortcutFor"));
        }
        if (action instanceof ActionShortcutProvider) {
            String actionId = ((ActionShortcutProvider)action).getActionIdForShortcut();
            Shortcut[] shortcutArray = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId);
            if (shortcutArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/FileStructurePopup", "extractShortcutFor"));
            }
            return shortcutArray;
        }
        Shortcut[] shortcutArray = action instanceof FileStructureFilter ? ((FileStructureFilter)action).getShortcut() : ((FileStructureNodeProvider)action).getShortcut();
        if (shortcutArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/FileStructurePopup", "extractShortcutFor"));
        }
        return shortcutArray;
    }

    private static boolean getDefaultValue(TreeAction action) {
        if (action instanceof PropertyOwner) {
            String propertyName = ((PropertyOwner)action).getPropertyName();
            return PropertiesComponent.getInstance().getBoolean(TreeStructureUtil.getPropertyName(propertyName));
        }
        return false;
    }

    private static void saveState(TreeAction action, boolean state) {
        if (action instanceof PropertyOwner) {
            String propertyName = ((PropertyOwner)action).getPropertyName();
            PropertiesComponent.getInstance().setValue(TreeStructureUtil.getPropertyName(propertyName), state);
        }
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public Tree getTree() {
        return this.myTree;
    }

    public TreeSpeedSearch getSpeedSearch() {
        return this.mySpeedSearch;
    }

    public FilteringTreeBuilder getTreeBuilder() {
        return this.myAbstractTreeBuilder;
    }

    public void setSearchFilterForTests(String filter) {
        this.myTestSearchFilter = filter;
    }

    public void setTreeActionState(Class<? extends TreeAction> action, boolean state) {
        JCheckBox checkBox = this.myCheckBoxes.get(action);
        if (checkBox != null) {
            checkBox.setSelected(state);
            for (ActionListener listener2 : checkBox.getActionListeners()) {
                listener2.actionPerformed(new ActionEvent(this, 1, ""));
            }
        }
    }

    @Nullable
    public static String getSpeedSearchText(final Object userObject) {
        String text = String.valueOf(userObject);
        if (text != null) {
            String locationString;
            TreeElement value;
            if (userObject instanceof StructureViewComponent.StructureViewTreeElementWrapper && (value = (TreeElement)((StructureViewComponent.StructureViewTreeElementWrapper)((Object)userObject)).getValue()) instanceof PsiTreeElementBase && ((PsiTreeElementBase)value).isSearchInLocationString() && !StringUtil.isEmpty((String)(locationString = ((PsiTreeElementBase)value).getLocationString()))) {
                String locationPrefix = null;
                String locationSuffix = null;
                if (value instanceof LocationPresentation) {
                    locationPrefix = ((LocationPresentation)value).getLocationPrefix();
                    locationSuffix = ((LocationPresentation)value).getLocationSuffix();
                }
                return text + StringUtil.notNullize((String)locationPrefix, (String)" (") + locationString + StringUtil.notNullize((String)locationSuffix, (String)")");
            }
            return text;
        }
        if (userObject instanceof StructureViewComponent.StructureViewTreeElementWrapper) {
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    ItemPresentation presentation = ((TreeElement)((StructureViewComponent.StructureViewTreeElementWrapper)((Object)userObject)).getValue()).getPresentation();
                    return presentation.getPresentableText();
                }
            });
        }
        return null;
    }

    @Override
    public void setActionActive(String name, boolean state) {
    }

    @Override
    public boolean isActionActive(String name) {
        return false;
    }

    @Nullable
    private String getSearchPrefix() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myTestSearchFilter;
        }
        return this.mySpeedSearch != null && !StringUtil.isEmpty((String)this.mySpeedSearch.getEnteredPrefix()) ? this.mySpeedSearch.getEnteredPrefix() : null;
    }

    class FileStructureTree
    extends JBTreeWithHintProvider
    implements AlwaysExpandedTree,
    PlaceProvider<String> {
        private final boolean fast;

        public FileStructureTree(Object rootElement, boolean fastExpand) {
            super(new DefaultMutableTreeNode(rootElement));
            if (fastExpand) {
                Hashtable hashtable = new Hashtable(){

                    @Override
                    public synchronized Object get(Object key2) {
                        return Boolean.TRUE;
                    }
                };
                this.fast = ReflectionUtil.setField(JTree.class, (Object)((Object)this), Hashtable.class, (String)"expandedState", (Object)hashtable);
            } else {
                this.fast = false;
            }
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setHorizontalAutoScrollingEnabled(false);
        }

        public boolean isAlwaysExpanded() {
            return this.fast;
        }

        public boolean isExpanded(TreePath path) {
            return this.fast || super.isExpanded(path);
        }

        public boolean isExpanded(int row) {
            return this.fast || super.isExpanded(row);
        }

        @Override
        protected PsiElement getPsiElementForHint(Object selectedValue) {
            return FileStructurePopup.this.getPsi((FilteringTreeStructure.FilteringNode)((DefaultMutableTreeNode)selectedValue).getUserObject());
        }

        public String getPlace() {
            return "StructureViewPopup";
        }
    }

    public class MyTreeSpeedSearch
    extends TreeSpeedSearch {
        public MyTreeSpeedSearch() {
            super(FileStructurePopup.this.myTree, new Convertor<TreePath, String>(){

                @Nullable
                public String convert(TreePath path) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    Object userObject = node.getUserObject();
                    if (userObject instanceof FilteringTreeStructure.FilteringNode) {
                        return FileStructurePopup.getSpeedSearchText(((FilteringTreeStructure.FilteringNode)userObject).getDelegate());
                    }
                    return "";
                }
            }, true);
        }

        @Override
        protected Point getComponentLocationOnScreen() {
            return FileStructurePopup.this.myPopup.getContent().getLocationOnScreen();
        }

        @Override
        protected Rectangle getComponentVisibleRect() {
            return FileStructurePopup.this.myPopup.getContent().getVisibleRect();
        }

        @Override
        public Object findElement(String s) {
            List<SpeedSearchObjectWithWeight> elements = SpeedSearchObjectWithWeight.findElement(s, this);
            return elements.isEmpty() ? null : this.findClosestTo(FileStructurePopup.this.myInitialPsiElement, elements);
        }

        @Nullable
        private Object findClosestTo(PsiElement path, List<SpeedSearchObjectWithWeight> paths) {
            if (path == null || FileStructurePopup.this.myInitialPsiElement == null) {
                return paths.get((int)0).node;
            }
            Set parents = FileStructurePopup.getAllParents(FileStructurePopup.this.myInitialPsiElement);
            ArrayList<SpeedSearchObjectWithWeight> cur = new ArrayList<SpeedSearchObjectWithWeight>();
            int max = -1;
            for (SpeedSearchObjectWithWeight p : paths) {
                FilteringTreeStructure.FilteringNode node;
                Object last = ((TreePath)p.node).getLastPathComponent();
                ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                Object object = ((DefaultMutableTreeNode)last).getUserObject();
                if (!(object instanceof FilteringTreeStructure.FilteringNode)) continue;
                FilteringTreeStructure.FilteringNode candidate = node = (FilteringTreeStructure.FilteringNode)object;
                while (node != null) {
                    elements.add(FileStructurePopup.this.getPsi(node));
                    node = node.getParentNode();
                }
                int size = ContainerUtil.intersection((Collection)parents, elements).size();
                if (size == elements.size() - 1 && size == parents.size() - (FileStructurePopup.this.myInitialNodeIsLeaf ? 1 : 0) && candidate.children().isEmpty()) {
                    return p.node;
                }
                if (size > max) {
                    max = size;
                    cur.clear();
                    cur.add(p);
                    continue;
                }
                if (size != max) continue;
                cur.add(p);
            }
            Collections.sort(cur, (o1, o2) -> {
                int i = o1.compareWith((SpeedSearchObjectWithWeight)o2);
                return i != 0 ? i : ((TreePath)o2.node).getPathCount() - ((TreePath)o1.node).getPathCount();
            });
            return cur.isEmpty() ? null : ((SpeedSearchObjectWithWeight)cur.get((int)0)).node;
        }
    }

    private class FileStructurePopupFilter
    implements ElementFilter {
        private String myLastFilter = null;
        private final Set<Object> myVisibleParents = new com.intellij.util.containers.HashSet();
        private final boolean isUnitTest = ApplicationManager.getApplication().isUnitTestMode();

        private FileStructurePopupFilter() {
        }

        public boolean shouldBeShowing(Object value) {
            if (!FileStructurePopup.isShouldNarrowDown()) {
                return true;
            }
            String filter = FileStructurePopup.this.getSearchPrefix();
            if (!StringUtil.equals((CharSequence)this.myLastFilter, (CharSequence)filter)) {
                this.myVisibleParents.clear();
                this.myLastFilter = filter;
            }
            if (filter != null) {
                if (this.myVisibleParents.contains(value)) {
                    return true;
                }
                String text = FileStructurePopup.getSpeedSearchText(value);
                if (text == null) {
                    return false;
                }
                if (this.matches(text)) {
                    Object o = value;
                    while (o instanceof FilteringTreeStructure.FilteringNode && (o = ((FilteringTreeStructure.FilteringNode)o).getParent()) != null) {
                        this.myVisibleParents.add(o);
                    }
                    return true;
                }
                return false;
            }
            return true;
        }

        private boolean matches(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/util/FileStructurePopup$FileStructurePopupFilter", "matches"));
            }
            if (this.isUnitTest) {
                SpeedSearchComparator comparator2 = FileStructurePopup.this.mySpeedSearch.getComparator();
                return StringUtil.isNotEmpty((String)FileStructurePopup.this.myTestSearchFilter) && comparator2.matchingFragments(FileStructurePopup.this.myTestSearchFilter, text) != null;
            }
            return FileStructurePopup.this.mySpeedSearch.matchingFragments(text) != null;
        }
    }
}

