/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.ide.util.SuperMethodWarningDialog;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class SuperMethodWarningUtil {
    private SuperMethodWarningUtil() {
    }

    @NotNull
    public static PsiMethod[] checkSuperMethods(@NotNull PsiMethod method, @NotNull String actionString) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethods"));
        }
        if (actionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionString", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethods"));
        }
        PsiMethod[] psiMethodArray = SuperMethodWarningUtil.checkSuperMethods(method, actionString, Collections.emptyList());
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] checkSuperMethods(@NotNull PsiMethod method, @NotNull String actionString, @NotNull Collection<PsiElement> ignore) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethods"));
        }
        if (actionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionString", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethods"));
        }
        if (ignore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignore", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethods"));
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            PsiMethod[] psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethods"));
            }
            return psiMethodArray;
        }
        Collection<PsiMethod> superMethods = SuperMethodWarningUtil.getSuperMethods(method, aClass, ignore);
        if (superMethods.isEmpty()) {
            PsiMethod[] psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethods"));
            }
            return psiMethodArray;
        }
        HashSet<String> superClasses = new HashSet<String>();
        boolean superAbstract = false;
        boolean parentInterface = false;
        for (PsiMethod superMethod : superMethods) {
            PsiClass containingClass = superMethod.getContainingClass();
            superClasses.add(containingClass.getQualifiedName());
            boolean isInterface = containingClass.isInterface();
            superAbstract |= isInterface || superMethod.hasModifierProperty("abstract");
            parentInterface |= isInterface;
        }
        SuperMethodWarningDialog dialog = new SuperMethodWarningDialog(method.getProject(), DescriptiveNameUtil.getDescriptiveName((PsiElement)method), actionString, superAbstract, parentInterface, aClass.isInterface(), ArrayUtil.toStringArray(superClasses));
        dialog.show();
        if (dialog.getExitCode() == 0) {
            PsiMethod[] psiMethodArray = superMethods.toArray(new PsiMethod[superMethods.size()]);
            if (psiMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethods"));
            }
            return psiMethodArray;
        }
        if (dialog.getExitCode() == 3) {
            PsiMethod[] psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethods"));
            }
            return psiMethodArray;
        }
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethods"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    static Collection<PsiMethod> getSuperMethods(@NotNull PsiMethod method, PsiClass aClass, @NotNull Collection<PsiElement> ignore) {
        PsiMethod siblingSuperMethod;
        VirtualFile virtualFile;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ide/util/SuperMethodWarningUtil", "getSuperMethods"));
        }
        if (ignore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignore", "com/intellij/ide/util/SuperMethodWarningUtil", "getSuperMethods"));
        }
        Collection superMethods = DeepestSuperMethodsSearch.search((PsiMethod)method).findAll();
        superMethods.removeAll(ignore);
        if (superMethods.isEmpty() && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)aClass)) != null && ProjectRootManager.getInstance((Project)aClass.getProject()).getFileIndex().isInSourceContent(virtualFile) && (siblingSuperMethod = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method)) != null) {
            superMethods.add(siblingSuperMethod);
        }
        Collection collection = superMethods;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/SuperMethodWarningUtil", "getSuperMethods"));
        }
        return collection;
    }

    public static PsiMethod checkSuperMethod(@NotNull PsiMethod method, @NotNull String actionString) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethod"));
        }
        if (actionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionString", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethod"));
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return method;
        }
        PsiMethod superMethod = method.findDeepestSuperMethod();
        if (superMethod == null) {
            return method;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return superMethod;
        }
        PsiClass containingClass = superMethod.getContainingClass();
        SuperMethodWarningDialog dialog = new SuperMethodWarningDialog(method.getProject(), DescriptiveNameUtil.getDescriptiveName((PsiElement)method), actionString, containingClass.isInterface() || superMethod.hasModifierProperty("abstract"), containingClass.isInterface(), aClass.isInterface(), containingClass.getQualifiedName());
        dialog.show();
        if (dialog.getExitCode() == 0) {
            return superMethod;
        }
        if (dialog.getExitCode() == 3) {
            return method;
        }
        return null;
    }

    public static void checkSuperMethod(@NotNull PsiMethod method, @NotNull String actionString, @NotNull PsiElementProcessor<PsiMethod> processor2, @NotNull Editor editor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethod"));
        }
        if (actionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionString", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethod"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethod"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ide/util/SuperMethodWarningUtil", "checkSuperMethod"));
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            processor2.execute((PsiElement)method);
            return;
        }
        PsiMethod superMethod = method.findDeepestSuperMethod();
        if (superMethod == null) {
            processor2.execute((PsiElement)method);
            return;
        }
        PsiClass containingClass = superMethod.getContainingClass();
        if (containingClass == null) {
            processor2.execute((PsiElement)method);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            processor2.execute((PsiElement)superMethod);
            return;
        }
        PsiMethod[] methods = new PsiMethod[]{superMethod, method};
        String renameBase = actionString + " base method";
        String renameCurrent = actionString + " only current method";
        JBList list = new JBList(new Object[]{renameBase, renameCurrent});
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(method.getName() + (containingClass.isInterface() && !aClass.isInterface() ? " implements" : " overrides") + " method of " + SymbolPresentationUtil.getSymbolPresentableText((PsiElement)containingClass)).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/ide/util/SuperMethodWarningUtil", "lambda$checkSuperMethod$0"));
            }
            Object value = list.getSelectedValue();
            if (value instanceof String) {
                processor2.execute((PsiElement)methods[value.equals(renameBase) ? 0 : 1]);
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    @Messages.YesNoCancelResult
    public static int askWhetherShouldAnnotateBaseMethod(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ide/util/SuperMethodWarningUtil", "askWhetherShouldAnnotateBaseMethod"));
        }
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/intellij/ide/util/SuperMethodWarningUtil", "askWhetherShouldAnnotateBaseMethod"));
        }
        String implement = !method.hasModifierProperty("abstract") && superMethod.hasModifierProperty("abstract") ? InspectionsBundle.message((String)"inspection.annotate.quickfix.implements", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.annotate.quickfix.overrides", (Object[])new Object[0]);
        String message = InspectionsBundle.message((String)"inspection.annotate.quickfix.overridden.method.messages", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)method), implement, DescriptiveNameUtil.getDescriptiveName((PsiElement)superMethod)});
        String title = InspectionsBundle.message((String)"inspection.annotate.quickfix.overridden.method.warning", (Object[])new Object[0]);
        return Messages.showYesNoCancelDialog((Project)method.getProject(), (String)message, (String)title, (Icon)Messages.getQuestionIcon());
    }
}

