/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.persistence.ApplicationStatisticsPersistence;
import com.intellij.internal.statistic.persistence.ApplicationStatisticsPersistenceComponent;
import com.intellij.internal.statistic.persistence.CollectedUsages;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ObjectIntHashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntProcedure;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractApplicationUsagesCollector
extends UsagesCollector {
    private static final Logger LOG = Logger.getInstance(AbstractApplicationUsagesCollector.class);

    public void persistProjectUsages(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        try {
            this.persistProjectUsages(project2, new CollectedUsages(this.getProjectUsages(project2), System.currentTimeMillis()));
        }
        catch (ProcessCanceledException e) {
            LOG.info((Throwable)e);
        }
        catch (CollectUsagesException e) {
            LOG.info((Throwable)e);
        }
        catch (Exception usageCollectorException) {
            LOG.info((Throwable)usageCollectorException);
        }
    }

    public void persistProjectUsages(@NotNull Project project2, @NotNull CollectedUsages usages) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        this.persistProjectUsages(project2, usages, ApplicationStatisticsPersistenceComponent.getInstance());
    }

    public void persistProjectUsages(@NotNull Project project2, @NotNull CollectedUsages usages, @NotNull ApplicationStatisticsPersistence persistence) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        if (persistence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistence", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        persistence.persistUsages(this.getGroupId(), project2, usages);
    }

    @NotNull
    public Set<UsageDescriptor> getApplicationUsages() {
        Set<UsageDescriptor> set = this.getApplicationUsages(ApplicationStatisticsPersistenceComponent.getInstance());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getApplicationUsages"));
        }
        return set;
    }

    @NotNull
    public Set<UsageDescriptor> getApplicationUsages(@NotNull ApplicationStatisticsPersistence persistence) {
        if (persistence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistence", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getApplicationUsages"));
        }
        ObjectIntHashMap result2 = new ObjectIntHashMap();
        long lastTimeSent = UsageStatisticsPersistenceComponent.getInstance().getLastTimeSent();
        for (CollectedUsages usageDescriptors : persistence.getApplicationData(this.getGroupId()).values()) {
            if (usageDescriptors.usages.isEmpty() || usageDescriptors.collectionTime <= lastTimeSent) continue;
            result2.ensureCapacity(usageDescriptors.usages.size());
            for (UsageDescriptor usageDescriptor : usageDescriptors.usages) {
                String key2 = usageDescriptor.getKey();
                result2.put((Object)key2, result2.get((Object)key2, 0) + usageDescriptor.getValue());
            }
        }
        if (result2.isEmpty()) {
            Set<UsageDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getApplicationUsages"));
            }
            return set;
        }
        final THashSet descriptors = new THashSet(result2.size());
        result2.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String key2, int value) {
                descriptors.add((Object)new UsageDescriptor(key2, value));
                return true;
            }
        });
        THashSet tHashSet = descriptors;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getApplicationUsages"));
        }
        return tHashSet;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        Set<UsageDescriptor> set = this.getApplicationUsages();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getUsages"));
        }
        return set;
    }

    @NotNull
    public abstract Set<UsageDescriptor> getProjectUsages(@NotNull Project var1) throws CollectUsagesException;
}

