/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.FileContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class DiffContentFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.ex.DiffContentFactory");

    private DiffContentFactory() {
    }

    @Nullable
    public static SimpleDiffRequest compareVirtualFiles(Project project2, VirtualFile file1, VirtualFile file2, String title) {
        FileContent content1 = DiffContent.fromFile((Project)project2, (VirtualFile)file1);
        FileContent content2 = DiffContent.fromFile((Project)project2, (VirtualFile)file2);
        if (content1 == null || content2 == null) {
            return null;
        }
        SimpleDiffRequest diffRequest = new SimpleDiffRequest(project2, title);
        diffRequest.setContents((DiffContent)content1, (DiffContent)content2);
        return diffRequest;
    }
}

