/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffToolbar;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.DiffViewerType;
import com.intellij.openapi.diff.impl.DiffToolbarComponent;
import com.intellij.openapi.diff.impl.DiffToolbarImpl;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.vcs.AbstractDataProviderPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorDiffViewer
implements DiffViewer {
    @NotNull
    private final DiffRequest myRequest;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final DiffToolbarComponent myToolbar;

    protected ErrorDiffViewer(Window window, @NotNull DiffRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/diff/impl/ErrorDiffViewer", "<init>"));
        }
        this.myRequest = request;
        this.myPanel = new AbstractDataProviderPanel(new BorderLayout(), false){

            public void calcData(DataKey key2, DataSink sink) {
                Object data = ErrorDiffViewer.this.myRequest.getGenericData().get(key2.getName());
                if (data != null) {
                    sink.put(key2, data);
                }
            }
        };
        this.myPanel.setFocusable(true);
        final ActionManager actionManager = ActionManager.getInstance();
        this.myToolbar = new DiffToolbarComponent(this.myPanel);
        DiffRequest.ToolbarAddons addons = new DiffRequest.ToolbarAddons(){

            public void customize(DiffToolbar toolbar) {
                toolbar.addAction(actionManager.getAction("DiffPanel.Toolbar"));
                toolbar.addAction(actionManager.getAction("ContextHelp"));
                toolbar.addSeparator();
            }
        };
        this.myToolbar.resetToolbar(addons);
        DiffToolbarImpl toolbar = this.myToolbar.getToolbar();
        this.myRequest.customizeToolbar((DiffToolbar)toolbar);
        this.myPanel.add((Component)this.myToolbar, "North");
        DiffContent content1 = this.myRequest.getContents()[0];
        DiffContent content2 = this.myRequest.getContents()[1];
        String message = DiffUtil.oneIsUnknown(content1, content2) ? DiffBundle.message((String)"diff.can.not.show.unknown", (Object[])new Object[0]) : DiffBundle.message((String)"diff.can.not.show", (Object[])new Object[0]);
        JPanel messagePanel = ErrorDiffViewer.createMessagePanel(message);
        this.myPanel.add((Component)messagePanel, "Center");
        ErrorDiffViewer.setWindowTitle(window, request.getWindowTitle());
    }

    private static void setWindowTitle(Window window, String title) {
        if (title == null || title.isEmpty()) {
            title = "Diff";
        }
        if (window instanceof JDialog) {
            ((JDialog)window).setTitle(title);
        } else if (window instanceof JFrame) {
            ((JFrame)window).setTitle(title);
        }
    }

    public boolean canShowRequest(DiffRequest request) {
        return false;
    }

    public void setDiffRequest(DiffRequest request) {
        throw new IllegalStateException();
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    private static JPanel createMessagePanel(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/diff/impl/ErrorDiffViewer", "createMessagePanel"));
        }
        JLabel label = new JLabel(message);
        label.setForeground(UIUtil.getInactiveTextColor());
        JPanel wrapper = new JPanel(new GridBagLayout());
        wrapper.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.insets((int)1), 0, 0));
        JPanel jPanel = wrapper;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ErrorDiffViewer", "createMessagePanel"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel;
    }

    public int getContentsNumber() {
        return 0;
    }

    public boolean acceptsType(DiffViewerType type) {
        return DiffViewerType.empty.equals((Object)type);
    }
}

