/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.util.Key;
import java.util.Iterator;

public class MergeSearchHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.MergeSearchHelper");
    private static final Key[] ourMergeListKeys = new Key[]{Key.create((String)"leftMergeSearchHelper"), Key.create((String)"centerMergeSearchHelper"), Key.create((String)"rightMergeSearchHelper")};
    private final MergeList myMergeList;
    private final int myIndex;

    private MergeSearchHelper(MergeList mergeList, int index) {
        this.myMergeList = mergeList;
        this.myIndex = index;
    }

    private static MergeSearchHelper forMergeList(MergeList mergeList, int contentIndex) {
        Key key2 = ourMergeListKeys[contentIndex];
        MergeSearchHelper helper = (MergeSearchHelper)mergeList.getUserData(key2);
        if (helper == null) {
            helper = new MergeSearchHelper(mergeList, contentIndex);
            mergeList.putUserData(key2, helper);
        }
        return helper;
    }

    public static Change findChangeAt(EditorMouseEvent e, MergePanel2 mergePanel, int index) {
        if (mergePanel.getMergeList() == null) {
            return null;
        }
        Editor editor = e.getEditor();
        LOG.assertTrue(editor == mergePanel.getEditor(index));
        LogicalPosition logicalPosition = editor.xyToLogicalPosition(e.getMouseEvent().getPoint());
        int offset = editor.logicalPositionToOffset(logicalPosition);
        return MergeSearchHelper.forMergeList(mergePanel.getMergeList(), index).findChangeAt(offset);
    }

    private Change findChangeAt(int offset) {
        for (int i = 0; i < 2; ++i) {
            Change change = this.changeAtOffset(this.myMergeList.getChanges(FragmentSide.fromIndex((int)i)).getChanges().iterator(), offset);
            if (change == null) continue;
            return change;
        }
        return null;
    }

    private Change changeAtOffset(Iterator<Change> iterator, int offset) {
        while (iterator.hasNext()) {
            Change change = iterator.next();
            FragmentSide side = this.chooseInterestedSide(change);
            if (side == null || !change.getChangeSide(side).contains(offset)) continue;
            return change;
        }
        return null;
    }

    private FragmentSide chooseInterestedSide(Change change) {
        if (this.myIndex == 1) {
            return MergeList.BASE_SIDE;
        }
        if (this.myIndex == 0 && change.getChangeList() != this.myMergeList.getChanges(FragmentSide.SIDE1)) {
            return null;
        }
        if (this.myIndex == 2 && change.getChangeList() != this.myMergeList.getChanges(FragmentSide.SIDE2)) {
            return null;
        }
        return MergeList.BRANCH_SIDE;
    }

    public static Change findChangeAt(CaretEvent e, MergePanel2 mergePanel, int index) {
        Editor editor = e.getEditor();
        LOG.assertTrue(editor == mergePanel.getEditor(index));
        return MergeSearchHelper.forMergeList(mergePanel.getMergeList(), index).findChangeAt(editor.logicalPositionToOffset(e.getNewPosition()));
    }
}

