/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.KillRingUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.textarea.TextComponentEditor;

public class KillRingSaveAction
extends TextComponentEditorAction {
    public KillRingSaveAction() {
        super(new Handler(false));
    }

    static class Handler
    extends EditorActionHandler {
        private final boolean myRemove;

        Handler(boolean remove) {
            this.myRemove = remove;
        }

        public void execute(final Editor editor, DataContext dataContext) {
            int end;
            SelectionModel selectionModel = editor.getSelectionModel();
            if (!selectionModel.hasSelection()) {
                return;
            }
            final int start = selectionModel.getSelectionStart();
            if (start >= (end = selectionModel.getSelectionEnd())) {
                return;
            }
            KillRingUtil.copyToKillRing(editor, start, end, false);
            if (this.myRemove) {
                DocumentRunnable runnable2 = new DocumentRunnable(editor.getDocument(), editor.getProject()){

                    public void run() {
                        editor.getDocument().deleteString(start, end);
                    }
                };
                if (editor instanceof TextComponentEditor) {
                    runnable2.run();
                } else {
                    ApplicationManager.getApplication().runWriteAction((Runnable)runnable2);
                }
            }
        }
    }
}

