/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DisplayedFoldingAnchor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collection;
import java.util.Map;

class FoldingAnchorsOverlayStrategy {
    private final EditorImpl myEditor;

    public FoldingAnchorsOverlayStrategy(EditorImpl editor) {
        this.myEditor = editor;
    }

    public Collection<DisplayedFoldingAnchor> getAnchorsToDisplay(int firstVisibleOffset, int lastVisibleOffset, FoldRegion activeFoldRegion) {
        FoldRegion[] visibleFoldRegions;
        HashMap result2 = new HashMap();
        for (FoldRegion region : visibleFoldRegions = this.myEditor.getFoldingModel().fetchVisible()) {
            FoldingGroup group;
            int endOffset;
            int startOffset;
            if (!region.isValid() || (startOffset = region.getStartOffset()) > lastVisibleOffset || (endOffset = this.getEndOffset(region)) < firstVisibleOffset || !this.isFoldingPossible(startOffset, endOffset) || (group = region.getGroup()) != null && this.myEditor.getFoldingModel().getFirstRegion(group, region) != region) continue;
            int foldStart = this.myEditor.offsetToVisualLine(startOffset);
            if (!region.isExpanded()) {
                FoldingAnchorsOverlayStrategy.tryAdding((Map<Integer, DisplayedFoldingAnchor>)result2, region, foldStart, 0, DisplayedFoldingAnchor.Type.COLLAPSED, activeFoldRegion);
                continue;
            }
            int foldEnd = this.myEditor.offsetToVisualLine(endOffset);
            FoldingAnchorsOverlayStrategy.tryAdding((Map<Integer, DisplayedFoldingAnchor>)result2, region, foldStart, foldEnd - foldStart, DisplayedFoldingAnchor.Type.EXPANDED_TOP, activeFoldRegion);
            FoldingAnchorsOverlayStrategy.tryAdding((Map<Integer, DisplayedFoldingAnchor>)result2, region, foldEnd, foldEnd - foldStart, DisplayedFoldingAnchor.Type.EXPANDED_BOTTOM, activeFoldRegion);
        }
        return result2.values();
    }

    private static void tryAdding(Map<Integer, DisplayedFoldingAnchor> resultsMap, FoldRegion region, int visualLine, int visualHeight, DisplayedFoldingAnchor.Type type, FoldRegion activeRegion) {
        DisplayedFoldingAnchor prev = resultsMap.get(visualLine);
        if (prev != null) {
            if (prev.foldRegion == activeRegion) {
                return;
            }
            if (region != activeRegion && prev.foldRegionVisualLines < visualHeight) {
                return;
            }
        }
        resultsMap.put(visualLine, new DisplayedFoldingAnchor(region, visualLine, visualHeight, type));
    }

    private int getEndOffset(FoldRegion foldRange) {
        FoldingGroup group = foldRange.getGroup();
        return group == null ? foldRange.getEndOffset() : this.myEditor.getFoldingModel().getEndOffset(group);
    }

    private boolean isFoldingPossible(int startOffset, int endOffset) {
        DocumentEx document2 = this.myEditor.getDocument();
        if (startOffset >= document2.getTextLength()) {
            return false;
        }
        int endOffsetToUse = Math.min(endOffset, document2.getTextLength());
        if (endOffsetToUse <= startOffset) {
            return false;
        }
        if (document2.getLineNumber(startOffset) != document2.getLineNumber(endOffsetToUse)) {
            return true;
        }
        return this.myEditor.getSettings().isAllowSingleLogicalLineFolding() && !this.myEditor.getSoftWrapModel().getSoftWrapsForRange(startOffset, endOffsetToUse).isEmpty();
    }
}

