/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IterationState {
    private static final Logger LOG = Logger.getInstance(IterationState.class);
    private static final Comparator<RangeHighlighterEx> BY_LAYER_THEN_ATTRIBUTES = (o1, o2) -> {
        Color back2;
        Color fore2;
        TextAttributes a2;
        int result2 = LayerComparator.INSTANCE.compare((RangeHighlighterEx)o1, (RangeHighlighterEx)o2);
        if (result2 != 0) {
            return result2;
        }
        TextAttributes a1 = o1.getTextAttributes();
        if (a1 == null ^ (a2 = o2.getTextAttributes()) == null) {
            return a1 == null ? 1 : -1;
        }
        if (a1 == null) {
            return result2;
        }
        Color fore1 = a1.getForegroundColor();
        if (fore1 == null ^ (fore2 = a2.getForegroundColor()) == null) {
            return fore1 == null ? 1 : -1;
        }
        Color back1 = a1.getBackgroundColor();
        if (back1 == null ^ (back2 = a2.getBackgroundColor()) == null) {
            return back1 == null ? 1 : -1;
        }
        return result2;
    };
    private static final Comparator<RangeHighlighterEx> BY_AFFECTED_END_OFFSET_REVERSED = (r1, r2) -> r2.getAffectedAreaEndOffset() - r1.getAffectedAreaEndOffset();
    private final TextAttributes myMergedAttributes;
    @Nullable
    private final HighlighterIterator myHighlighterIterator;
    private final HighlighterSweep myView;
    private final HighlighterSweep myDoc;
    private int myStartOffset;
    private int myEndOffset;
    private final int myEnd;
    private final int[] mySelectionStarts;
    private final int[] mySelectionEnds;
    private int myCurrentSelectionIndex;
    private Color myCurrentBackgroundColor;
    private Color myLastBackgroundColor;
    private final List<RangeHighlighterEx> myCurrentHighlighters;
    private final FoldingModelEx myFoldingModel;
    private final TextAttributes myFoldTextAttributes;
    private FoldRegion myCurrentFold;
    private final TextAttributes mySelectionAttributes;
    private final TextAttributes myCaretRowAttributes;
    private final Color myDefaultBackground;
    private final Color myDefaultForeground;
    private final int myDefaultFontType;
    private final int myCaretRowStart;
    private final int myCaretRowEnd;
    private final boolean myCaretRowStartsWithSoftWrap;
    private final boolean myCaretRowEndsWithSoftWrap;
    private final List<TextAttributes> myCachedAttributesList;
    private final DocumentEx myDocument;
    private final EditorEx myEditor;
    private final Color myReadOnlyColor;
    private final boolean myUseOnlyFullLineHighlighters;
    private final boolean myReverseIteration;

    public IterationState(@NotNull EditorEx editor, int start, int end, boolean useCaretAndSelection, boolean useOnlyFullLineHighlighters, boolean useOnlyFontAffectingHighlighters, boolean useFoldRegions, boolean iterateBackwards) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/view/IterationState", "<init>"));
        }
        this.myMergedAttributes = new TextAttributes();
        this.myCurrentSelectionIndex = 0;
        this.myCurrentHighlighters = new ArrayList<RangeHighlighterEx>();
        this.myCachedAttributesList = new ArrayList<TextAttributes>(5);
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myDocument = editor.getDocument();
        this.myStartOffset = start;
        this.myEnd = end;
        this.myEditor = editor;
        this.myUseOnlyFullLineHighlighters = useOnlyFullLineHighlighters;
        this.myReverseIteration = iterateBackwards;
        LOG.assertTrue(this.myReverseIteration ? this.myStartOffset >= this.myEnd : this.myStartOffset <= this.myEnd);
        HighlighterIterator highlighterIterator = this.myHighlighterIterator = useOnlyFullLineHighlighters ? null : editor.getHighlighter().createIterator(start);
        if (!useCaretAndSelection) {
            this.mySelectionStarts = ArrayUtilRt.EMPTY_INT_ARRAY;
            this.mySelectionEnds = ArrayUtilRt.EMPTY_INT_ARRAY;
        } else {
            List carets = editor.getCaretModel().getAllCarets();
            int caretCount = carets.size();
            this.mySelectionStarts = new int[caretCount];
            this.mySelectionEnds = new int[caretCount];
            for (int i = 0; i < caretCount; ++i) {
                Caret caret = (Caret)carets.get(i);
                this.mySelectionStarts[iterateBackwards ? caretCount - i - 1 : i] = caret.getSelectionStart();
                this.mySelectionEnds[iterateBackwards ? caretCount - i - 1 : i] = caret.getSelectionEnd();
            }
        }
        this.myFoldingModel = useFoldRegions ? editor.getFoldingModel() : null;
        this.myFoldTextAttributes = useFoldRegions ? this.myFoldingModel.getPlaceholderAttributes() : null;
        this.mySelectionAttributes = editor.getSelectionModel().getTextAttributes();
        this.myReadOnlyColor = this.myEditor.getColorsScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        CaretModel caretModel = editor.getCaretModel();
        this.myCaretRowAttributes = editor.isRendererMode() ? null : caretModel.getTextAttributes();
        this.myDefaultBackground = editor.getColorsScheme().getDefaultBackground();
        this.myDefaultForeground = editor.getColorsScheme().getDefaultForeground();
        TextAttributes defaultAttributes = editor.getColorsScheme().getAttributes(HighlighterColors.TEXT);
        this.myDefaultFontType = defaultAttributes == null ? 0 : defaultAttributes.getFontType();
        this.myCaretRowStart = useCaretAndSelection ? caretModel.getVisualLineStart() : -1;
        int visualLineEnd = caretModel.getVisualLineEnd();
        if (visualLineEnd == this.myDocument.getTextLength() && this.myDocument.getLineCount() > 0 && visualLineEnd > this.myDocument.getLineStartOffset(this.myDocument.getLineCount() - 1)) {
            ++visualLineEnd;
        }
        this.myCaretRowEnd = useCaretAndSelection ? visualLineEnd : -1;
        this.myCaretRowStartsWithSoftWrap = editor.getSoftWrapModel().getSoftWrap(this.myCaretRowStart) != null;
        this.myCaretRowEndsWithSoftWrap = editor.getSoftWrapModel().getSoftWrap(this.myCaretRowEnd) != null;
        MarkupModelEx editorMarkup = editor.getMarkupModel();
        this.myView = new HighlighterSweep(editorMarkup, start, this.myEnd, useOnlyFullLineHighlighters, useOnlyFontAffectingHighlighters);
        MarkupModelEx docMarkup = editor.getFilteredDocumentMarkupModel();
        this.myDoc = new HighlighterSweep(docMarkup, start, this.myEnd, useOnlyFullLineHighlighters, useOnlyFontAffectingHighlighters);
        this.myEndOffset = this.myStartOffset;
        this.advance();
    }

    private boolean skipHighlighter(@NotNull RangeHighlighterEx highlighter) {
        FoldRegion region;
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/view/IterationState", "skipHighlighter"));
        }
        if (!highlighter.isValid() || highlighter.isAfterEndOfLine() || highlighter.getTextAttributes() == null) {
            return true;
        }
        FoldRegion foldRegion = region = this.myFoldingModel == null ? null : this.myFoldingModel.getCollapsedRegionAtOffset(highlighter.getAffectedAreaStartOffset());
        return region != null && region == this.myFoldingModel.getCollapsedRegionAtOffset(highlighter.getAffectedAreaEndOffset());
    }

    public void advance() {
        this.myStartOffset = this.myEndOffset;
        this.advanceSegmentHighlighters();
        this.advanceCurrentSelectionIndex();
        if (!this.myUseOnlyFullLineHighlighters) {
            FoldRegion foldRegion = this.myFoldingModel == null ? null : (this.myCurrentFold = this.myFoldingModel.getCollapsedRegionAtOffset(this.myReverseIteration ? this.myStartOffset - 1 : this.myStartOffset));
        }
        if (this.myCurrentFold != null) {
            this.myEndOffset = this.myReverseIteration ? this.myCurrentFold.getStartOffset() : this.myCurrentFold.getEndOffset();
        } else {
            this.myEndOffset = this.getHighlighterEnd(this.myStartOffset);
            this.setEndOffsetIfCloser(this.getSelectionEnd());
            this.setEndOffsetIfCloser(this.getMinSegmentHighlightersEnd());
            this.setEndOffsetIfCloser(this.getFoldRangesEnd(this.myStartOffset));
            this.setEndOffsetIfCloser(this.getCaretEnd(this.myStartOffset));
            this.setEndOffsetIfCloser(this.getGuardedBlockEnd(this.myStartOffset));
        }
        this.reinit();
    }

    private void setEndOffsetIfCloser(int offset) {
        if (this.myReverseIteration ? offset > this.myEndOffset : offset < this.myEndOffset) {
            this.myEndOffset = offset;
        }
    }

    private int getHighlighterEnd(int start) {
        if (this.myHighlighterIterator == null) {
            return this.myEnd;
        }
        while (!this.myHighlighterIterator.atEnd()) {
            int end;
            int n = end = this.myReverseIteration ? this.myHighlighterIterator.getStart() : this.myHighlighterIterator.getEnd();
            if (this.myReverseIteration ? end < start : end > start) {
                return end;
            }
            if (this.myReverseIteration) {
                this.myHighlighterIterator.retreat();
                continue;
            }
            this.myHighlighterIterator.advance();
        }
        return this.myEnd;
    }

    private int getCaretEnd(int start) {
        return this.getNearestValueAhead(start, this.myCaretRowStart, this.myCaretRowEnd);
    }

    private int getNearestValueAhead(int offset, int rangeStart, int rangeEnd) {
        if (this.myReverseIteration) {
            if (rangeEnd < offset) {
                return rangeEnd;
            }
            if (rangeStart < offset) {
                return rangeStart;
            }
        } else {
            if (rangeStart > offset) {
                return rangeStart;
            }
            if (rangeEnd > offset) {
                return rangeEnd;
            }
        }
        return this.myEnd;
    }

    private int getGuardedBlockEnd(int start) {
        if (this.myUseOnlyFullLineHighlighters) {
            return this.myEnd;
        }
        List<RangeMarker> blocks = this.myDocument.getGuardedBlocks();
        int result2 = this.myEnd;
        for (int i = 0; i < blocks.size(); ++i) {
            RangeMarker block = blocks.get(i);
            int nearestValue = this.getNearestValueAhead(start, block.getStartOffset(), block.getEndOffset());
            result2 = this.myReverseIteration ? Math.max(result2, nearestValue) : Math.min(result2, nearestValue);
        }
        return result2;
    }

    private void advanceCurrentSelectionIndex() {
        while (this.myCurrentSelectionIndex < this.mySelectionEnds.length && (this.myReverseIteration ? this.myStartOffset <= this.mySelectionStarts[this.myCurrentSelectionIndex] : this.myStartOffset >= this.mySelectionEnds[this.myCurrentSelectionIndex])) {
            ++this.myCurrentSelectionIndex;
        }
    }

    private int getSelectionEnd() {
        if (this.myCurrentSelectionIndex >= this.mySelectionStarts.length) {
            return this.myEnd;
        }
        return this.getNearestValueAhead(this.myStartOffset, this.mySelectionStarts[this.myCurrentSelectionIndex], this.mySelectionEnds[this.myCurrentSelectionIndex]);
    }

    private boolean isInSelection() {
        return this.myCurrentSelectionIndex < this.mySelectionStarts.length && (this.myReverseIteration ? this.myStartOffset <= this.mySelectionEnds[this.myCurrentSelectionIndex] : this.myStartOffset >= this.mySelectionStarts[this.myCurrentSelectionIndex]);
    }

    private void advanceSegmentHighlighters() {
        this.myDoc.advance();
        this.myView.advance();
        boolean fileEnd = this.myStartOffset == this.myDocument.getTextLength();
        for (int i = this.myCurrentHighlighters.size() - 1; i >= 0; --i) {
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i);
            if (!(this.myReverseIteration ? highlighter.getAffectedAreaStartOffset() >= this.myStartOffset : (fileEnd && highlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE ? highlighter.getAffectedAreaEndOffset() < this.myStartOffset : highlighter.getAffectedAreaEndOffset() <= this.myStartOffset))) continue;
            this.myCurrentHighlighters.remove(i);
        }
    }

    private int getFoldRangesEnd(int startOffset) {
        int end;
        block7: {
            if (this.myUseOnlyFullLineHighlighters || this.myFoldingModel == null) {
                return this.myEnd;
            }
            end = this.myEnd;
            FoldRegion[] topLevelCollapsed = this.myFoldingModel.fetchTopLevel();
            if (topLevelCollapsed == null) break block7;
            if (this.myReverseIteration) {
                for (int i = this.myFoldingModel.getLastCollapsedRegionBefore(startOffset); i >= 0 && i < topLevelCollapsed.length; --i) {
                    int rangeEnd;
                    FoldRegion range = topLevelCollapsed[i];
                    if (!range.isValid() || (rangeEnd = range.getEndOffset()) >= startOffset) continue;
                    if (rangeEnd > end) {
                        end = rangeEnd;
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = this.myFoldingModel.getLastCollapsedRegionBefore(startOffset) + 1; i >= 0 && i < topLevelCollapsed.length; ++i) {
                    int rangeEnd;
                    FoldRegion range = topLevelCollapsed[i];
                    if (!range.isValid() || (rangeEnd = range.getStartOffset()) <= startOffset) continue;
                    if (rangeEnd < end) {
                        end = rangeEnd;
                        continue;
                    }
                    break;
                }
            }
        }
        return end;
    }

    private int getMinSegmentHighlightersEnd() {
        int end = this.myEnd;
        for (int i = 0; i < this.myCurrentHighlighters.size(); ++i) {
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i);
            if (this.myReverseIteration) {
                if (highlighter.getAffectedAreaStartOffset() <= end) continue;
                end = highlighter.getAffectedAreaStartOffset();
                continue;
            }
            if (highlighter.getAffectedAreaEndOffset() >= end) continue;
            end = highlighter.getAffectedAreaEndOffset();
        }
        end = this.myReverseIteration ? Math.max(end, this.myDoc.getMinSegmentHighlighterEnd()) : Math.min(end, this.myDoc.getMinSegmentHighlighterEnd());
        end = this.myReverseIteration ? Math.max(end, this.myView.getMinSegmentHighlighterEnd()) : Math.min(end, this.myView.getMinSegmentHighlighterEnd());
        return end;
    }

    private void reinit() {
        boolean isInSelection = this.isInSelection();
        boolean isInCaretRow = this.isInCaretRow(!this.myReverseIteration, this.myReverseIteration);
        boolean isInGuardedBlock = !this.myUseOnlyFullLineHighlighters && this.myDocument.getOffsetGuard(this.myReverseIteration ? this.myStartOffset - 1 : this.myStartOffset) != null;
        TextAttributes syntax = this.myHighlighterIterator == null || this.myHighlighterIterator.atEnd() ? null : this.myHighlighterIterator.getTextAttributes();
        TextAttributes selection = isInSelection ? this.mySelectionAttributes : null;
        TextAttributes caret = isInCaretRow ? this.myCaretRowAttributes : null;
        TextAttributes fold = this.myCurrentFold != null ? this.myFoldTextAttributes : null;
        TextAttributes guard = isInGuardedBlock ? new TextAttributes(null, this.myReadOnlyColor, null, EffectType.BOXED, 0) : null;
        int size = this.myCurrentHighlighters.size();
        if (size > 1) {
            ContainerUtil.quickSort(this.myCurrentHighlighters, BY_LAYER_THEN_ATTRIBUTES);
        }
        for (int i = 0; i < size; ++i) {
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i);
            if (highlighter.getTextAttributes() != TextAttributes.ERASE_MARKER) continue;
            syntax = null;
        }
        List<TextAttributes> cachedAttributes = this.myCachedAttributesList;
        cachedAttributes.clear();
        for (int i = 0; i < size; ++i) {
            TextAttributes textAttributes;
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i);
            if (highlighter.getLayer() < 6000 && selection != null) {
                cachedAttributes.add(selection);
                selection = null;
            }
            if (fold != null && highlighter.getLayer() < 3500) {
                cachedAttributes.add(fold);
                fold = null;
            }
            if (guard != null && highlighter.getLayer() < 3500) {
                cachedAttributes.add(guard);
                guard = null;
            }
            if (caret != null && highlighter.getLayer() < 2000) {
                cachedAttributes.add(caret);
                caret = null;
            }
            if (syntax != null && highlighter.getLayer() < 1000) {
                cachedAttributes.add(syntax);
                syntax = null;
            }
            if ((textAttributes = highlighter.getTextAttributes()) == null || textAttributes == TextAttributes.ERASE_MARKER) continue;
            cachedAttributes.add(textAttributes);
        }
        if (selection != null) {
            cachedAttributes.add(selection);
        }
        if (fold != null) {
            cachedAttributes.add(fold);
        }
        if (guard != null) {
            cachedAttributes.add(guard);
        }
        if (caret != null) {
            cachedAttributes.add(caret);
        }
        if (syntax != null) {
            cachedAttributes.add(syntax);
        }
        Color fore = null;
        Color back = isInGuardedBlock ? this.myReadOnlyColor : null;
        Color effect = null;
        EffectType effectType = null;
        int fontType = 0;
        for (int i = 0; i < cachedAttributes.size(); ++i) {
            TextAttributes attrs = cachedAttributes.get(i);
            if (fore == null) {
                fore = attrs.getForegroundColor();
            }
            if (back == null) {
                back = attrs.getBackgroundColor();
            }
            if (fontType == 0) {
                fontType = attrs.getFontType();
            }
            if (effect != null) continue;
            effect = attrs.getEffectColor();
            effectType = attrs.getEffectType();
        }
        if (fore == null) {
            fore = this.myDefaultForeground;
        }
        if (back == null) {
            back = this.myDefaultBackground;
        }
        if (effectType == null) {
            effectType = EffectType.BOXED;
        }
        if (fontType == 0) {
            fontType = this.myDefaultFontType;
        }
        this.myMergedAttributes.setAttributes(fore, back, effect, null, effectType, fontType);
        this.myLastBackgroundColor = this.myCurrentBackgroundColor;
        this.myCurrentBackgroundColor = back;
    }

    private boolean isInCaretRow(boolean includeLineStart, boolean includeLineEnd) {
        return this.myStartOffset > this.myCaretRowStart && this.myStartOffset < this.myCaretRowEnd || includeLineStart && this.myStartOffset == this.myCaretRowStart || includeLineEnd && this.myStartOffset == this.myCaretRowEnd;
    }

    public boolean atEnd() {
        return this.myReverseIteration ? this.myStartOffset <= this.myEnd : this.myStartOffset >= this.myEnd;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    @NotNull
    public TextAttributes getMergedAttributes() {
        TextAttributes textAttributes = this.myMergedAttributes;
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/IterationState", "getMergedAttributes"));
        }
        return textAttributes;
    }

    @NotNull
    public TextAttributes getPastLineEndBackgroundAttributes() {
        this.myMergedAttributes.setBackgroundColor(this.myEditor.getSoftWrapModel().getSoftWrap(this.myStartOffset) != null ? this.getBreakBackgroundColor(true) : this.myCurrentBackgroundColor);
        TextAttributes textAttributes = this.myMergedAttributes;
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/IterationState", "getPastLineEndBackgroundAttributes"));
        }
        return textAttributes;
    }

    @NotNull
    public TextAttributes getBeforeLineStartBackgroundAttributes() {
        TextAttributes textAttributes = new TextAttributes(null, this.getBreakBackgroundColor(false), null, null, 0);
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/IterationState", "getBeforeLineStartBackgroundAttributes"));
        }
        return textAttributes;
    }

    private Color getBreakBackgroundColor(boolean lineEnd) {
        return Comparing.equal((Object)this.myCurrentBackgroundColor, (Object)this.myLastBackgroundColor) ? this.myCurrentBackgroundColor : (this.isInCaretRow(!this.myCaretRowStartsWithSoftWrap || !lineEnd, this.myCaretRowEndsWithSoftWrap && lineEnd) ? this.myCaretRowAttributes.getBackgroundColor() : this.myDefaultBackground);
    }

    private static class LayerComparator
    implements Comparator<RangeHighlighterEx> {
        private static final LayerComparator INSTANCE = new LayerComparator();

        private LayerComparator() {
        }

        @Override
        public int compare(RangeHighlighterEx o1, RangeHighlighterEx o2) {
            int layerDiff = o2.getLayer() - o1.getLayer();
            if (layerDiff != 0) {
                return layerDiff;
            }
            int o1Length = o1.getAffectedAreaEndOffset() - o1.getAffectedAreaStartOffset();
            int o2Length = o2.getAffectedAreaEndOffset() - o2.getAffectedAreaStartOffset();
            return o1Length - o2Length;
        }
    }

    private class HighlighterSweep {
        private RangeHighlighterEx myNextHighlighter;
        int i;
        private final RangeHighlighterEx[] highlighters;

        private HighlighterSweep(MarkupModelEx markupModel, int start, int end, final boolean onlyFullLine, final boolean onlyFontAffecting) {
            if (markupModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markupModel", "com/intellij/openapi/editor/impl/view/IterationState$HighlighterSweep", "<init>"));
            }
            ArrayList list = new ArrayList();
            markupModel.processRangeHighlightersOverlappingWith(IterationState.this.myReverseIteration ? end : start, IterationState.this.myReverseIteration ? start : end, (Processor<? super RangeHighlighterEx>)new CommonProcessors.CollectProcessor<RangeHighlighterEx>(list){

                protected boolean accept(RangeHighlighterEx ex) {
                    return !(onlyFullLine && ex.getTargetArea() != HighlighterTargetArea.LINES_IN_RANGE || onlyFontAffecting && !EditorUtil.attributesImpactFontStyle(ex.getTextAttributes()));
                }
            });
            this.highlighters = list.isEmpty() ? RangeHighlighterEx.EMPTY_ARRAY : list.toArray(new RangeHighlighterEx[list.size()]);
            Arrays.sort(this.highlighters, IterationState.this.myReverseIteration ? BY_AFFECTED_END_OFFSET_REVERSED : RangeHighlighterEx.BY_AFFECTED_START_OFFSET);
            while (this.i < this.highlighters.length) {
                RangeHighlighterEx highlighter;
                if (IterationState.this.skipHighlighter(highlighter = this.highlighters[this.i++])) continue;
                this.myNextHighlighter = highlighter;
                break;
            }
        }

        private void advance() {
            if (this.myNextHighlighter != null) {
                if (IterationState.this.myReverseIteration ? this.myNextHighlighter.getAffectedAreaEndOffset() < IterationState.this.myStartOffset : this.myNextHighlighter.getAffectedAreaStartOffset() > IterationState.this.myStartOffset) {
                    return;
                }
                IterationState.this.myCurrentHighlighters.add(this.myNextHighlighter);
                this.myNextHighlighter = null;
            }
            while (this.i < this.highlighters.length) {
                RangeHighlighterEx highlighter;
                if (IterationState.this.skipHighlighter(highlighter = this.highlighters[this.i++])) continue;
                if (IterationState.this.myReverseIteration ? highlighter.getAffectedAreaEndOffset() < IterationState.this.myStartOffset : highlighter.getAffectedAreaStartOffset() > IterationState.this.myStartOffset) {
                    this.myNextHighlighter = highlighter;
                    break;
                }
                IterationState.this.myCurrentHighlighters.add(highlighter);
            }
        }

        private int getMinSegmentHighlighterEnd() {
            if (this.myNextHighlighter != null) {
                return IterationState.this.myReverseIteration ? this.myNextHighlighter.getAffectedAreaEndOffset() : this.myNextHighlighter.getAffectedAreaStartOffset();
            }
            return IterationState.this.myReverseIteration ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
    }
}

