/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.ExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.InProcessExternalSystemFacadeImpl;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemFacadeWrapper;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InProcessExternalSystemCommunicationManager
implements ExternalSystemCommunicationManager {
    @NotNull
    private final ExternalSystemProgressNotificationManagerImpl myProgressManager;

    public InProcessExternalSystemCommunicationManager(@NotNull ExternalSystemProgressNotificationManager notificationManager2) {
        if (notificationManager2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationManager", "com/intellij/openapi/externalSystem/service/InProcessExternalSystemCommunicationManager", "<init>"));
        }
        this.myProgressManager = (ExternalSystemProgressNotificationManagerImpl)notificationManager2;
    }

    @Override
    @Nullable
    public RemoteExternalSystemFacade acquire(@NotNull String id, @NotNull ProjectSystemId externalSystemId) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/InProcessExternalSystemCommunicationManager", "acquire"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/InProcessExternalSystemCommunicationManager", "acquire"));
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        InProcessExternalSystemFacadeImpl result2 = new InProcessExternalSystemFacadeImpl(manager.getProjectResolverClass(), manager.getTaskManagerClass());
        result2.applyProgressManager(this.myProgressManager);
        return result2;
    }

    @Override
    public void release(@NotNull String id, @NotNull ProjectSystemId externalSystemId) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/InProcessExternalSystemCommunicationManager", "release"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/InProcessExternalSystemCommunicationManager", "release"));
        }
    }

    @Override
    public boolean isAlive(@NotNull RemoteExternalSystemFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/openapi/externalSystem/service/InProcessExternalSystemCommunicationManager", "isAlive"));
        }
        RemoteExternalSystemFacade toCheck = facade;
        if (facade instanceof ExternalSystemFacadeWrapper) {
            toCheck = ((ExternalSystemFacadeWrapper)facade).getDelegate();
        }
        return toCheck instanceof InProcessExternalSystemFacadeImpl;
    }

    @Override
    public void clear() {
    }
}

