/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonProjectFileWritingAccessDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JLabel myListTitle;
    private JList myFileList;
    private JRadioButton myUnlockOneButton;
    private JRadioButton myUnlockDirButton;
    private JRadioButton myUnlockAllButton;

    public NonProjectFileWritingAccessDialog(@NotNull Project project2, @NotNull List<VirtualFile> nonProjectFiles) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog", "<init>"));
        }
        if (nonProjectFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonProjectFiles", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog", "<init>"));
        }
        this(project2, nonProjectFiles, "Non-Project Files");
    }

    public NonProjectFileWritingAccessDialog(@NotNull Project project2, @NotNull List<VirtualFile> nonProjectFiles, @NotNull String filesType) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog", "<init>"));
        }
        if (nonProjectFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonProjectFiles", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog", "<init>"));
        }
        if (filesType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesType", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog", "<init>"));
        }
        super(project2);
        this.$$$setupUI$$$();
        this.setTitle(filesType + " Protection");
        this.myFileList.setPreferredSize(ReadOnlyStatusDialog.getDialogPreferredSize());
        this.myFileList.setCellRenderer(new FileListRenderer());
        this.myFileList.setModel(new CollectionListModel(nonProjectFiles));
        String theseFilesMessage = ReadOnlyStatusDialog.getTheseFilesMessage(nonProjectFiles);
        this.myListTitle.setText(StringUtil.capitalize((String)theseFilesMessage) + " " + (nonProjectFiles.size() > 1 ? "do" : "does") + " not belong to the project:");
        this.myUnlockOneButton.setSelected(true);
        this.setTextAndMnemonicAndListeners(this.myUnlockOneButton, "I want to edit " + theseFilesMessage + " anyway", "edit");
        int dirs = ContainerUtil.map2Set(nonProjectFiles, VirtualFile::getParent).size();
        this.setTextAndMnemonicAndListeners(this.myUnlockDirButton, "I want to edit all files in " + StringUtil.pluralize((String)"this", (int)dirs) + " " + StringUtil.pluralize((String)"directory", (int)dirs), "dir");
        this.setTextAndMnemonicAndListeners(this.myUnlockAllButton, "I want to edit any non-project file in the current session", "any");
        this.getOKAction().putValue("DefaultAction", null);
        this.getCancelAction().putValue("DefaultAction", null);
        this.getRootPane().registerKeyboardAction(e -> this.doOKAction(), KeyStroke.getKeyStroke(10, 128), 1);
        this.getRootPane().registerKeyboardAction(e -> this.doOKAction(), KeyStroke.getKeyStroke(10, 256), 1);
        this.init();
    }

    private void setTextAndMnemonicAndListeners(JRadioButton button, String text, String mnemonic) {
        button.setText(text);
        button.setMnemonic(mnemonic.charAt(0));
        button.setDisplayedMnemonicIndex(button.getText().indexOf(mnemonic));
        button.addActionListener(e -> button.getRootPane().setDefaultButton(this.getButton(this.getOKAction())));
        button.addItemListener(e -> button.getRootPane().setDefaultButton(this.getButton(this.getOKAction())));
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myUnlockOneButton;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    public NonProjectFileWritingAccessProvider.UnlockOption getUnlockOption() {
        if (this.myUnlockAllButton.isSelected()) {
            NonProjectFileWritingAccessProvider.UnlockOption unlockOption = NonProjectFileWritingAccessProvider.UnlockOption.UNLOCK_ALL;
            if (unlockOption == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog", "getUnlockOption"));
            }
            return unlockOption;
        }
        if (this.myUnlockDirButton.isSelected()) {
            NonProjectFileWritingAccessProvider.UnlockOption unlockOption = NonProjectFileWritingAccessProvider.UnlockOption.UNLOCK_DIR;
            if (unlockOption == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog", "getUnlockOption"));
            }
            return unlockOption;
        }
        NonProjectFileWritingAccessProvider.UnlockOption unlockOption = NonProjectFileWritingAccessProvider.UnlockOption.UNLOCK;
        if (unlockOption == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog", "getUnlockOption"));
        }
        return unlockOption;
    }

    protected String getHelpId() {
        return "Non-Project_Files_Access_Dialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 1, null, null, null));
        this.myUnlockOneButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("unlock one");
        jRadioButton3.setSelected(false);
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUnlockAllButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("unlock all");
        jPanel2.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUnlockDirButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("unlock dir");
        jRadioButton.setSelected(false);
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myListTitle = jLabel = new JLabel();
        jLabel.setText("title");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myFileList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

