/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeUsagesCollector
extends AbstractApplicationUsagesCollector {
    private static final String GROUP_ID = "file-type";

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create(GROUP_ID);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/FileTypeUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project2) throws CollectUsagesException {
        FileType[] registeredFileTypes;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileTypes/FileTypeUsagesCollector", "getProjectUsages"));
        }
        final HashSet usedFileTypes = new HashSet();
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager == null) {
            throw new CollectUsagesException("Cannot get instance of FileTypeManager");
        }
        for (final FileType fileType2 : registeredFileTypes = fileTypeManager.getRegisteredFileTypes()) {
            if (project2.isDisposed()) {
                throw new CollectUsagesException("Project is disposed");
            }
            final String ideaDirPath = FileTypeUsagesCollector.getIdeaDirPath(project2);
            ApplicationManager.getApplication().runReadAction(() -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileTypes/FileTypeUsagesCollector", "lambda$getProjectUsages$0"));
                }
                FileBasedIndex.getInstance().processValues(FileTypeIndex.NAME, (Object)fileType2, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Void>(){

                    public boolean process(VirtualFile file2, Void value) {
                        if (ideaDirPath == null || FileUtil.isAncestorThreeState((String)ideaDirPath, (String)file2.getPath(), (boolean)true) == ThreeState.NO) {
                            usedFileTypes.add(fileType2);
                            return false;
                        }
                        return true;
                    }
                }, GlobalSearchScope.projectScope((Project)project2));
            });
        }
        Set set = ContainerUtil.map2Set(usedFileTypes, (Function)((NotNullFunction)fileType -> new UsageDescriptor(fileType.getName(), 1)));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/FileTypeUsagesCollector", "getProjectUsages"));
        }
        return set;
    }

    @Nullable
    private static String getIdeaDirPath(@NotNull Project project2) {
        String ideaDirPath;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileTypes/FileTypeUsagesCollector", "getIdeaDirPath"));
        }
        String projectPath = project2.getBasePath();
        if (projectPath != null && new File(ideaDirPath = projectPath + "/" + ".idea").isDirectory()) {
            return ideaDirPath;
        }
        return null;
    }
}

