/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.QueueProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundTaskQueue {
    @NotNull
    private final String myTitle;
    @NotNull
    private final QueueProcessor<TaskData> myProcessor;
    @NotNull
    private final Object TEST_TASK_LOCK;
    private volatile boolean myForceAsyncInTests;

    public BackgroundTaskQueue(@Nullable Project project2, @NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/progress/BackgroundTaskQueue", "<init>"));
        }
        this.TEST_TASK_LOCK = new Object();
        this.myForceAsyncInTests = false;
        this.myTitle = title;
        Condition disposeCondition = project2 != null ? project2.getDisposed() : ApplicationManager.getApplication().getDisposed();
        this.myProcessor = new QueueProcessor((data, continuation) -> {
            ModalityState modalityState;
            Task.Backgroundable task = data.task;
            Object indicator = data.indicator;
            if (indicator == null) {
                indicator = ApplicationManager.getApplication().isHeadlessEnvironment() ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task);
            }
            if ((modalityState = data.modalityState) == null) {
                modalityState = ModalityState.NON_MODAL;
            }
            if (StringUtil.isEmptyOrSpaces((String)task.getTitle())) {
                task.setTitle(this.myTitle);
            }
            boolean synchronous = task.isHeadless() && !this.myForceAsyncInTests || task.isConditionalModal() && !task.shouldStartInBackground();
            ProgressManagerImpl pm = (ProgressManagerImpl)ProgressManager.getInstance();
            if (synchronous) {
                try {
                    pm.runProcessWithProgressSynchronously((Task)task, null);
                }
                finally {
                    continuation.run();
                }
            } else {
                pm.runProcessWithProgressAsynchronously(task, (ProgressIndicator)indicator, (Runnable)continuation, modalityState);
            }
        }, true, QueueProcessor.ThreadToUse.AWT, disposeCondition);
    }

    public void clear() {
        this.myProcessor.clear();
    }

    public boolean isEmpty() {
        return this.myProcessor.isEmpty();
    }

    public void waitForTasksToFinish() {
        this.myProcessor.waitFor();
    }

    public void run(@NotNull Task.Backgroundable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/BackgroundTaskQueue", "run"));
        }
        this.run(task, null, null);
    }

    public void run(@NotNull Task.Backgroundable task, @Nullable ModalityState modalityState, @Nullable ProgressIndicator indicator) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/BackgroundTaskQueue", "run"));
        }
        TaskData taskData = new TaskData(task, modalityState, indicator);
        if (!this.myForceAsyncInTests && ApplicationManager.getApplication().isUnitTestMode()) {
            this.runTaskInCurrentThread(taskData);
        } else {
            this.myProcessor.add((Object)taskData, modalityState);
        }
    }

    public void setForceAsyncInTests(boolean value, @Nullable Disposable disposable) {
        this.myForceAsyncInTests = value;
        if (disposable != null) {
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    BackgroundTaskQueue.this.myForceAsyncInTests = false;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTaskInCurrentThread(@NotNull TaskData data) {
        ModalityState modalityState;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/progress/BackgroundTaskQueue", "runTaskInCurrentThread"));
        }
        Task.Backgroundable task = data.task;
        ProgressIndicator indicator = data.indicator;
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        if ((modalityState = data.modalityState) == null) {
            modalityState = ModalityState.NON_MODAL;
        }
        boolean processCanceled = false;
        Exception exception = null;
        try {
            Object object = this.TEST_TASK_LOCK;
            synchronized (object) {
                task.run(indicator);
            }
        }
        catch (ProcessCanceledException e) {
            processCanceled = true;
        }
        catch (Exception e) {
            exception = e;
        }
        boolean finalCanceled = processCanceled || indicator.isCanceled();
        Exception finalException = exception;
        Runnable finishTask = () -> {
            try {
                if (finalException != null) {
                    task.onError(finalException);
                } else if (finalCanceled) {
                    task.onCancel();
                } else {
                    task.onSuccess();
                }
            }
            finally {
                task.onFinished();
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            finishTask.run();
        } else {
            application.invokeLater(finishTask, modalityState);
        }
    }

    private static class TaskData {
        @NotNull
        public final Task.Backgroundable task;
        @Nullable
        public final ModalityState modalityState;
        @Nullable
        public final ProgressIndicator indicator;

        public TaskData(@NotNull Task.Backgroundable task, @Nullable ModalityState modalityState, @Nullable ProgressIndicator indicator) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/BackgroundTaskQueue$TaskData", "<init>"));
            }
            this.task = task;
            this.modalityState = modalityState;
            this.indicator = indicator;
        }
    }
}

