/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.DefaultProject;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectManagerImpl
extends ProjectManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectManagerImpl.class);
    private static final Key<List<ProjectManagerListener>> LISTENERS_IN_PROJECT_KEY = Key.create((String)"LISTENERS_IN_PROJECT_KEY");
    private ProjectImpl myDefaultProject;
    private Project[] myOpenProjects = new Project[0];
    private final Object lock = new Object();
    private final List<ProjectManagerListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final ProgressManager myProgressManager;
    private volatile boolean myDefaultProjectWasDisposed;
    public static int TEST_PROJECTS_CREATED;
    private static final boolean LOG_PROJECT_LEAKAGE_IN_TESTS = true;
    private static final int MAX_LEAKY_PROJECTS = 42;
    private final Map<Project, String> myProjects = new WeakHashMap<Project, String>();

    @NotNull
    private static List<ProjectManagerListener> getListeners(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getListeners"));
        }
        List array = (List)project2.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (array == null) {
            List<ProjectManagerListener> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getListeners"));
            }
            return list;
        }
        List list = array;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getListeners"));
        }
        return list;
    }

    public ProjectManagerImpl(ProgressManager progressManager) {
        this.myProgressManager = progressManager;
        final ProjectManagerListener busPublisher = (ProjectManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC);
        this.addProjectManagerListener(new ProjectManagerListener(){

            public void projectOpened(Project project2) {
                busPublisher.projectOpened(project2);
                for (ProjectManagerListener listener2 : ProjectManagerImpl.getListeners(project2)) {
                    listener2.projectOpened(project2);
                }
            }

            public void projectClosed(Project project2) {
                busPublisher.projectClosed(project2);
                for (ProjectManagerListener listener2 : ProjectManagerImpl.getListeners(project2)) {
                    listener2.projectClosed(project2);
                }
                ZipHandler.clearFileAccessorCache();
            }

            public boolean canCloseProject(Project project2) {
                for (ProjectManagerListener listener2 : ProjectManagerImpl.getListeners(project2)) {
                    if (listener2.canCloseProject(project2)) continue;
                    return false;
                }
                return true;
            }

            public void projectClosing(Project project2) {
                busPublisher.projectClosing(project2);
                for (ProjectManagerListener listener2 : ProjectManagerImpl.getListeners(project2)) {
                    listener2.projectClosing(project2);
                }
            }
        });
    }

    public void dispose() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myDefaultProject != null) {
            Disposer.dispose((Disposable)this.myDefaultProject);
            this.myDefaultProject = null;
            this.myDefaultProjectWasDisposed = true;
        }
    }

    @Override
    @Nullable
    public Project newProject(@Nullable String projectName, @NotNull String filePath, boolean useDefaultProjectSettings, boolean isDummy) {
        File projectFile;
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "newProject"));
        }
        filePath = ProjectManagerImpl.toCanonicalName(filePath);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ++TEST_PROJECTS_CREATED;
            for (int i = 0; i < 42 && this.myProjects.size() >= 42; ++i) {
                System.gc();
                TimeoutUtil.sleep((long)100L);
                System.gc();
            }
            if (this.myProjects.size() >= 42) {
                ArrayList<Project> copy = new ArrayList<Project>(this.myProjects.keySet());
                this.myProjects.clear();
                throw new TooManyProjectLeakedException(copy);
            }
        }
        if ((projectFile = new File(filePath)).isFile()) {
            FileUtil.delete((File)projectFile);
        } else {
            File[] files = new File(projectFile, ".idea").listFiles();
            if (files != null) {
                for (File file2 : files) {
                    FileUtil.delete((File)file2);
                }
            }
        }
        ProjectImpl project2 = this.createProject(projectName, filePath, false);
        try {
            this.initProject(project2, useDefaultProjectSettings ? this.getDefaultProject() : null);
            this.myProjects.put(project2, null);
            return project2;
        }
        catch (Throwable t) {
            LOG.info(t);
            Messages.showErrorDialog((String)ProjectManagerImpl.message(t), (String)ProjectBundle.message((String)"project.load.default.error", (Object[])new Object[0]));
            return null;
        }
    }

    @NonNls
    @NotNull
    private static String message(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/project/impl/ProjectManagerImpl", "message"));
        }
        String message = e.getMessage();
        if (message != null) {
            String string = message;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "message"));
            }
            return string;
        }
        message = e.getLocalizedMessage();
        if (message != null) {
            String string = message;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "message"));
            }
            return string;
        }
        message = e.toString();
        Throwable cause = e.getCause();
        if (cause != null) {
            String causeMessage = ProjectManagerImpl.message(cause);
            String string = message + " (cause: " + causeMessage + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "message"));
            }
            return string;
        }
        String string = message;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "message"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProject(@NotNull ProjectImpl project2, @Nullable Project template) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "initProject"));
        }
        ProgressIndicator indicator = this.myProgressManager.getProgressIndicator();
        if (indicator != null && !project2.isDefault()) {
            indicator.setText(ProjectBundle.message((String)"loading.components.for", (Object[])new Object[]{project2.getName()}));
        }
        ((ProjectLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).beforeProjectLoaded((Project)project2);
        boolean succeed = false;
        try {
            if (template != null) {
                project2.getStateStore().loadProjectFromTemplate(template);
            }
            project2.init();
            succeed = true;
        }
        finally {
            if (!succeed && !project2.isDefault()) {
                TransactionGuard.submitTransaction((Disposable)project2, () -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "lambda$initProject$1"));
                    }
                    WriteAction.run(() -> {
                        if (project2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "lambda$null$0"));
                        }
                        Disposer.dispose((Disposable)project2);
                    });
                });
            }
        }
    }

    private ProjectImpl createProject(@Nullable String projectName, @NotNull String filePath, boolean isDefault) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "createProject"));
        }
        if (isDefault) {
            return new DefaultProject(this, "");
        }
        return new ProjectImpl(this, FileUtilRt.toSystemIndependentName((String)filePath), projectName);
    }

    @Override
    @Nullable
    public Project loadProject(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "loadProject"));
        }
        try {
            ProjectImpl project2 = this.createProject(null, new File(filePath).getAbsolutePath(), false);
            this.initProject(project2, null);
            return project2;
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
    }

    @NotNull
    private static String toCanonicalName(@NotNull String filePath) {
        String string;
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "toCanonicalName"));
        }
        try {
            string = FileUtil.resolveShortWindowsName((String)filePath);
        }
        catch (IOException iOException) {
            String string2 = filePath;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "toCanonicalName"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "toCanonicalName"));
        }
        return string;
    }

    public synchronized boolean isDefaultProjectInitialized() {
        return this.myDefaultProject != null;
    }

    @NotNull
    public synchronized Project getDefaultProject() {
        LOG.assertTrue(!this.myDefaultProjectWasDisposed, (Object)"Default project has been already disposed!");
        if (this.myDefaultProject == null) {
            ProgressManager.getInstance().executeNonCancelableSection(() -> {
                try {
                    this.myDefaultProject = this.createProject(null, "", true);
                    this.initProject(this.myDefaultProject, null);
                }
                catch (Throwable t) {
                    PluginManager.processException(t);
                }
            });
        }
        ProjectImpl projectImpl = this.myDefaultProject;
        if (projectImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getDefaultProject"));
        }
        return projectImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Project[] getOpenProjects() {
        Object object = this.lock;
        // MONITORENTER : object
        // MONITOREXIT : object
        if (this.myOpenProjects != null) return this.myOpenProjects;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getOpenProjects"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProjectOpened(Project project2) {
        Object object = this.lock;
        synchronized (object) {
            return ArrayUtil.contains((Object)project2, (Object[])this.myOpenProjects);
        }
    }

    @Override
    public boolean openProject(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "openProject"));
        }
        if (ProjectManagerImpl.isLight(project2)) {
            ((ProjectImpl)project2).setTemporarilyDisposed(false);
            boolean isInitialized = StartupManagerEx.getInstanceEx(project2).startupActivityPassed();
            if (isInitialized) {
                this.addToOpened(project2);
                return true;
            }
        }
        for (Project p : this.myOpenProjects) {
            if (!ProjectUtil.isSameProject(project2.getBasePath(), p)) continue;
            ProjectUtil.focusProjectWindow(p, false);
            return false;
        }
        if (!this.addToOpened(project2)) {
            return false;
        }
        Runnable process2 = () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "lambda$openProject$5"));
            }
            TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "lambda$null$3"));
                }
                this.fireProjectOpened(project2);
            });
            StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)project2);
            startupManager.runStartupActivities();
            TransactionGuard.getInstance().submitTransactionAndWait(startupManager::startCacheUpdate);
            startupManager.runPostStartupActivitiesFromExtensions();
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "lambda$null$4"));
                }
                if (!project2.isDisposed()) {
                    startupManager.runPostStartupActivities();
                    Application application = ApplicationManager.getApplication();
                    if (!application.isHeadlessEnvironment() && !application.isUnitTestMode()) {
                        StorageUtil.checkUnknownMacros(project2, true);
                    }
                }
            }, (ModalityState)ModalityState.NON_MODAL);
        };
        if (this.myProgressManager.getProgressIndicator() != null) {
            process2.run();
            return true;
        }
        boolean ok = this.myProgressManager.runProcessWithProgressSynchronously(process2, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), ProjectManagerImpl.canCancelProjectLoading(), project2);
        if (!ok) {
            this.closeProject(project2, false, false, true);
            ProjectManagerImpl.notifyProjectOpenFailed();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToOpened(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addToOpened"));
        }
        assert (!project2.isDisposed()) : "Must not open already disposed project";
        Object object = this.lock;
        synchronized (object) {
            if (this.isProjectOpened(project2)) {
                return false;
            }
            this.myOpenProjects = (Project[])ArrayUtil.append((Object[])this.myOpenProjects, (Object)project2);
            ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 ? project2 : null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Collection<Project> removeFromOpened(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "removeFromOpened"));
        }
        Object object = this.lock;
        // MONITORENTER : object
        this.myOpenProjects = (Project[])ArrayUtil.remove((Object[])this.myOpenProjects, (Object)project2);
        ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 ? this.myOpenProjects[0] : null;
        List<Project> list = Arrays.asList(this.myOpenProjects);
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "removeFromOpened"));
    }

    private static boolean canCancelProjectLoading() {
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        return !(indicator instanceof NonCancelableSection);
    }

    public Project loadAndOpenProject(@NotNull String originalFilePath) throws IOException {
        if (originalFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFilePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "loadAndOpenProject"));
        }
        final String filePath = ProjectManagerImpl.toCanonicalName(originalFilePath);
        final ConversionResult conversionResult = ConversionService.getInstance().convert(filePath);
        Project project2 = conversionResult.openingIsCanceled() ? null : (Project)this.myProgressManager.run((Task.WithResult)new Task.WithResult<Project, IOException>(null, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), true){

            protected Project compute(@NotNull ProgressIndicator indicator) throws IOException {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/impl/ProjectManagerImpl$2", "compute"));
                }
                Project project2 = ProjectManagerImpl.this.loadProjectWithProgress(filePath);
                if (project2 == null) {
                    return null;
                }
                if (!conversionResult.conversionNotNeeded()) {
                    StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> conversionResult.postStartupActivity(project2));
                }
                ProjectManagerImpl.this.openProject(project2);
                return project2;
            }
        });
        if (project2 == null) {
            WelcomeFrame.showIfNoProjectOpened();
            return null;
        }
        if (!project2.isOpen()) {
            WelcomeFrame.showIfNoProjectOpened();
            ApplicationManager.getApplication().runWriteAction(() -> Disposer.dispose((Disposable)project2));
        }
        return project2;
    }

    @Override
    @Nullable
    public Project convertAndLoadProject(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "convertAndLoadProject"));
        }
        String fp = ProjectManagerImpl.toCanonicalName(filePath);
        ConversionResult conversionResult = ConversionService.getInstance().convert(fp);
        if (conversionResult.openingIsCanceled()) {
            return null;
        }
        Project project2 = this.loadProjectWithProgress(filePath);
        if (project2 != null && !conversionResult.conversionNotNeeded()) {
            StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> conversionResult.postStartupActivity(project2));
        }
        return project2;
    }

    @Nullable
    private Project loadProjectWithProgress(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "loadProjectWithProgress"));
        }
        try {
            ProjectImpl project2 = this.createProject(null, ProjectManagerImpl.toCanonicalName(filePath), false);
            if (this.myProgressManager.getProgressIndicator() != null) {
                this.initProject(project2, null);
                return project2;
            }
            this.myProgressManager.runProcessWithProgressSynchronously(() -> {
                this.initProject(project2, null);
                return project2;
            }, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), ProjectManagerImpl.canCancelProjectLoading(), (Project)project2);
            return project2;
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
    }

    private static void notifyProjectOpenFailed() {
        ((AppLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectOpenFailed();
        WelcomeFrame.showIfNoProjectOpened();
    }

    @Override
    public void openTestProject(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "openTestProject"));
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.openProject(project2);
        UIUtil.dispatchAllInvocationEvents();
    }

    @Override
    @NotNull
    public Collection<Project> closeTestProject(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeTestProject"));
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.closeProject(project2, false, false, false);
        Project[] projects = this.getOpenProjects();
        List<Object> list = projects.length == 0 ? Collections.emptyList() : Arrays.asList(projects);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeTestProject"));
        }
        return list;
    }

    public void reloadProject(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "reloadProject"));
        }
        ProjectManagerImpl.doReloadProject(project2);
    }

    public static void doReloadProject(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "doReloadProject"));
        }
        Ref projectRef = Ref.create((Object)project2);
        ProjectReloadState.getInstance((Project)project2).onBeforeAutomaticProjectReload();
        ApplicationManager.getApplication().invokeLater(() -> {
            LOG.debug("Reloading project.");
            Project project1 = (Project)projectRef.get();
            projectRef.set(null);
            if (project1.isDisposed()) {
                return;
            }
            String presentableUrl = project1.getPresentableUrl();
            if (!ProjectUtil.closeAndDispose(project1)) {
                return;
            }
            ProjectUtil.openProject(presentableUrl, null, true);
        }, ModalityState.NON_MODAL);
    }

    public boolean closeProject(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeProject"));
        }
        return this.closeProject(project2, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeProject(@NotNull Project project2, boolean save, boolean dispose, boolean checkCanClose) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeProject"));
        }
        if (ProjectManagerImpl.isLight(project2)) {
            if (!((ProjectImpl)project2).isTemporarilyDisposed()) {
                ((ProjectImpl)project2).setTemporarilyDisposed(true);
                this.removeFromOpened(project2);
                return true;
            }
            ((ProjectImpl)project2).setTemporarilyDisposed(false);
        } else if (!this.isProjectOpened(project2)) {
            return true;
        }
        if (checkCanClose && !this.canClose(project2)) {
            return false;
        }
        ShutDownTracker shutDownTracker = ShutDownTracker.getInstance();
        shutDownTracker.registerStopperThread(Thread.currentThread());
        try {
            if (save) {
                FileDocumentManager.getInstance().saveAllDocuments();
                project2.save();
            }
            if (checkCanClose && !ProjectManagerImpl.ensureCouldCloseIfUnableToSave(project2)) {
                boolean bl = false;
                return bl;
            }
            this.fireProjectClosing(project2);
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "lambda$closeProject$10"));
                }
                this.removeFromOpened(project2);
                this.fireProjectClosed(project2);
                if (dispose) {
                    Disposer.dispose((Disposable)project2);
                }
            });
        }
        finally {
            shutDownTracker.unregisterStopperThread(Thread.currentThread());
        }
        return true;
    }

    public static boolean isLight(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "isLight"));
        }
        return project2 instanceof ProjectImpl && ((ProjectImpl)project2).isLight();
    }

    @Override
    public boolean closeAndDispose(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeAndDispose"));
        }
        return this.closeProject(project2, true, true, true);
    }

    private void fireProjectClosing(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "fireProjectClosing"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: fireProjectClosing()");
        }
        for (ProjectManagerListener listener2 : this.myListeners) {
            try {
                listener2.projectClosing(project2);
            }
            catch (Exception e) {
                LOG.error("From listener " + listener2 + " (" + listener2.getClass() + ")", (Throwable)e);
            }
        }
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        this.myListeners.add(listener2);
    }

    public void addProjectManagerListener(final @NotNull ProjectManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        this.addProjectManagerListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ProjectManagerImpl.this.removeProjectManagerListener(listener2);
            }
        });
    }

    public void removeProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/project/impl/ProjectManagerImpl", "removeProjectManagerListener"));
        }
        boolean removed = this.myListeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    public void addProjectManagerListener(@NotNull Project project2, @NotNull ProjectManagerListener listener2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        List listeners = (List)project2.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (listeners == null) {
            listeners = (List)((UserDataHolderEx)project2).putUserDataIfAbsent(LISTENERS_IN_PROJECT_KEY, (Object)ContainerUtil.createLockFreeCopyOnWriteList());
        }
        listeners.add(listener2);
    }

    public void removeProjectManagerListener(@NotNull Project project2, @NotNull ProjectManagerListener listener2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "removeProjectManagerListener"));
        }
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/project/impl/ProjectManagerImpl", "removeProjectManagerListener"));
        }
        List listeners = (List)project2.getUserData(LISTENERS_IN_PROJECT_KEY);
        LOG.assertTrue(listeners != null);
        boolean removed = listeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    private void fireProjectOpened(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "fireProjectOpened"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectOpened");
        }
        for (ProjectManagerListener listener2 : this.myListeners) {
            try {
                listener2.projectOpened(project2);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void fireProjectClosed(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "fireProjectClosed"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectClosed");
        }
        for (ProjectManagerListener listener2 : this.myListeners) {
            try {
                listener2.projectClosed(project2);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public boolean canClose(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "canClose"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: canClose()");
        }
        for (ProjectManagerListener listener2 : this.myListeners) {
            try {
                if (listener2.canCloseProject(project2)) continue;
                return false;
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
        return true;
    }

    private static boolean ensureCouldCloseIfUnableToSave(@NotNull Project project2) {
        VirtualFile[] files;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "ensureCouldCloseIfUnableToSave"));
        }
        UnableToSaveProjectNotification[] notifications = (UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UnableToSaveProjectNotification.class, project2);
        if (notifications.length == 0) {
            return true;
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format("%s was unable to save some project files,\nare you sure you want to close this project anyway?", ApplicationNamesInfo.getInstance().getProductName()));
        message.append("\n\nRead-only files:\n");
        int count = 0;
        for (VirtualFile file2 : files = notifications[0].myFiles) {
            if (count == 10) {
                message.append('\n').append("and ").append(files.length - count).append(" more").append('\n');
                continue;
            }
            message.append(file2.getPath()).append('\n');
            ++count;
        }
        return Messages.showYesNoDialog((Project)project2, (String)message.toString(), (String)"Unsaved Project", (Icon)Messages.getWarningIcon()) == 0;
    }

    @Override
    public void saveChangedProjectFile(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/project/impl/ProjectManagerImpl", "saveChangedProjectFile"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "saveChangedProjectFile"));
        }
    }

    @Override
    public void blockReloadingProjectOnExternalChanges() {
    }

    @Override
    public void unblockReloadingProjectOnExternalChanges() {
    }

    public static class UnableToSaveProjectNotification
    extends Notification {
        private Project myProject;
        public VirtualFile[] myFiles;

        public UnableToSaveProjectNotification(@NotNull Project project2, @NotNull VirtualFile[] readOnlyFiles) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl$UnableToSaveProjectNotification", "<init>"));
            }
            if (readOnlyFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnlyFiles", "com/intellij/openapi/project/impl/ProjectManagerImpl$UnableToSaveProjectNotification", "<init>"));
            }
            super("Project Settings", "Could not save project", "Unable to save project files. Please ensure project files are writable and you have permissions to modify them. <a href=\"\">Try to save project again</a>.", NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/project/impl/ProjectManagerImpl$UnableToSaveProjectNotification$1", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/project/impl/ProjectManagerImpl$UnableToSaveProjectNotification$1", "hyperlinkUpdate"));
                    }
                    UnableToSaveProjectNotification unableToSaveProjectNotification = (UnableToSaveProjectNotification)notification;
                    Project _project = unableToSaveProjectNotification.myProject;
                    notification.expire();
                    if (_project != null && !_project.isDisposed()) {
                        _project.save();
                    }
                }
            });
            this.myProject = project2;
            this.myFiles = readOnlyFiles;
        }

        public void expire() {
            this.myProject = null;
            super.expire();
        }
    }
}

