/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.impl.ProjectRootUtil;
import com.intellij.openapi.projectRoots.impl.SimpleProjectRoot;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

class CompositeProjectRoot
implements ProjectRoot {
    private final List<ProjectRoot> myRoots = new ArrayList<ProjectRoot>();

    CompositeProjectRoot() {
    }

    @NotNull
    ProjectRoot[] getProjectRoots() {
        ProjectRoot[] projectRootArray = this.myRoots.toArray(new ProjectRoot[this.myRoots.size()]);
        if (projectRootArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/CompositeProjectRoot", "getProjectRoots"));
        }
        return projectRootArray;
    }

    @Override
    @NotNull
    public String getPresentableString() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public VirtualFile[] getVirtualFiles() {
        ArrayList result2 = new ArrayList();
        for (ProjectRoot root : this.myRoots) {
            ContainerUtil.addAll(result2, (Object[])root.getVirtualFiles());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/CompositeProjectRoot", "getVirtualFiles"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getUrls() {
        ArrayList result2 = new ArrayList();
        for (ProjectRoot root : this.myRoots) {
            ContainerUtil.addAll(result2, (Object[])root.getUrls());
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/CompositeProjectRoot", "getUrls"));
        }
        return stringArray;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    void remove(@NotNull ProjectRoot root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/projectRoots/impl/CompositeProjectRoot", "remove"));
        }
        this.myRoots.remove(root);
    }

    @NotNull
    ProjectRoot add(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/projectRoots/impl/CompositeProjectRoot", "add"));
        }
        SimpleProjectRoot root = new SimpleProjectRoot(virtualFile);
        this.myRoots.add(root);
        SimpleProjectRoot simpleProjectRoot = root;
        if (simpleProjectRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/CompositeProjectRoot", "add"));
        }
        return simpleProjectRoot;
    }

    void add(@NotNull ProjectRoot root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/projectRoots/impl/CompositeProjectRoot", "add"));
        }
        this.myRoots.add(root);
    }

    void remove(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/projectRoots/impl/CompositeProjectRoot", "remove"));
        }
        Iterator<ProjectRoot> iterator = this.myRoots.iterator();
        while (iterator.hasNext()) {
            SimpleProjectRoot r;
            ProjectRoot projectRoot = iterator.next();
            if (!(projectRoot instanceof SimpleProjectRoot) || !root.equals((r = (SimpleProjectRoot)projectRoot).getFile())) continue;
            iterator.remove();
        }
    }

    void clear() {
        this.myRoots.clear();
    }

    public void readExternal(Element element) {
        for (Element child : element.getChildren()) {
            this.myRoots.add(ProjectRootUtil.read(child));
        }
    }

    public void writeExternal(Element element) {
        for (ProjectRoot root : this.myRoots) {
            Element e = ProjectRootUtil.write(root);
            if (e == null) continue;
            element.addContent(e);
        }
    }

    @Override
    public void update() {
        for (ProjectRoot root : this.myRoots) {
            root.update();
        }
    }
}

