/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DependentSdkType
extends SdkType {
    public DependentSdkType(@NonNls String name) {
        super(name);
    }

    protected boolean checkDependency(SdkModel sdkModel) {
        return ContainerUtil.find((Object[])sdkModel.getSdks(), sdk -> this.isValidDependency((Sdk)sdk)) != null;
    }

    protected abstract boolean isValidDependency(Sdk var1);

    public abstract String getUnsatisfiedDependencyMessage();

    public boolean supportsCustomCreateUI() {
        return true;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @NotNull Consumer<Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModel", "com/intellij/openapi/projectRoots/impl/DependentSdkType", "showCustomCreateUI"));
        }
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/intellij/openapi/projectRoots/impl/DependentSdkType", "showCustomCreateUI"));
        }
        if (sdkCreatedCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkCreatedCallback", "com/intellij/openapi/projectRoots/impl/DependentSdkType", "showCustomCreateUI"));
        }
        if (!this.checkDependency(sdkModel)) {
            if (Messages.showOkCancelDialog((Component)parentComponent, (String)this.getUnsatisfiedDependencyMessage(), (String)"Cannot Create SDK", (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
            if (this.fixDependency(sdkModel, sdkCreatedCallback) == null) {
                return;
            }
        }
        DependentSdkType.createSdkOfType(sdkModel, this, sdkCreatedCallback);
    }

    protected abstract SdkType getDependencyType();

    protected Sdk fixDependency(SdkModel sdkModel, Consumer<Sdk> sdkCreatedCallback) {
        return DependentSdkType.createSdkOfType(sdkModel, this.getDependencyType(), sdkCreatedCallback);
    }

    protected static Sdk createSdkOfType(SdkModel sdkModel, SdkType sdkType, Consumer<Sdk> sdkCreatedCallback) {
        Ref result2 = new Ref(null);
        SdkConfigurationUtil.selectSdkHome(sdkType, (Consumer<String>)((Consumer)home -> {
            String newSdkName = SdkConfigurationUtil.createUniqueSdkName(sdkType, home, Arrays.asList(sdkModel.getSdks()));
            ProjectJdkImpl newJdk = new ProjectJdkImpl(newSdkName, (SdkTypeId)sdkType);
            newJdk.setHomePath((String)home);
            sdkCreatedCallback.consume((Object)newJdk);
            result2.set((Object)newJdk);
        }));
        return (Sdk)result2.get();
    }
}

