/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MockJdkWrapper
implements Sdk {
    private final String myHomePath;
    private final Sdk myDelegate;

    public MockJdkWrapper(String homePath, @NotNull Sdk delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/projectRoots/impl/MockJdkWrapper", "<init>"));
        }
        this.myHomePath = homePath;
        this.myDelegate = delegate;
    }

    public VirtualFile getHomeDirectory() {
        return LocalFileSystem.getInstance().findFileByIoFile(new File(this.getHomePath()));
    }

    public String getHomePath() {
        String homePath = FileUtil.toSystemDependentName((String)(this.myHomePath == null ? this.myDelegate.getHomePath() : this.myHomePath));
        return StringUtil.trimEnd((String)homePath, (String)File.separator);
    }

    @NotNull
    public SdkTypeId getSdkType() {
        SdkTypeId sdkTypeId = this.myDelegate.getSdkType();
        if (sdkTypeId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/MockJdkWrapper", "getSdkType"));
        }
        return sdkTypeId;
    }

    @NotNull
    public String getName() {
        String string = this.myDelegate.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/MockJdkWrapper", "getName"));
        }
        return string;
    }

    public String getVersionString() {
        return this.myDelegate.getVersionString();
    }

    @NotNull
    public RootProvider getRootProvider() {
        RootProvider rootProvider = this.myDelegate.getRootProvider();
        if (rootProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/MockJdkWrapper", "getRootProvider"));
        }
        return rootProvider;
    }

    public <T> T getUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/projectRoots/impl/MockJdkWrapper", "getUserData"));
        }
        return (T)this.myDelegate.getUserData(key2);
    }

    public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/projectRoots/impl/MockJdkWrapper", "putUserData"));
        }
        this.myDelegate.putUserData(key2, value);
    }

    @NotNull
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public SdkAdditionalData getSdkAdditionalData() {
        return null;
    }

    @NotNull
    public SdkModificator getSdkModificator() {
        SdkModificator sdkModificator = this.myDelegate.getSdkModificator();
        if (sdkModificator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/MockJdkWrapper", "getSdkModificator"));
        }
        return sdkModificator;
    }

    public Sdk getDelegate() {
        return this.myDelegate;
    }
}

