/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public abstract class RootProviderBaseImpl
implements RootProvider {
    private final EventDispatcher<RootProvider.RootSetChangedListener> myDispatcher = EventDispatcher.create(RootProvider.RootSetChangedListener.class);

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/RootProviderBaseImpl", "addRootSetChangedListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/RootProviderBaseImpl", "removeRootSetChangedListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/RootProviderBaseImpl", "addRootSetChangedListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/roots/impl/RootProviderBaseImpl", "addRootSetChangedListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void fireRootSetChanged() {
        ((RootProvider.RootSetChangedListener)this.myDispatcher.getMulticaster()).rootSetChanged((RootProvider)this);
    }
}

