/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ui.awt.RelativePoint;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurationError
implements Comparable<ConfigurationError> {
    private final String myPlainTextTitle;
    private final String myDescription;
    private boolean myIgnored;

    protected ConfigurationError(String plainTextTitle, String description) {
        this(plainTextTitle, description, false);
    }

    protected ConfigurationError(String plainTextTitle, String description, boolean ignored) {
        this.myPlainTextTitle = plainTextTitle;
        this.myDescription = description;
        this.myIgnored = ignored;
    }

    @NotNull
    public String getPlainTextTitle() {
        String string = this.myPlainTextTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ConfigurationError", "getPlainTextTitle"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ConfigurationError", "getDescription"));
        }
        return string;
    }

    public void ignore(boolean b) {
        if (b != this.myIgnored) {
            this.myIgnored = b;
        }
    }

    public boolean isIgnored() {
        return this.myIgnored;
    }

    public void fix(JComponent contextComponent, RelativePoint relativePoint) {
    }

    public boolean canBeFixed() {
        return true;
    }

    public abstract void navigate();

    @Override
    public int compareTo(ConfigurationError o) {
        if (this.myIgnored != o.isIgnored()) {
            return -1;
        }
        int titleResult = this.getPlainTextTitle().compareTo(o.getPlainTextTitle());
        if (titleResult != 0) {
            return titleResult;
        }
        int descriptionResult = this.getDescription().compareTo(o.getDescription());
        if (descriptionResult != 0) {
            return descriptionResult;
        }
        return 0;
    }
}

