/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.navigation.Place;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TabbedModuleEditor
extends ModuleEditor {
    private static final String SELECTED_EDITOR_KEY = TabbedModuleEditor.class.getName() + ".selectedEditor";
    private TabbedPaneWrapper myTabbedPane;

    public TabbedModuleEditor(Project project2, ModulesProvider modulesProvider, @NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/TabbedModuleEditor", "<init>"));
        }
        super(project2, modulesProvider, module2);
    }

    private static String getSavedSelectedEditor() {
        return PropertiesComponent.getInstance().getValue(SELECTED_EDITOR_KEY);
    }

    private void saveSelectedEditor() {
        String selectedTabName = this.getSelectedTabName();
        if (selectedTabName != null) {
            PropertiesComponent.getInstance().setValue(SELECTED_EDITOR_KEY, selectedTabName);
        }
    }

    @Override
    protected JComponent createCenterPanel() {
        this.myTabbedPane = new TabbedPaneWrapper(this);
        for (ModuleConfigurationEditor editor : this.myEditors) {
            this.myTabbedPane.addTab(editor.getDisplayName(), editor.createComponent());
            editor.reset();
        }
        this.restoreSelectedEditor();
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabbedModuleEditor.this.saveSelectedEditor();
                if (TabbedModuleEditor.this.myHistory != null) {
                    TabbedModuleEditor.this.myHistory.pushQueryPlace();
                }
            }
        });
        return this.myTabbedPane.getComponent();
    }

    @Override
    protected void restoreSelectedEditor() {
        this.selectEditor(TabbedModuleEditor.getSavedSelectedEditor());
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        if (place != null) {
            this.selectEditor((String)place.getPath("selectedEditor"));
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/roots/ui/configuration/TabbedModuleEditor", "queryPlace"));
        }
        place.putPath("selectedEditor", (Object)TabbedModuleEditor.getSavedSelectedEditor());
    }

    @Nullable
    private String getSelectedTabName() {
        return this.myTabbedPane == null || this.myTabbedPane.getSelectedIndex() == -1 ? null : this.myTabbedPane.getTitleAt(this.myTabbedPane.getSelectedIndex());
    }

    @Override
    public void selectEditor(@Nullable String name) {
        if (name != null) {
            this.getPanel();
            int editorTabIndex = this.getEditorTabIndex(name);
            if (editorTabIndex >= 0 && editorTabIndex < this.myTabbedPane.getTabCount()) {
                this.myTabbedPane.setSelectedIndex(editorTabIndex);
                this.saveSelectedEditor();
            }
        }
    }

    private int getEditorTabIndex(String editorName) {
        if (this.myTabbedPane != null && editorName != null) {
            int tabCount = this.myTabbedPane.getTabCount();
            for (int idx = 0; idx < tabCount; ++idx) {
                if (!editorName.equals(this.myTabbedPane.getTitleAt(idx))) continue;
                return idx;
            }
        }
        return -1;
    }

    @Override
    @Nullable
    public ModuleConfigurationEditor getEditor(@NotNull String displayName) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/openapi/roots/ui/configuration/TabbedModuleEditor", "getEditor"));
        }
        int index = this.getEditorTabIndex(displayName);
        if (0 <= index && index < this.myEditors.size()) {
            return (ModuleConfigurationEditor)this.myEditors.get(index);
        }
        return null;
    }

    @Override
    public ModuleConfigurationEditor getSelectedEditor() {
        if (this.myTabbedPane == null) {
            return null;
        }
        String title = this.myTabbedPane.getSelectedTitle();
        if (title == null) {
            return null;
        }
        return this.getEditor(title);
    }

    @Override
    protected void disposeCenterPanel() {
        if (this.myTabbedPane != null) {
            this.saveSelectedEditor();
            this.myTabbedPane = null;
        }
    }
}

