/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.ide.dnd.AdvancedDnDSource;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutNodesDraggingObject;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.SimpleDnDAwareTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.RenameablePackagingElement;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class LayoutTree
extends SimpleDnDAwareTree
implements AdvancedDnDSource {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTree");
    private final ArtifactEditorImpl myArtifactsEditor;

    public LayoutTree(ArtifactEditorImpl artifactsEditor) {
        this.myArtifactsEditor = artifactsEditor;
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.setCellEditor(new LayoutTreeCellEditor());
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().registerSource((AdvancedDnDSource)this);
        }
        this.setToolTipText("");
    }

    public void addSubtreeToUpdate(DefaultMutableTreeNode newNode) {
        AbstractTreeBuilder.getBuilderFor((JTree)((Object)this)).addSubtreeToUpdate(newNode);
    }

    protected void configureUiHelper(TreeUIHelper helper) {
        Convertor<TreePath, String> convertor = new Convertor<TreePath, String>(){

            public String convert(TreePath path) {
                SimpleNode node = LayoutTree.this.getNodeFor(path);
                if (node instanceof PackagingElementNode) {
                    return ((PackagingElementNode)node).getElementPresentation().getSearchName();
                }
                return "";
            }
        };
        new TreeSpeedSearch((Tree)this, convertor, true);
    }

    private List<PackagingElementNode<?>> getNodesToDrag() {
        return this.getSelection().getNodes();
    }

    public boolean canStartDragging(DnDAction action, Point dragOrigin) {
        return !this.getNodesToDrag().isEmpty();
    }

    public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
        return new DnDDragStartBean((Object)new LayoutNodesDraggingObject(this.myArtifactsEditor, this.getNodesToDrag()));
    }

    public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
        List<PackagingElementNode<?>> nodes = this.getNodesToDrag();
        if (nodes.size() == 1) {
            return DnDAwareTree.getDragImage((Tree)this, this.getPathFor((SimpleNode)nodes.get(0)), dragOrigin);
        }
        return DnDAwareTree.getDragImage((Tree)this, ProjectBundle.message((String)"drag.n.drop.text.0.packaging.elements", (Object[])new Object[]{nodes.size()}), dragOrigin);
    }

    public void dragDropEnd() {
    }

    public void dropActionChanged(int gestureModifiers) {
    }

    public void dispose() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().unregisterSource((AdvancedDnDSource)this);
        }
    }

    public LayoutTreeSelection getSelection() {
        return new LayoutTreeSelection(this);
    }

    @Nullable
    public PackagingElement<?> getElementByPath(TreePath path) {
        List elements;
        SimpleNode node = this.getNodeFor(path);
        if (node instanceof PackagingElementNode && !(elements = ((PackagingElementNode)node).getPackagingElements()).isEmpty()) {
            return (PackagingElement)elements.get(0);
        }
        return null;
    }

    public PackagingElementNode<?> getRootPackagingNode() {
        SimpleNode node = this.getNodeFor(new TreePath(this.getRootNode()));
        return node instanceof PackagingElementNode ? (PackagingElementNode)node : null;
    }

    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getModel().getRoot();
    }

    public List<PackagingElementNode<?>> findNodes(final Collection<? extends PackagingElement<?>> elements) {
        final ArrayList nodes = new ArrayList();
        TreeUtil.traverseDepth((TreeNode)this.getRootNode(), (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                PackagingElementNode packagingNode;
                List nodeElements;
                Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
                if (userObject instanceof PackagingElementNode && ContainerUtil.intersects(nodeElements = (packagingNode = (PackagingElementNode)((Object)userObject)).getPackagingElements(), (Collection)elements)) {
                    nodes.add(packagingNode);
                }
                return true;
            }
        });
        return nodes;
    }

    public void addSubtreeToUpdate(PackagingElementNode elementNode) {
        DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.getRootNode(), (Object)((Object)elementNode));
        if (node != null) {
            this.addSubtreeToUpdate(node);
        }
    }

    @Nullable
    public PackagingElementNode<?> findCompositeNodeByPath(String parentPath) {
        CompositePackagingElementNode node = this.getRootPackagingNode();
        for (String name : StringUtil.split((String)parentPath, (String)"/")) {
            if (node == null) {
                return null;
            }
            node = node.findCompositeChild(name);
        }
        return node;
    }

    private class LayoutTreeCellEditor
    extends DefaultCellEditor {
        public LayoutTreeCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            JTextField field = (JTextField)super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
            Object node = ((DefaultMutableTreeNode)value).getUserObject();
            Object element = ((PackagingElementNode)((Object)node)).getElementIfSingle();
            LOG.assertTrue(element != null);
            String name = ((RenameablePackagingElement)element).getName();
            field.setText(name);
            int i = name.lastIndexOf(46);
            field.setSelectionStart(0);
            field.setSelectionEnd(i != -1 ? i : name.length());
            return field;
        }

        @Override
        public boolean stopCellEditing() {
            boolean stopped;
            Object element;
            String newValue = ((JTextField)this.editorComponent).getText();
            TreePath path = LayoutTree.this.getEditingPath();
            SimpleNode node = LayoutTree.this.getNodeFor(path);
            RenameablePackagingElement currentElement = null;
            if (node instanceof PackagingElementNode && (element = ((PackagingElementNode)node).getElementIfSingle()) instanceof RenameablePackagingElement) {
                currentElement = (RenameablePackagingElement)element;
            }
            if ((stopped = super.stopCellEditing()) && currentElement != null) {
                RenameablePackagingElement finalCurrentElement = currentElement;
                LayoutTree.this.myArtifactsEditor.getLayoutTreeComponent().editLayout(() -> finalCurrentElement.rename(newValue));
                LayoutTree.this.myArtifactsEditor.queueValidation();
                LayoutTree.this.myArtifactsEditor.getLayoutTreeComponent().updatePropertiesPanel(true);
                LayoutTree.this.addSubtreeToUpdate((DefaultMutableTreeNode)path.getLastPathComponent());
                this.requestFocusToTree();
            }
            return stopped;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.requestFocusToTree();
        }

        private void requestFocusToTree() {
            IdeFocusManager.getInstance((Project)LayoutTree.this.myArtifactsEditor.getContext().getProject()).requestFocus((Component)((Object)LayoutTree.this), true);
        }
    }
}

