/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.impl.invalid.InvalidFacetManager;
import com.intellij.facet.impl.invalid.InvalidFacetType;
import com.intellij.facet.impl.ui.FacetEditorImpl;
import com.intellij.facet.impl.ui.facetType.FacetTypeEditor;
import com.intellij.facet.ui.FacetEditor;
import com.intellij.facet.ui.MultipleFacetSettingsEditor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.AddFacetOfTypeAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetEditorFacadeImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetTypeConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetsTreeCellRenderer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FrameworkDetectionConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.TextConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.FacetProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetStructureConfigurable
extends BaseStructureConfigurable {
    private final ModuleManager myModuleManager;
    private final Map<FacetType<?, ?>, FacetTypeEditor> myFacetTypeEditors = new HashMap();
    private MultipleFacetSettingsEditor myCurrentMultipleSettingsEditor;
    @NonNls
    private static final String NO_FRAMEWORKS_NODE = "No facets are configured";
    private boolean myTreeWasInitialized;

    public FacetStructureConfigurable(Project project2, ModuleManager moduleManager) {
        super(project2);
        this.myModuleManager = moduleManager;
    }

    protected String getComponentStateKey() {
        return "FacetStructureConfigurable.UI";
    }

    public static FacetStructureConfigurable getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable", "getInstance"));
        }
        return (FacetStructureConfigurable)((Object)ServiceManager.getService((Project)project2, FacetStructureConfigurable.class));
    }

    public boolean isVisible() {
        return FacetTypeRegistry.getInstance().getFacetTypes().length > 0 || !InvalidFacetManager.getInstance(this.myProject).getInvalidFacets().isEmpty();
    }

    @Override
    protected void initTree() {
        super.initTree();
        if (!this.myTreeWasInitialized) {
            this.myTreeWasInitialized = true;
            final FacetsTreeCellRenderer separatorRenderer = new FacetsTreeCellRenderer();
            final TreeCellRenderer oldRenderer = this.myTree.getCellRenderer();
            this.myTree.setCellRenderer(new TreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    if (value instanceof MasterDetailsComponent.MyNode && ((MasterDetailsComponent.MyNode)value).getConfigurable() instanceof FrameworkDetectionConfigurable) {
                        return separatorRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                    }
                    return oldRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                }
            });
            this.myTree.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    FacetStructureConfigurable.this.revalidateTree();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    FacetStructureConfigurable.this.revalidateTree();
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    FacetStructureConfigurable.this.revalidateTree();
                }
            });
        }
    }

    private void revalidateTree() {
        FilteringTreeBuilder.revalidateTree((Tree)this.myTree);
    }

    @Override
    protected void loadTree() {
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        boolean hasFacetTypeNodes = false;
        for (FacetType facetType : FacetTypeRegistry.getInstance().getFacetTypes()) {
            if (!ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(facetType.getId())) continue;
            hasFacetTypeNodes = true;
            this.addFacetTypeNode(facetType);
        }
        if (!InvalidFacetManager.getInstance(this.myProject).getInvalidFacets().isEmpty()) {
            hasFacetTypeNodes = true;
            this.addFacetTypeNode(InvalidFacetType.getInstance());
        }
        if (!hasFacetTypeNodes) {
            this.addNode(new MasterDetailsComponent.MyNode(new TextConfigurable<String>(NO_FRAMEWORKS_NODE, NO_FRAMEWORKS_NODE, "Facets", "Press '+' button to add a new facet", null)), this.myRoot);
        }
        this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new FrameworkDetectionConfigurable(this.myProject)), this.myRoot);
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        return (node1, node2) -> {
            NamedConfigurable c1 = node1.getConfigurable();
            NamedConfigurable c2 = node2.getConfigurable();
            if (c1 instanceof FrameworkDetectionConfigurable && !(c2 instanceof FrameworkDetectionConfigurable)) {
                return 1;
            }
            if (!(c1 instanceof FrameworkDetectionConfigurable) && c2 instanceof FrameworkDetectionConfigurable) {
                return -1;
            }
            return StringUtil.naturalCompare((String)node1.getDisplayName(), (String)node2.getDisplayName());
        };
    }

    private MasterDetailsComponent.MyNode addFacetTypeNode(FacetType<?, ?> facetType) {
        MasterDetailsComponent.MyNode noFrameworksNode = FacetStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)NO_FRAMEWORKS_NODE);
        if (noFrameworksNode != null) {
            this.removePaths(new TreePath[]{TreeUtil.getPathFromRoot((TreeNode)noFrameworksNode)});
        }
        FacetTypeConfigurable facetTypeConfigurable = new FacetTypeConfigurable(this, facetType);
        MasterDetailsComponent.MyNode facetTypeNode = new MasterDetailsComponent.MyNode((NamedConfigurable)facetTypeConfigurable);
        this.addNode(facetTypeNode, this.myRoot);
        FacetEditorFacadeImpl editorFacade = ModuleStructureConfigurable.getInstance(this.myProject).getFacetEditorFacade();
        this.addFacetNodes(facetTypeNode, ProjectFacetManager.getInstance((Project)this.myProject).getFacets(facetType.getId()), editorFacade);
        return facetTypeNode;
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<FacetProjectStructureElement> elements = new ArrayList<FacetProjectStructureElement>();
        for (Module module2 : this.myModuleManager.getModules()) {
            Facet[] facets;
            for (Facet facet : facets = FacetManager.getInstance((Module)module2).getAllFacets()) {
                elements.add(new FacetProjectStructureElement(this.myContext, facet));
            }
        }
        ArrayList<FacetProjectStructureElement> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable", "getProjectStructureElements"));
        }
        return arrayList;
    }

    public MasterDetailsComponent.MyNode getOrCreateFacetTypeNode(FacetType facetType) {
        MasterDetailsComponent.MyNode node = FacetStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)facetType);
        if (node != null) {
            return node;
        }
        return this.addFacetTypeNode(facetType);
    }

    public void addFacetNodes(@NotNull MasterDetailsComponent.MyNode facetTypeNode, @NotNull List<? extends Facet> facets, @NotNull FacetEditorFacadeImpl editorFacade) {
        if (facetTypeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetTypeNode", "com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable", "addFacetNodes"));
        }
        if (facets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facets", "com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable", "addFacetNodes"));
        }
        if (editorFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorFacade", "com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable", "addFacetNodes"));
        }
        for (Facet facet : facets) {
            FacetConfigurable facetConfigurable = editorFacade.getOrCreateConfigurable(facet);
            facetTypeNode.add((MutableTreeNode)((Object)new FacetConfigurableNode(facetConfigurable)));
            this.myContext.getDaemonAnalyzer().queueUpdate(new FacetProjectStructureElement(this.myContext, facet));
        }
        this.sortDescendants(facetTypeNode);
    }

    @Nullable
    public FacetTypeEditor getFacetTypeEditor(@NotNull FacetType<?, ?> facetType) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable", "getFacetTypeEditor"));
        }
        return this.myFacetTypeEditors.get(facetType);
    }

    public FacetTypeEditor getOrCreateFacetTypeEditor(@NotNull FacetType<?, ?> facetType) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable", "getOrCreateFacetTypeEditor"));
        }
        FacetTypeEditor editor = this.myFacetTypeEditors.get(facetType);
        if (editor == null) {
            editor = new FacetTypeEditor(this.myProject, this.myContext, facetType);
            editor.reset();
            this.myFacetTypeEditors.put(facetType, editor);
        }
        return editor;
    }

    @Override
    public void reset() {
        this.myFacetTypeEditors.clear();
        super.reset();
        TreeUtil.expandAll((JTree)this.myTree);
    }

    public void apply() throws ConfigurationException {
        super.apply();
        for (FacetTypeEditor editor : this.myFacetTypeEditors.values()) {
            editor.apply();
        }
    }

    public boolean isModified() {
        return super.isModified() || this.isEditorsModified();
    }

    private boolean isEditorsModified() {
        for (FacetTypeEditor editor : this.myFacetTypeEditors.values()) {
            if (!editor.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        for (FacetTypeEditor editor : this.myFacetTypeEditors.values()) {
            editor.disposeUIResources();
        }
        this.myFacetTypeEditors.clear();
    }

    @Override
    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add((AnAction)new BaseStructureConfigurable.AbstractAddGroup("Add"){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                AnAction[] anActionArray = AddFacetOfTypeAction.createAddFacetActions(FacetStructureConfigurable.this);
                if (anActionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable$3", "getChildren"));
                }
                return anActionArray;
            }
        });
        if (fromPopup) {
            actions.add(new MyNavigateAction());
        }
        actions.add((AnAction)new BaseStructureConfigurable.MyRemoveAction());
        if (fromPopup) {
            actions.add((AnAction)Separator.getInstance());
            this.addCollapseExpandActions(actions);
        }
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable", "createActions"));
        }
        return arrayList;
    }

    protected boolean updateMultiSelection(List<NamedConfigurable> selectedConfigurables) {
        return this.updateMultiSelection(selectedConfigurables, this.getDetailsComponent());
    }

    public boolean updateMultiSelection(List<NamedConfigurable> selectedConfigurables, DetailsComponent detailsComponent) {
        FacetType selectedFacetType = null;
        ArrayList<FacetEditorImpl> facetEditors = new ArrayList<FacetEditorImpl>();
        for (NamedConfigurable selectedConfigurable : selectedConfigurables) {
            if (!(selectedConfigurable instanceof FacetConfigurable)) continue;
            FacetConfigurable facetConfigurable = (FacetConfigurable)selectedConfigurable;
            FacetType facetType = facetConfigurable.getEditableObject().getType();
            if (selectedFacetType != null && selectedFacetType != facetType) {
                return false;
            }
            selectedFacetType = facetType;
            facetEditors.add(facetConfigurable.getEditor());
        }
        if (facetEditors.size() <= 1 || selectedFacetType == null) {
            return false;
        }
        FacetEditor[] selectedEditors = facetEditors.toArray(new FacetEditor[facetEditors.size()]);
        MultipleFacetSettingsEditor editor = selectedFacetType.createMultipleConfigurationsEditor(this.myProject, selectedEditors);
        if (editor == null) {
            return false;
        }
        this.setSelectedNode(null);
        this.myCurrentMultipleSettingsEditor = editor;
        detailsComponent.setText(new String[]{ProjectBundle.message((String)"multiple.facets.banner.0.1.facets", (Object[])new Object[]{selectedEditors.length, selectedFacetType.getPresentableName()})});
        detailsComponent.setContent(editor.createComponent());
        return true;
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        this.disposeMultipleSettingsEditor();
        if (configurable instanceof FacetTypeConfigurable) {
            ((FacetTypeConfigurable)configurable).updateComponent();
        }
        super.updateSelection(configurable);
    }

    public void disposeMultipleSettingsEditor() {
        if (this.myCurrentMultipleSettingsEditor != null) {
            this.myCurrentMultipleSettingsEditor.disposeUIResources();
            this.myCurrentMultipleSettingsEditor = null;
        }
    }

    @Override
    @Nullable
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return null;
    }

    @Override
    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new FacetRemoveHandler());
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.facets.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        String topic;
        FacetType facetType;
        String topic2;
        NamedConfigurable selectedConfigurable;
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(DataManager.getInstance().getDataContext());
        if (this.myTree.equals(component) && (selectedConfigurable = this.getSelectedConfigurable()) instanceof FacetTypeConfigurable && (topic2 = (facetType = ((FacetTypeConfigurable)selectedConfigurable).getEditableObject()).getHelpTopic()) != null) {
            return topic2;
        }
        if (this.myCurrentMultipleSettingsEditor != null && (topic = this.myCurrentMultipleSettingsEditor.getHelpTopic()) != null) {
            return topic;
        }
        topic = super.getHelpTopic();
        if (topic != null) {
            return topic;
        }
        return "reference.settingsdialog.project.structure.facet";
    }

    @NotNull
    public String getId() {
        if ("project.facets" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable", "getId"));
        }
        return "project.facets";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public void dispose() {
    }

    private class MyNavigateAction
    extends AnAction
    implements DumbAware {
        private MyNavigateAction() {
            super(ProjectBundle.message((String)"action.name.facet.navigate", (Object[])new Object[0]));
            this.registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)FacetStructureConfigurable.this.myTree);
        }

        public void update(AnActionEvent e) {
            NamedConfigurable selected = FacetStructureConfigurable.this.getSelectedConfigurable();
            e.getPresentation().setEnabled(selected instanceof FacetConfigurable);
        }

        public void actionPerformed(AnActionEvent e) {
            NamedConfigurable selected = FacetStructureConfigurable.this.getSelectedConfigurable();
            if (selected instanceof FacetConfigurable) {
                ProjectStructureConfigurable.getInstance(FacetStructureConfigurable.this.myProject).select(((FacetConfigurable)selected).getEditableObject(), true);
            }
        }
    }

    private class FacetConfigurableNode
    extends MasterDetailsComponent.MyNode {
        public FacetConfigurableNode(FacetConfigurable facetConfigurable) {
            super((NamedConfigurable)facetConfigurable);
        }

        @NotNull
        public String getDisplayName() {
            FacetConfigurable facetConfigurable = (FacetConfigurable)this.getConfigurable();
            String moduleName = FacetStructureConfigurable.this.myContext.getRealName(facetConfigurable.getEditableObject().getModule());
            String string = facetConfigurable.getDisplayName() + " (" + moduleName + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable$FacetConfigurableNode", "getDisplayName"));
            }
            return string;
        }
    }

    private class FacetRemoveHandler
    extends RemoveConfigurableHandler<Facet> {
        public FacetRemoveHandler() {
            super(FacetConfigurable.class);
        }

        @Override
        public boolean remove(@NotNull Collection<Facet> facets) {
            if (facets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facets", "com/intellij/openapi/roots/ui/configuration/projectRoot/FacetStructureConfigurable$FacetRemoveHandler", "remove"));
            }
            for (Facet facet : facets) {
                List<Facet> removed = FacetStructureConfigurable.this.myContext.myModulesConfigurator.getFacetsConfigurator().removeFacet(facet);
                ModuleStructureConfigurable.getInstance(FacetStructureConfigurable.this.myProject).removeFacetNodes(removed);
                for (Facet removedFacet : removed) {
                    FacetStructureConfigurable.this.myContext.getDaemonAnalyzer().removeElement(new FacetProjectStructureElement(FacetStructureConfigurable.this.myContext, removedFacet));
                }
            }
            return true;
        }
    }
}

