/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.actions.ActiveAnnotationGutter;
import com.intellij.openapi.vcs.actions.ColorMode;
import com.intellij.openapi.vcs.actions.ShortNameType;
import com.intellij.openapi.vcs.actions.ShowAnnotationColorsAction;
import com.intellij.openapi.vcs.actions.ShowShortenNames;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationFieldGutter
implements ActiveAnnotationGutter {
    @NotNull
    protected final FileAnnotation myAnnotation;
    protected final LineAnnotationAspect myAspect;
    @NotNull
    private final TextAnnotationPresentation myPresentation;
    private final boolean myIsGutterAction;
    @Nullable
    private Couple<Map<VcsRevisionNumber, Color>> myColorScheme;

    AnnotationFieldGutter(@NotNull FileAnnotation annotation, LineAnnotationAspect aspect, @NotNull TextAnnotationPresentation presentation, @Nullable Couple<Map<VcsRevisionNumber, Color>> colorScheme) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/openapi/vcs/actions/AnnotationFieldGutter", "<init>"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/vcs/actions/AnnotationFieldGutter", "<init>"));
        }
        this.myAnnotation = annotation;
        this.myAspect = aspect;
        this.myPresentation = presentation;
        this.myIsGutterAction = this.myAspect instanceof EditorGutterAction;
        this.myColorScheme = colorScheme;
    }

    public boolean isGutterAction() {
        return this.myIsGutterAction;
    }

    public String getLineText(int line, Editor editor) {
        String value;
        String string = value = this.isAvailable() ? this.myAspect.getValue(line) : "";
        if (this.myAspect.getId() == LineAnnotationAspect.AUTHOR && ShowShortenNames.isSet()) {
            return AnnotationFieldGutter.shorten(value, ShowShortenNames.getType());
        }
        return value;
    }

    @Nullable
    public static String shorten(String name, ShortNameType type) {
        if (name != null) {
            int[] ind = new int[]{name.indexOf(60), name.indexOf(64), name.indexOf(62)};
            if (0 < ind[0] && ind[0] < ind[1] && ind[1] < ind[2]) {
                return AnnotationFieldGutter.shorten(name.substring(0, ind[0]).trim(), type);
            }
            if (!name.contains(" ") && name.contains("@")) {
                String firstPart = name.substring(0, name.indexOf(64)).replace('.', ' ').replace('_', ' ').replace('-', ' ');
                if (firstPart.length() < name.length()) {
                    return AnnotationFieldGutter.shorten(firstPart, type);
                }
                return firstPart;
            }
            List strings = StringUtil.split((String)name.replace('.', ' ').replace('_', ' ').replace('-', ' '), (String)" ");
            if (strings.size() > 1) {
                return StringUtil.capitalize((String)(type == ShortNameType.FIRSTNAME ? (String)strings.get(0) : (String)strings.get(strings.size() - 1)));
            }
        }
        return name;
    }

    @Nullable
    public String getToolTip(int line, Editor editor) {
        return this.isAvailable() ? XmlStringUtil.escapeString((String)this.myAnnotation.getToolTip(line)) : null;
    }

    public void doAction(int line) {
        if (this.myIsGutterAction) {
            ((EditorGutterAction)this.myAspect).doAction(line);
        }
    }

    public Cursor getCursor(int line) {
        if (this.myIsGutterAction) {
            return ((EditorGutterAction)this.myAspect).getCursor(line);
        }
        return Cursor.getDefaultCursor();
    }

    public EditorFontType getStyle(int line, Editor editor) {
        return this.myPresentation.getFontType(line);
    }

    @Nullable
    public ColorKey getColor(int line, Editor editor) {
        return this.myPresentation.getColor(line);
    }

    public List<AnAction> getPopupActions(int line, Editor editor) {
        return this.myPresentation.getActions(line);
    }

    public void gutterClosed() {
        this.myAnnotation.unregister();
        this.myAnnotation.dispose();
    }

    @Nullable
    public Color getBgColor(int line, Editor editor) {
        Map colorMap;
        if (this.myColorScheme == null) {
            return null;
        }
        ColorMode type = ShowAnnotationColorsAction.getType();
        Map map = colorMap = type == ColorMode.AUTHOR ? (Map)this.myColorScheme.second : (Map)this.myColorScheme.first;
        if (colorMap == null || type == ColorMode.NONE) {
            return null;
        }
        VcsRevisionNumber number = this.myAnnotation.getLineRevisionNumber(line);
        if (number == null) {
            return null;
        }
        return (Color)colorMap.get(number);
    }

    public boolean isAvailable() {
        if (this.myAspect == null) {
            return false;
        }
        return VcsUtil.isAspectAvailableByDefault((String)this.getID(), (boolean)this.myAspect.isShowByDefault());
    }

    @Nullable
    public String getID() {
        return this.myAspect == null ? null : this.myAspect.getId();
    }

    public static void main(String[] args) {
        assert (AnnotationFieldGutter.shorten("Vasya Pavlovich Pupkin <asdasd@localhost>", ShortNameType.FIRSTNAME).equals("Vasya"));
        assert (AnnotationFieldGutter.shorten("Vasya Pavlovich Pupkin <asdasd@localhost>", ShortNameType.LASTNAME).equals("Pupkin"));
        assert (AnnotationFieldGutter.shorten("Vasya Pavlovich Pupkin", ShortNameType.FIRSTNAME).equals("Vasya"));
        assert (AnnotationFieldGutter.shorten("Vasya Pavlovich Pupkin", ShortNameType.LASTNAME).equals("Pupkin"));
        assert (AnnotationFieldGutter.shorten("vasya.pupkin@localhost.com", ShortNameType.LASTNAME).equals("Pupkin"));
        assert (AnnotationFieldGutter.shorten("vasya.pupkin@localhost.com", ShortNameType.FIRSTNAME).equals("Vasya"));
    }
}

