/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PsiChangeTracker {
    private PsiChangeTracker() {
    }

    public static <T extends PsiElement> Map<T, FileStatus> getElementsChanged(PsiElement file2, PsiElement oldFile, PsiFilter<T> filter) {
        FileStatus status2;
        HashMap<PsiElement, FileStatus> result2 = new HashMap<PsiElement, FileStatus>();
        ArrayList oldElements = new ArrayList();
        ArrayList elements = new ArrayList();
        if (file2 == null) {
            oldFile.accept((PsiElementVisitor)filter.createVisitor(oldElements));
            PsiChangeTracker.calculateStatuses(elements, oldElements, result2, filter);
            return result2;
        }
        Project project2 = file2.getProject();
        file2.accept((PsiElementVisitor)filter.createVisitor(elements));
        VirtualFile vf = file2.getContainingFile().getVirtualFile();
        FileStatus fileStatus = status2 = vf == null ? null : FileStatusManager.getInstance((Project)project2).getStatus(vf);
        if (status2 == null && oldFile == null) {
            status2 = FileStatus.ADDED;
        }
        if (status2 == FileStatus.ADDED || status2 == FileStatus.DELETED || status2 == FileStatus.DELETED_FROM_FS || status2 == FileStatus.UNKNOWN) {
            for (PsiElement element : elements) {
                result2.put(element, status2);
            }
            return result2;
        }
        if (oldFile == null) {
            return result2;
        }
        oldFile.accept((PsiElementVisitor)filter.createVisitor(oldElements));
        PsiChangeTracker.calculateStatuses(elements, oldElements, result2, filter);
        return result2;
    }

    private static <T extends PsiElement> Map<T, FileStatus> calculateStatuses(List<T> elements, List<T> oldElements, Map<T, FileStatus> result2, PsiFilter<T> filter) {
        for (PsiElement element : elements) {
            PsiElement e = null;
            for (PsiElement oldElement : oldElements) {
                if (!filter.areEquivalent(element, oldElement)) continue;
                e = oldElement;
                break;
            }
            if (e != null) {
                oldElements.remove(e);
                if (element.getText().equals(e.getText())) continue;
                result2.put(element, FileStatus.MODIFIED);
                continue;
            }
            result2.put(element, FileStatus.ADDED);
        }
        for (PsiElement oldElement : oldElements) {
            result2.put(oldElement, FileStatus.DELETED);
        }
        return result2;
    }
}

