/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.TodoItemData;
import com.intellij.openapi.vcs.checkin.StepIntersection;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class TodoForRanges {
    protected final Project myProject;
    private final List<TextRange> myRanges;
    private final int myAdditionalOffset;
    protected final String myFileName;
    protected final String myText;
    protected final boolean myOldRevision;
    protected final FileType myFileType;

    protected TodoForRanges(Project project2, List<TextRange> ranges, int additionalOffset, String name, String text, boolean revision, FileType type) {
        this.myProject = project2;
        this.myRanges = ranges;
        this.myAdditionalOffset = additionalOffset;
        this.myFileName = name;
        this.myText = text;
        this.myOldRevision = revision;
        this.myFileType = type;
    }

    public List<Pair<TextRange, TextAttributes>> execute() {
        TodoItemData[] todoItems = this.getTodoItems();
        StepIntersection stepIntersection = new StepIntersection((Convertor)new Convertor<TodoItemData, TextRange>(){

            public TextRange convert(TodoItemData o) {
                return o.getTextRange();
            }
        }, (Convertor)Convertor.SELF, this.myRanges, () -> "");
        List filtered = stepIntersection.process(Arrays.asList(todoItems));
        ArrayList<Pair<TextRange, TextAttributes>> result2 = new ArrayList<Pair<TextRange, TextAttributes>>(filtered.size());
        int offset = 0;
        for (TextRange range : this.myRanges) {
            TodoItemData item;
            Iterator iterator = filtered.iterator();
            while (iterator.hasNext() && range.contains((item = (TodoItemData)iterator.next()).getTextRange())) {
                TextRange todoRange = new TextRange(offset - range.getStartOffset() + item.getTextRange().getStartOffset(), offset - range.getStartOffset() + item.getTextRange().getEndOffset());
                result2.add((Pair<TextRange, TextAttributes>)Pair.create((Object)todoRange, (Object)item.getPattern().getAttributes().getTextAttributes()));
                iterator.remove();
            }
            offset += range.getLength() + 1 + this.myAdditionalOffset;
        }
        return result2;
    }

    protected abstract TodoItemData[] getTodoItems();

    protected TodoItem[] getTodoForText(PsiTodoSearchHelper helper) {
        PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

            public PsiFile compute() {
                return PsiFileFactory.getInstance((Project)TodoForRanges.this.myProject).createFileFromText((TodoForRanges.this.myOldRevision ? "old" : "") + TodoForRanges.this.myFileName, TodoForRanges.this.myFileType, (CharSequence)TodoForRanges.this.myText);
            }
        });
        return helper.findTodoItemsLight(psiFile);
    }
}

