/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.ChangeDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.ConflictedDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.MultipleDiffRequestPresentable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Convertor;

public class ChangeForDiffConvertor
implements Convertor<Change, DiffRequestPresentable> {
    private final Project myProject;
    private final boolean myRecursive;

    public ChangeForDiffConvertor(Project project2, boolean recursive) {
        this.myProject = project2;
        this.myRecursive = recursive;
    }

    public DiffRequestPresentable convert(Change o) {
        return this.convert(o, false);
    }

    public DiffRequestPresentable convert(Change ch, boolean forceText) {
        if (ch.hasOtherLayers() && this.myRecursive) {
            return new MultipleDiffRequestPresentable(this.myProject, ch);
        }
        if (ChangesUtil.isTextConflictingChange((Change)ch)) {
            AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)ch, (Project)this.myProject);
            if (vcs == null || vcs.getMergeProvider() == null) {
                return null;
            }
            FilePath path = ChangesUtil.getFilePath((Change)ch);
            VirtualFile vf = path.getVirtualFile();
            if (vf == null) {
                vf = LocalFileSystem.getInstance().refreshAndFindFileByPath(path.getPath());
            }
            if (vf == null) {
                return null;
            }
            return new ConflictedDiffRequestPresentable(this.myProject, vf, ch);
        }
        if (forceText && ch.getBeforeRevision() != null && ch.getAfterRevision() != null) {
            try {
                if (StringUtil.isEmptyOrSpaces((String)ch.getBeforeRevision().getContent()) && StringUtil.isEmptyOrSpaces((String)ch.getAfterRevision().getContent())) {
                    return null;
                }
                if (StringUtil.equals((CharSequence)ch.getBeforeRevision().getContent(), (CharSequence)ch.getAfterRevision().getContent())) {
                    return null;
                }
            }
            catch (VcsException vcs) {
                // empty catch block
            }
        }
        ChangeDiffRequestPresentable presentable = new ChangeDiffRequestPresentable(this.myProject, ch);
        if (forceText) {
            presentable.setIgnoreDirectoryFlag(true);
        }
        return presentable;
    }
}

