/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.google.common.base.Objects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchException;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedChange {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.ShelvedChange");
    private final String myPatchPath;
    private final String myBeforePath;
    private final String myAfterPath;
    private final FileStatus myFileStatus;
    private Change myChange;

    public ShelvedChange(String patchPath, String beforePath, String afterPath, FileStatus fileStatus) {
        this.myPatchPath = patchPath;
        this.myBeforePath = beforePath;
        this.myAfterPath = Comparing.equal((String)beforePath, (String)afterPath) ? beforePath : afterPath;
        this.myFileStatus = fileStatus;
    }

    public boolean isConflictingChange(Project project2) {
        block3: {
            ContentRevision afterRevision = this.getChange(project2).getAfterRevision();
            if (afterRevision == null) {
                return false;
            }
            try {
                afterRevision.getContent();
            }
            catch (VcsException e) {
                if (!(e.getCause() instanceof ApplyPatchException)) break block3;
                return true;
            }
        }
        return false;
    }

    public String getBeforePath() {
        return this.myBeforePath;
    }

    @Nullable
    public VirtualFile getBeforeVFUnderProject(Project project2) {
        if (this.myBeforePath == null || project2.getBaseDir() == null) {
            return null;
        }
        File baseDir = new File(project2.getBaseDir().getPath());
        File file2 = new File(baseDir, this.myBeforePath);
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
    }

    public String getAfterPath() {
        return this.myAfterPath;
    }

    @Nullable
    public String getAfterFileName() {
        if (this.myAfterPath == null) {
            return null;
        }
        int pos = this.myAfterPath.lastIndexOf(47);
        if (pos >= 0) {
            return this.myAfterPath.substring(pos + 1);
        }
        return this.myAfterPath;
    }

    public String getBeforeFileName() {
        int pos = this.myBeforePath.lastIndexOf(47);
        if (pos >= 0) {
            return this.myBeforePath.substring(pos + 1);
        }
        return this.myBeforePath;
    }

    public String getBeforeDirectory() {
        int pos = this.myBeforePath.lastIndexOf(47);
        if (pos >= 0) {
            return this.myBeforePath.substring(0, pos).replace('/', File.separatorChar);
        }
        return File.separator;
    }

    public FileStatus getFileStatus() {
        return this.myFileStatus;
    }

    public Change getChange(Project project2) {
        if (this.myChange == null) {
            File baseDir = new File(project2.getBaseDir().getPath());
            File file2 = ShelvedChange.getAbsolutePath(baseDir, this.myBeforePath);
            FilePath beforePath = VcsUtil.getFilePath((File)file2, (boolean)false);
            beforePath.refresh();
            CurrentContentRevision beforeRevision = null;
            if (this.myFileStatus != FileStatus.ADDED) {
                beforeRevision = new CurrentContentRevision(beforePath){

                    @NotNull
                    public VcsRevisionNumber getRevisionNumber() {
                        TextRevisionNumber textRevisionNumber = new TextRevisionNumber(VcsBundle.message((String)"local.version.title", (Object[])new Object[0]));
                        if (textRevisionNumber == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChange$1", "getRevisionNumber"));
                        }
                        return textRevisionNumber;
                    }
                };
            }
            PatchedContentRevision afterRevision = null;
            if (this.myFileStatus != FileStatus.DELETED) {
                FilePath afterPath = VcsUtil.getFilePath((File)ShelvedChange.getAbsolutePath(baseDir, this.myAfterPath), (boolean)false);
                afterRevision = new PatchedContentRevision(project2, beforePath, afterPath);
            }
            this.myChange = new Change((ContentRevision)beforeRevision, afterRevision, this.myFileStatus);
        }
        return this.myChange;
    }

    private static File getAbsolutePath(File baseDir, String relativePath) {
        File file2;
        try {
            file2 = new File(baseDir, relativePath).getCanonicalFile();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            file2 = new File(baseDir, relativePath);
        }
        return file2;
    }

    @Nullable
    public TextFilePatch loadFilePatch(Project project2, CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> filePatches = ShelveChangesManager.loadPatches(project2, this.myPatchPath, commitContext);
        for (TextFilePatch patch : filePatches) {
            if (!this.myBeforePath.equals(patch.getBeforeName())) continue;
            return patch;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShelvedChange)) {
            return false;
        }
        ShelvedChange that = (ShelvedChange)o;
        if (this.myAfterPath != null ? !this.myAfterPath.equals(that.myAfterPath) : that.myAfterPath != null) {
            return false;
        }
        if (this.myBeforePath != null ? !this.myBeforePath.equals(that.myBeforePath) : that.myBeforePath != null) {
            return false;
        }
        if (this.myFileStatus != null ? !this.myFileStatus.equals(that.myFileStatus) : that.myFileStatus != null) {
            return false;
        }
        return !(this.myPatchPath != null ? !this.myPatchPath.equals(that.myPatchPath) : that.myPatchPath != null);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myPatchPath, this.myBeforePath, this.myAfterPath, this.myFileStatus});
    }

    public String getPatchPath() {
        return this.myPatchPath;
    }

    public String toString() {
        return FileUtil.toSystemDependentName((String)(this.myBeforePath == null ? this.myAfterPath : this.myBeforePath));
    }

    private class PatchedContentRevision
    implements ContentRevision {
        private final Project myProject;
        private final FilePath myBeforeFilePath;
        private final FilePath myAfterFilePath;

        public PatchedContentRevision(Project project2, FilePath beforeFilePath, FilePath afterFilePath) {
            this.myProject = project2;
            this.myBeforeFilePath = beforeFilePath;
            this.myAfterFilePath = afterFilePath;
        }

        @Nullable
        public String getContent() throws VcsException {
            try {
                return this.loadContent();
            }
            catch (Exception e) {
                throw new VcsException((Throwable)e);
            }
        }

        @Nullable
        private String loadContent() throws IOException, PatchSyntaxException, ApplyPatchException {
            TextFilePatch patch = ShelvedChange.this.loadFilePatch(this.myProject, null);
            if (patch != null) {
                return this.loadContent(patch);
            }
            return null;
        }

        private String loadContent(TextFilePatch patch) throws ApplyPatchException {
            if (patch.isNewFile()) {
                return patch.getNewFileText();
            }
            if (patch.isDeletedFile()) {
                return null;
            }
            GenericPatchApplier applier = new GenericPatchApplier(this.getBaseContent(), patch.getHunks());
            if (applier.execute()) {
                return applier.getAfter();
            }
            throw new ApplyPatchException("Apply patch conflict");
        }

        private String getBaseContent() {
            this.myBeforeFilePath.refresh();
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    Document doc = FileDocumentManager.getInstance().getDocument(PatchedContentRevision.this.myBeforeFilePath.getVirtualFile());
                    return doc.getText();
                }
            });
        }

        @NotNull
        public FilePath getFile() {
            FilePath filePath = this.myAfterFilePath;
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChange$PatchedContentRevision", "getFile"));
            }
            return filePath;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            TextRevisionNumber textRevisionNumber = new TextRevisionNumber(VcsBundle.message((String)"shelved.version.name", (Object[])new Object[0]));
            if (textRevisionNumber == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChange$PatchedContentRevision", "getRevisionNumber"));
            }
            return textRevisionNumber;
        }
    }
}

