/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.configurable.VcsCheckBoxWithSpinnerConfigurable;
import com.intellij.ui.components.JBCheckBox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCommitMessageMarginConfigurable
implements UnnamedConfigurable {
    @NotNull
    private final VcsConfiguration myConfiguration;
    @NotNull
    private final MySpinnerConfigurable mySpinnerConfigurable;
    @NotNull
    private final JBCheckBox myWrapCheckbox;

    public VcsCommitMessageMarginConfigurable(@NotNull Project project2, @NotNull VcsConfiguration vcsConfiguration) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/configurable/VcsCommitMessageMarginConfigurable", "<init>"));
        }
        if (vcsConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsConfiguration", "com/intellij/openapi/vcs/configurable/VcsCommitMessageMarginConfigurable", "<init>"));
        }
        this.myConfiguration = vcsConfiguration;
        this.mySpinnerConfigurable = new MySpinnerConfigurable(project2);
        this.myWrapCheckbox = new JBCheckBox(ApplicationBundle.message((String)"checkbox.wrap.typing.on.right.margin", (Object[])new Object[0]), false);
    }

    @Nullable
    public JComponent createComponent() {
        JComponent spinnerComponent = this.mySpinnerConfigurable.createComponent();
        this.mySpinnerConfigurable.myHighlightRecentlyChanged.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsCommitMessageMarginConfigurable.this.myWrapCheckbox.setEnabled(((VcsCommitMessageMarginConfigurable)VcsCommitMessageMarginConfigurable.this).mySpinnerConfigurable.myHighlightRecentlyChanged.isSelected());
            }
        });
        JPanel rootPanel = new JPanel(new FlowLayout(0, 0, 0));
        rootPanel.add(spinnerComponent);
        rootPanel.add((Component)this.myWrapCheckbox);
        return rootPanel;
    }

    public boolean isModified() {
        return this.mySpinnerConfigurable.isModified() || this.myWrapCheckbox.isSelected() != this.myConfiguration.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN;
    }

    public void apply() throws ConfigurationException {
        this.mySpinnerConfigurable.apply();
        this.myConfiguration.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN = this.myWrapCheckbox.isSelected();
    }

    public void reset() {
        this.mySpinnerConfigurable.reset();
        this.myWrapCheckbox.setSelected(this.myConfiguration.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN);
        this.myWrapCheckbox.setEnabled(this.mySpinnerConfigurable.myHighlightRecentlyChanged.isSelected());
    }

    public void disposeUIResources() {
        this.mySpinnerConfigurable.disposeUIResources();
    }

    private class MySpinnerConfigurable
    extends VcsCheckBoxWithSpinnerConfigurable {
        public MySpinnerConfigurable(Project project2) {
            super(project2, VcsBundle.message((String)"configuration.commit.message.margin.prompt", (Object[])new Object[0]), "");
        }

        @Override
        protected SpinnerNumberModel createSpinnerModel() {
            int columns = ((VcsCommitMessageMarginConfigurable)VcsCommitMessageMarginConfigurable.this).myConfiguration.COMMIT_MESSAGE_MARGIN_SIZE;
            return new SpinnerNumberModel(columns, 0, 10000, 1);
        }

        @Nls
        public String getDisplayName() {
            return VcsBundle.message((String)"configuration.commit.message.margin.title", (Object[])new Object[0]);
        }

        public boolean isModified() {
            if (this.myHighlightRecentlyChanged.isSelected() != ((VcsCommitMessageMarginConfigurable)VcsCommitMessageMarginConfigurable.this).myConfiguration.USE_COMMIT_MESSAGE_MARGIN) {
                return true;
            }
            return !Comparing.equal((Object)this.myHighlightInterval.getValue(), (Object)((VcsCommitMessageMarginConfigurable)VcsCommitMessageMarginConfigurable.this).myConfiguration.COMMIT_MESSAGE_MARGIN_SIZE);
        }

        public void apply() throws ConfigurationException {
            ((VcsCommitMessageMarginConfigurable)VcsCommitMessageMarginConfigurable.this).myConfiguration.USE_COMMIT_MESSAGE_MARGIN = this.myHighlightRecentlyChanged.isSelected();
            ((VcsCommitMessageMarginConfigurable)VcsCommitMessageMarginConfigurable.this).myConfiguration.COMMIT_MESSAGE_MARGIN_SIZE = ((Number)this.myHighlightInterval.getValue()).intValue();
        }

        public void reset() {
            this.myHighlightRecentlyChanged.setSelected(((VcsCommitMessageMarginConfigurable)VcsCommitMessageMarginConfigurable.this).myConfiguration.USE_COMMIT_MESSAGE_MARGIN);
            this.myHighlightInterval.setValue(((VcsCommitMessageMarginConfigurable)VcsCommitMessageMarginConfigurable.this).myConfiguration.COMMIT_MESSAGE_MARGIN_SIZE);
            this.myHighlightInterval.setEnabled(this.myHighlightRecentlyChanged.isSelected());
        }
    }
}

