/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.actions.ShowNextChangeMarkerAction;
import com.intellij.openapi.vcs.actions.ShowPrevChangeMarkerAction;
import com.intellij.openapi.vcs.ex.CopyLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopup;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RollbackLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.ShowLineStatusRangeDiffAction;
import java.awt.Point;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineStatusTrackerDrawing {
    private LineStatusTrackerDrawing() {
    }

    public static void moveToRange(Range range, Editor editor, LineStatusTracker tracker) {
        new MyLineStatusMarkerPopup(tracker, editor, range).scrollAndShow();
    }

    public static void showHint(Range range, Editor editor, LineStatusTracker tracker) {
        new MyLineStatusMarkerPopup(tracker, editor, range).showAfterScroll();
    }

    private static class ToggleByWordDiffAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final Range myRange;
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final LineStatusTracker myTracker;
        @Nullable
        private final Point myMousePosition;

        public ToggleByWordDiffAction(@NotNull Range range, @NotNull Editor editor, @NotNull LineStatusTracker tracker, @Nullable Point mousePosition) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$ToggleByWordDiffAction", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$ToggleByWordDiffAction", "<init>"));
            }
            if (tracker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$ToggleByWordDiffAction", "<init>"));
            }
            super("Show Detailed Differences", null, AllIcons.Actions.PreviewDetails);
            this.myRange = range;
            this.myEditor = editor;
            this.myTracker = tracker;
            this.myMousePosition = mousePosition;
        }

        public boolean isSelected(AnActionEvent e) {
            return VcsApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            VcsApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES = state;
            new MyLineStatusMarkerPopup(this.myTracker, this.myEditor, this.myRange).showHintAt(this.myMousePosition);
        }
    }

    public static class MyLineStatusMarkerPopup
    extends LineStatusMarkerPopup {
        @NotNull
        private final LineStatusTracker myTracker;

        public MyLineStatusMarkerPopup(@NotNull LineStatusTracker tracker, @NotNull Editor editor, @NotNull Range range) {
            if (tracker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$MyLineStatusMarkerPopup", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$MyLineStatusMarkerPopup", "<init>"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$MyLineStatusMarkerPopup", "<init>"));
            }
            super(tracker, editor, range);
            this.myTracker = tracker;
        }

        @Override
        protected boolean isShowInnerDifferences() {
            return VcsApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES;
        }

        @Override
        @NotNull
        protected ActionToolbar buildToolbar(@Nullable Point mousePosition, @NotNull Disposable parentDisposable) {
            if (parentDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$MyLineStatusMarkerPopup", "buildToolbar"));
            }
            DefaultActionGroup group = new DefaultActionGroup();
            final ShowPrevChangeMarkerAction localShowPrevAction = new ShowPrevChangeMarkerAction(this.myTracker.getPrevRange(this.myRange), this.myTracker, this.myEditor);
            final ShowNextChangeMarkerAction localShowNextAction = new ShowNextChangeMarkerAction(this.myTracker.getNextRange(this.myRange), this.myTracker, this.myEditor);
            final RollbackLineStatusRangeAction rollback = new RollbackLineStatusRangeAction(this.myTracker, this.myRange, this.myEditor);
            final ShowLineStatusRangeDiffAction showDiff = new ShowLineStatusRangeDiffAction(this.myTracker, this.myRange, this.myEditor);
            final CopyLineStatusRangeAction copyRange = new CopyLineStatusRangeAction(this.myTracker, this.myRange);
            ToggleByWordDiffAction toggleWordDiff = new ToggleByWordDiffAction(this.myRange, this.myEditor, this.myTracker, mousePosition);
            group.add((AnAction)localShowPrevAction);
            group.add((AnAction)localShowNextAction);
            group.add((AnAction)rollback);
            group.add((AnAction)showDiff);
            group.add((AnAction)copyRange);
            group.add((AnAction)toggleWordDiff);
            JComponent editorComponent = this.myEditor.getComponent();
            DiffUtil.registerAction((AnAction)localShowPrevAction, editorComponent);
            DiffUtil.registerAction((AnAction)localShowNextAction, editorComponent);
            DiffUtil.registerAction((AnAction)rollback, editorComponent);
            DiffUtil.registerAction(showDiff, editorComponent);
            DiffUtil.registerAction(copyRange, editorComponent);
            final List actionList = ActionUtil.getActions((JComponent)editorComponent);
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    actionList.remove((Object)localShowPrevAction);
                    actionList.remove((Object)localShowNextAction);
                    actionList.remove((Object)rollback);
                    actionList.remove((Object)showDiff);
                    actionList.remove((Object)copyRange);
                }
            });
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("FileHistoryViewToolbar", (ActionGroup)group, true);
            if (actionToolbar == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$MyLineStatusMarkerPopup", "buildToolbar"));
            }
            return actionToolbar;
        }

        @Override
        @NotNull
        protected FileType getFileType() {
            FileType fileType = this.myTracker.getVirtualFile().getFileType();
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$MyLineStatusMarkerPopup", "getFileType"));
            }
            return fileType;
        }
    }
}

