/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListByDateComparator;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.VcsRevisionNumberAware;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRevisionNumberArrayRule
implements GetDataRule {
    @Override
    @Nullable
    public Object getData(DataProvider dataProvider) {
        List<VcsRevisionNumber> revisionNumbers = this.getRevisionNumbers(dataProvider);
        return !ContainerUtil.isEmpty(revisionNumbers) ? ArrayUtil.toObjectArray(revisionNumbers, VcsRevisionNumber.class) : null;
    }

    @Nullable
    public List<VcsRevisionNumber> getRevisionNumbers(@NotNull DataProvider dataProvider) {
        List committedChangeLists;
        if (dataProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/openapi/vcs/history/VcsRevisionNumberArrayRule", "getRevisionNumbers"));
        }
        VcsRevisionNumber revisionNumber = (VcsRevisionNumber)VcsDataKeys.VCS_REVISION_NUMBER.getData(dataProvider);
        if (revisionNumber != null) {
            return Collections.singletonList(revisionNumber);
        }
        Object[] changeLists = (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(dataProvider);
        if (changeLists != null && changeLists.length > 0 && !(committedChangeLists = ContainerUtil.findAll((Object[])changeLists, CommittedChangeList.class)).isEmpty()) {
            ContainerUtil.sort((List)committedChangeLists, CommittedChangeListByDateComparator.DESCENDING);
            return ContainerUtil.mapNotNull((Collection)committedChangeLists, (Function)CommittedChangeListToRevisionNumberFunction.INSTANCE);
        }
        Object[] fileRevisions = (VcsFileRevision[])VcsDataKeys.VCS_FILE_REVISIONS.getData(dataProvider);
        if (fileRevisions != null && fileRevisions.length > 0) {
            return ContainerUtil.mapNotNull((Object[])fileRevisions, (Function)FileRevisionToRevisionNumberFunction.INSTANCE);
        }
        return null;
    }

    private static class FileRevisionToRevisionNumberFunction
    implements Function<VcsFileRevision, VcsRevisionNumber> {
        private static final FileRevisionToRevisionNumberFunction INSTANCE = new FileRevisionToRevisionNumberFunction();

        private FileRevisionToRevisionNumberFunction() {
        }

        public VcsRevisionNumber fun(VcsFileRevision fileRevision) {
            return fileRevision.getRevisionNumber();
        }
    }

    private static class CommittedChangeListToRevisionNumberFunction
    implements Function<CommittedChangeList, VcsRevisionNumber> {
        private static final CommittedChangeListToRevisionNumberFunction INSTANCE = new CommittedChangeListToRevisionNumberFunction();

        private CommittedChangeListToRevisionNumberFunction() {
        }

        public VcsRevisionNumber fun(CommittedChangeList changeList) {
            return changeList instanceof VcsRevisionNumberAware ? ((VcsRevisionNumberAware)changeList).getRevisionNumber() : null;
        }
    }
}

