/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleVcsPathPresenter
extends VcsPathPresenter {
    private final Project myProject;

    public ModuleVcsPathPresenter(Project project2) {
        this.myProject = project2;
    }

    public String getPresentableRelativePathFor(final VirtualFile file2) {
        if (file2 == null) {
            return "";
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                boolean hideExcludedFiles = Registry.is((String)"ide.hide.excluded.files");
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)ModuleVcsPathPresenter.this.myProject).getFileIndex();
                Module module2 = fileIndex.getModuleForFile(file2, hideExcludedFiles);
                VirtualFile contentRoot = fileIndex.getContentRootForFile(file2, hideExcludedFiles);
                if (module2 == null || contentRoot == null) {
                    return file2.getPresentableUrl();
                }
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)contentRoot, (char)File.separatorChar);
                assert (relativePath != null);
                return ModuleVcsPathPresenter.getPresentableRelativePathFor(module2, contentRoot, relativePath);
            }
        });
    }

    public String getPresentableRelativePath(@NotNull ContentRevision fromRevision, @NotNull ContentRevision toRevision) {
        String moduleResult;
        if (fromRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromRevision", "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter", "getPresentableRelativePath"));
        }
        if (toRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRevision", "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter", "getPresentableRelativePath"));
        }
        final FilePath fromPath = fromRevision.getFile();
        final FilePath toPath = toRevision.getFile();
        final VirtualFile fromParent = ModuleVcsPathPresenter.getParentFile(fromPath);
        final VirtualFile toParent = ModuleVcsPathPresenter.getParentFile(toPath);
        if (fromParent != null && toParent != null && (moduleResult = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                boolean hideExcludedFiles = Registry.is((String)"ide.hide.excluded.files");
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)ModuleVcsPathPresenter.this.myProject).getFileIndex();
                Module fromModule = fileIndex.getModuleForFile(fromParent, hideExcludedFiles);
                Module toModule = fileIndex.getModuleForFile(toParent, hideExcludedFiles);
                if (fromModule == null || toModule == null || fromModule.equals(toModule)) {
                    return null;
                }
                VirtualFile fromContentRoot = fileIndex.getContentRootForFile(fromParent, hideExcludedFiles);
                if (fromContentRoot == null) {
                    return null;
                }
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)fromParent, (VirtualFile)fromContentRoot, (char)File.separatorChar);
                assert (relativePath != null);
                relativePath = relativePath + File.separatorChar;
                if (!fromPath.getName().equals(toPath.getName())) {
                    relativePath = relativePath + fromPath.getName();
                }
                return ModuleVcsPathPresenter.getPresentableRelativePathFor(fromModule, fromContentRoot, relativePath);
            }
        })) != null) {
            return moduleResult;
        }
        RelativePathCalculator calculator = new RelativePathCalculator(toPath.getPath(), fromPath.getPath());
        calculator.execute();
        String result2 = calculator.getResult();
        return result2 != null ? result2.replace("/", File.separator) : null;
    }

    @Nullable
    private static VirtualFile getParentFile(@NotNull FilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter", "getParentFile"));
        }
        FilePath parentPath = path.getParentPath();
        return parentPath != null ? parentPath.getVirtualFile() : null;
    }

    @NotNull
    private static String getPresentableRelativePathFor(@NotNull Module module2, @NotNull VirtualFile contentRoot, @NotNull String relativePath) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter", "getPresentableRelativePathFor"));
        }
        if (contentRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter", "getPresentableRelativePathFor"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter", "getPresentableRelativePathFor"));
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("[");
        result2.append(module2.getName());
        result2.append("] ");
        result2.append(contentRoot.getName());
        if (!relativePath.isEmpty()) {
            result2.append(File.separatorChar);
            result2.append(relativePath);
        }
        String string = result2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter", "getPresentableRelativePathFor"));
        }
        return string;
    }
}

