/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.JarHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarFileSystemImpl
extends JarFileSystem {
    private final Set<String> myNoCopyJarPaths;
    private final File myNoCopyJarDir;

    public JarFileSystemImpl() {
        boolean noCopy = SystemProperties.getBooleanProperty((String)"idea.jars.nocopy", (!SystemInfo.isWindows ? 1 : 0) != 0);
        this.myNoCopyJarPaths = noCopy ? null : ContainerUtil.newConcurrentSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        boolean runningFromDist = new File(PathManager.getLibPath(), "openapi.jar").exists();
        this.myNoCopyJarDir = !runningFromDist ? null : new File(PathManager.getHomePath());
    }

    public void setNoCopyJarForPath(String pathInJar) {
        if (this.myNoCopyJarPaths == null || pathInJar == null) {
            return;
        }
        int index = pathInJar.indexOf("!/");
        if (index < 0) {
            return;
        }
        String path = FileUtil.toSystemIndependentName((String)pathInJar.substring(0, index));
        this.myNoCopyJarPaths.add(path);
    }

    @Nullable
    public File getMirroredFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getMirroredFile"));
        }
        VirtualFile root = this.getRootByLocal(vFile);
        return root == null ? null : this.getHandler(root).getFileToUse();
    }

    public boolean isMakeCopyOfJar(@NotNull File originalJar) {
        if (originalJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalJar", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "isMakeCopyOfJar"));
        }
        if (this.myNoCopyJarPaths == null || this.myNoCopyJarPaths.contains(originalJar.getPath())) {
            return false;
        }
        return this.myNoCopyJarDir == null || !FileUtil.isAncestor((File)this.myNoCopyJarDir, (File)originalJar, (boolean)false);
    }

    @NotNull
    public String getProtocol() {
        if ("jar" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getProtocol"));
        }
        return "jar";
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "extractPresentableUrl"));
        }
        String string = super.extractPresentableUrl(StringUtil.trimEnd((String)path, (String)"!/"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "extractPresentableUrl"));
        }
        return string;
    }

    protected String normalize(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "normalize"));
        }
        int jarSeparatorIndex = path.indexOf("!/");
        if (jarSeparatorIndex > 0) {
            String root = path.substring(0, jarSeparatorIndex);
            return FileUtil.normalize((String)root) + path.substring(jarSeparatorIndex);
        }
        return super.normalize(path);
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "extractRootPath"));
        }
        int jarSeparatorIndex = path.indexOf("!/");
        assert (jarSeparatorIndex >= 0) : "Path passed to JarFileSystem must have jar separator '!/': " + path;
        String string = path.substring(0, jarSeparatorIndex + "!/".length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "extractRootPath"));
        }
        return string;
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "extractLocalPath"));
        }
        String string = StringUtil.trimEnd((String)rootPath, (String)"!/");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "extractLocalPath"));
        }
        return string;
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "composeRootPath"));
        }
        String string = localPath + "!/";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "composeRootPath"));
        }
        return string;
    }

    @NotNull
    protected JarHandler getHandler(@NotNull VirtualFile entryFile) {
        if (entryFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryFile", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getHandler"));
        }
        JarHandler jarHandler = (JarHandler)((Object)VfsImplUtil.getHandler((ArchiveFileSystem)this, entryFile, localPath -> new JarHandler((String)localPath)));
        if (jarHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getHandler"));
        }
        return jarHandler;
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "findFileByPath"));
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "findFileByPathIfCached"));
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "refreshAndFindFileByPath"));
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, asynchronous);
    }
}

