/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jrt;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class JrtHandler
extends ArchiveHandler {
    private static final URI ROOT_URI = URI.create("jrt:/");
    private SoftReference<FileSystem> myFileSystem;
    private final StringInterner myInterner;

    public JrtHandler(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jrt/JrtHandler", "<init>"));
        }
        super(path);
        this.myInterner = new StringInterner();
    }

    private synchronized FileSystem getFileSystem() throws IOException {
        FileSystem fs = (FileSystem)SoftReference.dereference(this.myFileSystem);
        if (fs == null) {
            if (SystemInfo.isJavaVersionAtLeast((String)"9")) {
                fs = FileSystems.newFileSystem(ROOT_URI, Collections.singletonMap("java.home", this.getFile().getPath()));
            } else {
                URL url = new File(this.getFile(), "jrt-fs.jar").toURI().toURL();
                URLClassLoader loader = new URLClassLoader(new URL[]{url}, null);
                fs = FileSystems.newFileSystem(ROOT_URI, Collections.emptyMap(), (ClassLoader)loader);
            }
            this.myFileSystem = new SoftReference((Object)fs);
        }
        return fs;
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        final HashMap map = ContainerUtil.newHashMap();
        map.put("", this.createRootEntry());
        Path root = this.getFileSystem().getPath("/modules", new String[0]);
        if (!Files.exists(root, new LinkOption[0])) {
            throw new FileNotFoundException("JRT root missing");
        }
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                this.process(dir, attrs);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                this.process(file2, attrs);
                return FileVisitResult.CONTINUE;
            }

            private void process(Path entry, BasicFileAttributes attrs) throws IOException {
                int pathLength = entry.getNameCount();
                if (pathLength <= 2) {
                    return;
                }
                Path relativePath = entry.subpath(2, pathLength);
                String path = relativePath.toString();
                String shortName = entry.getFileName().toString();
                if (map.containsKey(path) || "module-info.class".equals(shortName)) {
                    return;
                }
                ArchiveHandler.EntryInfo parent = (ArchiveHandler.EntryInfo)map.get(pathLength > 3 ? relativePath.getParent().toString() : "");
                if (parent == null) {
                    throw new IOException("Out of order: " + entry);
                }
                long length = attrs.size();
                long modified = attrs.lastModifiedTime().toMillis();
                if (attrs.isDirectory()) {
                    map.put(path, new ArchiveHandler.EntryInfo((CharSequence)shortName, true, length, modified, parent));
                } else {
                    String module2 = (String)JrtHandler.this.myInterner.intern((Object)entry.getName(1).toString());
                    map.put(path, new JrtEntryInfo(shortName, module2, length, modified, parent));
                }
            }
        });
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtHandler", "createEntriesMap"));
        }
        return hashMap;
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/jrt/JrtHandler", "contentsToByteArray"));
        }
        ArchiveHandler.EntryInfo entry = this.getEntryInfo(relativePath);
        if (!(entry instanceof JrtEntryInfo)) {
            throw new FileNotFoundException(this.getFile() + " : " + relativePath);
        }
        Path path = this.getFileSystem().getPath("/modules/" + ((JrtEntryInfo)entry).myModule + '/' + relativePath, new String[0]);
        byte[] byArray = Files.readAllBytes(path);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtHandler", "contentsToByteArray"));
        }
        return byArray;
    }

    private static class JrtEntryInfo
    extends ArchiveHandler.EntryInfo {
        private final String myModule;

        /*
         * WARNING - void declaration
         */
        public JrtEntryInfo(@NotNull String shortName, @NotNull String module2, long length, long timestamp, ArchiveHandler.EntryInfo entryInfo) {
            void parent;
            if (shortName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/openapi/vfs/impl/jrt/JrtHandler$JrtEntryInfo", "<init>"));
            }
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/vfs/impl/jrt/JrtHandler$JrtEntryInfo", "<init>"));
            }
            super((CharSequence)shortName, false, length, timestamp, (ArchiveHandler.EntryInfo)parent);
            this.myModule = module2;
        }
    }
}

