/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.ui.EngravedTextGraphics;
import com.intellij.ui.Gray;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.border.Border;

class ContentTabLabel
extends BaseLabel {
    Content myContent;
    private final BaseButtonBehavior myBehavior;
    private final TabContentLayout myLayout;

    public ContentTabLabel(Content content, TabContentLayout layout) {
        super(layout.myUi, true);
        this.myLayout = layout;
        this.myContent = content;
        this.update();
        this.myBehavior = new BaseButtonBehavior(this){

            protected void execute(MouseEvent e) {
                ContentManager mgr = ContentTabLabel.this.contentManager();
                if (mgr.getIndexOfContent(ContentTabLabel.this.myContent) >= 0) {
                    mgr.setSelectedContent(ContentTabLabel.this.myContent, true);
                }
            }
        };
        this.myBehavior.setActionTrigger(501);
        this.myBehavior.setMouseDeadzone(TimedDeadzone.NULL);
    }

    public void update() {
        if (!this.myLayout.isToDrawTabs()) {
            this.setHorizontalAlignment(2);
            this.setBorder(null);
        } else {
            this.setHorizontalAlignment(0);
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)8));
        }
        this.updateTextAndIcon(this.myContent, this.isSelected());
    }

    @Override
    protected boolean allowEngravement() {
        return this.isSelected() || this.myUi != null && this.myUi.myWindow.isActive();
    }

    @Override
    protected Color getActiveFg(boolean selected) {
        if (this.contentManager().getContentCount() > 1) {
            return selected ? Color.white : (UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : Color.black);
        }
        return super.getActiveFg(selected);
    }

    @Override
    protected Color getPassiveFg(boolean selected) {
        if (this.contentManager().getContentCount() > 1) {
            return selected && !UIUtil.isUnderDarcula() ? Gray._255 : (UIUtil.isUnderDarcula() ? UIUtil.getLabelDisabledForeground() : Gray._75);
        }
        return super.getPassiveFg(selected);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public boolean isSelected() {
        return this.contentManager().isSelected(this.myContent);
    }

    @Override
    protected Graphics _getGraphics(Graphics2D g) {
        if (this.isSelected() && this.contentManager().getContentCount() > 1) {
            return new EngravedTextGraphics(g, 1, 1, Gray._0.withAlpha(this.myUi.myWindow.isActive() ? 120 : 130));
        }
        return super._getGraphics(g);
    }

    private ContentManager contentManager() {
        return this.myUi.myWindow.getContentManager();
    }

    @Override
    public Content getContent() {
        return this.myContent;
    }
}

