/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.ProblemScope;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.ProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProvider;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultScopesProvider
extends CustomScopesProviderEx {
    private final NamedScope myProblemsScope;
    private final Project myProject;
    private final List<NamedScope> myScopes;

    public static DefaultScopesProvider getInstance(Project project2) {
        return (DefaultScopesProvider)((Object)Extensions.findExtension((ExtensionPointName)CUSTOM_SCOPES_PROVIDER, (AreaInstance)project2, DefaultScopesProvider.class));
    }

    public DefaultScopesProvider(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packageDependencies/DefaultScopesProvider", "<init>"));
        }
        this.myProject = project2;
        ProjectFilesScope projectScope = new ProjectFilesScope();
        NonProjectFilesScope nonProjectScope = new NonProjectFilesScope();
        this.myProblemsScope = new ProblemScope(project2);
        this.myScopes = Arrays.asList(projectScope, this.getProblemsScope(), DefaultScopesProvider.getAllScope(), nonProjectScope);
    }

    @NotNull
    public List<NamedScope> getCustomScopes() {
        List<NamedScope> list = this.myScopes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DefaultScopesProvider", "getCustomScopes"));
        }
        return list;
    }

    @NotNull
    public NamedScope getProblemsScope() {
        NamedScope namedScope = this.myProblemsScope;
        if (namedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DefaultScopesProvider", "getProblemsScope"));
        }
        return namedScope;
    }

    @NotNull
    public List<NamedScope> getAllCustomScopes() {
        ArrayList<NamedScope> scopes = new ArrayList<NamedScope>();
        for (CustomScopesProvider provider : (CustomScopesProvider[])Extensions.getExtensions((ExtensionPointName)CUSTOM_SCOPES_PROVIDER, (AreaInstance)this.myProject)) {
            scopes.addAll(provider.getFilteredScopes());
        }
        ArrayList<NamedScope> arrayList = scopes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DefaultScopesProvider", "getAllCustomScopes"));
        }
        return arrayList;
    }

    @Nullable
    public NamedScope findCustomScope(String name) {
        for (NamedScope scope : this.getAllCustomScopes()) {
            if (!name.equals(scope.getName())) continue;
            return scope;
        }
        return null;
    }
}

