/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.projectWizard.ExistingModuleLoader;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.platform.templates.SaveProjectAsTemplateAction;
import com.intellij.platform.templates.TemplateProjectDirectoryGenerator;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.apache.velocity.exception.VelocityException;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateModuleBuilder
extends ModuleBuilder {
    private final ModuleType myType;
    private List<WizardInputField> myAdditionalFields;
    private ArchivedProjectTemplate myTemplate;
    private boolean myProjectMode;
    private static final Logger LOG = Logger.getInstance(TemplateModuleBuilder.class);

    public TemplateModuleBuilder(ArchivedProjectTemplate template, ModuleType moduleType, List<WizardInputField> additionalFields) {
        this.myTemplate = template;
        this.myType = moduleType;
        this.myAdditionalFields = additionalFields;
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "com/intellij/platform/templates/TemplateModuleBuilder", "createWizardSteps"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/platform/templates/TemplateModuleBuilder", "createWizardSteps"));
        }
        ModuleBuilder builder = this.myType.createModuleBuilder();
        return builder.createWizardSteps(wizardContext, modulesProvider);
    }

    protected List<WizardInputField> getAdditionalFields() {
        return this.myAdditionalFields;
    }

    public Module commitModule(@NotNull Project project2, ModifiableModuleModel model) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/platform/templates/TemplateModuleBuilder", "commitModule"));
        }
        if (this.myProjectMode) {
            Module[] modules = ModuleManager.getInstance((Project)project2).getModules();
            if (modules.length > 0) {
                Module module2 = modules[0];
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        this.setupModule(module2);
                    }
                    catch (ConfigurationException e) {
                        LOG.error((Throwable)e);
                    }
                });
                StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/platform/templates/TemplateModuleBuilder", "lambda$commitModule$2"));
                    }
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (project2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/platform/templates/TemplateModuleBuilder", "lambda$null$1"));
                        }
                        try {
                            ModifiableModuleModel modifiableModuleModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
                            modifiableModuleModel.renameModule(module2, module2.getProject().getName());
                            modifiableModuleModel.commit();
                            this.fixModuleName(module2);
                        }
                        catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                            // empty catch block
                        }
                    });
                });
                return module2;
            }
            return null;
        }
        return super.commitModule(project2, model);
    }

    @Nullable
    public String getBuilderId() {
        return this.myTemplate.getName();
    }

    public ModuleType getModuleType() {
        return this.myType;
    }

    public Icon getNodeIcon() {
        return this.myTemplate.getIcon();
    }

    public boolean isTemplateBased() {
        return true;
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/platform/templates/TemplateModuleBuilder", "createModule"));
        }
        String path = this.getContentEntryPath();
        ExistingModuleLoader loader = ExistingModuleLoader.setUpLoader(this.getModuleFilePath());
        this.unzip(loader.getName(), path, true, null, true);
        Module module2 = loader.createModule(moduleModel);
        if (this.myProjectMode) {
            moduleModel.renameModule(module2, module2.getProject().getName());
        }
        this.fixModuleName(module2);
        Module module3 = module2;
        if (module3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/TemplateModuleBuilder", "createModule"));
        }
        return module3;
    }

    private void fixModuleName(Module module2) {
        List configurations = RunManager.getInstance((Project)module2.getProject()).getAllConfigurationsList();
        for (RunConfiguration configuration : configurations) {
            if (!(configuration instanceof ModuleBasedConfiguration)) continue;
            ((ModuleBasedConfiguration)configuration).getConfigurationModule().setModule(module2);
        }
        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
        for (WizardInputField field : this.myAdditionalFields) {
            ProjectTemplateParameterFactory factory = WizardInputField.getFactoryById((String)field.getId());
            factory.applyResult(field.getValue(), model);
        }
        model.commit();
    }

    private WizardInputField getBasePackageField() {
        for (WizardInputField field : this.getAdditionalFields()) {
            if (!"IJ_BASE_PACKAGE".equals(field.getId())) continue;
            return field;
        }
        return null;
    }

    private void unzip(final @Nullable String projectName, String path, boolean moduleMode, final @Nullable ProgressIndicator pI, final boolean reportFailuresWithDialog) {
        WizardInputField basePackage = this.getBasePackageField();
        try {
            File to;
            File from;
            final NullableFunction pathConvertor = path1 -> {
                if (moduleMode && path1.contains(".idea")) {
                    return null;
                }
                if (basePackage != null) {
                    return path1.replace(TemplateModuleBuilder.getPathFragment(basePackage.getDefaultValue()), TemplateModuleBuilder.getPathFragment(basePackage.getValue()));
                }
                return path1;
            };
            final File dir = new File(path);
            class ExceptionConsumer
            implements Consumer<VelocityException> {
                private String myPath;
                private String myText;
                private SmartList<Trinity<String, String, VelocityException>> myFailures = new SmartList();

                ExceptionConsumer() {
                }

                public void consume(VelocityException e) {
                    this.myFailures.add((Object)Trinity.create((Object)this.myPath, (Object)this.myText, (Object)((Object)e)));
                }

                private void setCurrentFile(String path, String text) {
                    this.myPath = path;
                    this.myText = text;
                }

                private void reportFailures() {
                    if (this.myFailures.isEmpty()) {
                        return;
                    }
                    if (reportFailuresWithDialog) {
                        String dialogMessage;
                        if (this.myFailures.size() == 1) {
                            dialogMessage = "Failed to decode file '" + (String)((Trinity)this.myFailures.get(0)).getFirst() + "'";
                        } else {
                            StringBuilder dialogMessageBuilder = new StringBuilder();
                            dialogMessageBuilder.append("Failed to decode files: \n");
                            for (Trinity failure : this.myFailures) {
                                dialogMessageBuilder.append((String)failure.getFirst()).append("\n");
                            }
                            dialogMessage = dialogMessageBuilder.toString();
                        }
                        Messages.showErrorDialog((String)dialogMessage, (String)"Decoding Template");
                    }
                    StringBuilder reportBuilder = new StringBuilder();
                    for (Trinity failure : this.myFailures) {
                        reportBuilder.append("File: ").append((String)failure.getFirst()).append("\n");
                        reportBuilder.append("Exception:\n").append(ExceptionUtil.getThrowableText((Throwable)((Throwable)failure.getThird()))).append("\n");
                        reportBuilder.append("File content:\n'").append((String)failure.getSecond()).append("'\n");
                        reportBuilder.append("\n===========================================\n");
                    }
                    LOG.error((Object)LogMessageEx.createEvent("Cannot decode files in template", "", new Attachment("Files in template", reportBuilder.toString())));
                }
            }
            final ExceptionConsumer consumer = new ExceptionConsumer();
            this.myTemplate.processStream(new ArchivedProjectTemplate.StreamProcessor<Void>(){
                {
                }

                @Override
                public Void consume(@NotNull ZipInputStream stream) throws IOException {
                    if (stream == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/platform/templates/TemplateModuleBuilder$1", "consume"));
                    }
                    ZipUtil.unzip(ProgressManager.getInstance().getProgressIndicator(), dir, stream, (NullableFunction<String, String>)pathConvertor, new ZipUtil.ContentProcessor(){

                        @Override
                        public byte[] processContent(byte[] content, File file2) throws IOException {
                            if (pI != null) {
                                pI.checkCanceled();
                            }
                            FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(FileUtilRt.getExtension((String)file2.getName()));
                            String text = new String(content, CharsetToolkit.UTF8_CHARSET);
                            consumer.setCurrentFile(file2.getName(), text);
                            return fileType.isBinary() ? content : TemplateModuleBuilder.this.processTemplates(projectName, text, file2, (Consumer<VelocityException>)consumer);
                        }
                    }, true);
                    return null;
                }
            });
            if (pI != null) {
                pI.setText("Refreshing...");
            }
            String iml = (String)ContainerUtil.find((Object[])dir.list(), s -> s.endsWith(".iml"));
            if (moduleMode && !(from = new File(path, iml)).renameTo(to = new File(this.getModuleFilePath()))) {
                throw new IOException("Can't rename " + from + " to " + to);
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
            if (virtualFile == null) {
                throw new IOException("Can't find " + dir);
            }
            RefreshQueue.getInstance().refresh(false, true, null, new VirtualFile[]{virtualFile});
            consumer.reportFailures();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getPathFragment(String value) {
        return "/" + value.replace('.', '/') + "/";
    }

    @Nullable
    private byte[] processTemplates(@Nullable String projectName, String content, File file2, Consumer<VelocityException> exceptionConsumer) throws IOException {
        String patchedContent = content;
        if (!(this.myTemplate instanceof LocalArchivedTemplate) || ((LocalArchivedTemplate)this.myTemplate).isEscaped()) {
            for (WizardInputField wizardInputField : this.myAdditionalFields) {
                if (wizardInputField.acceptFile(file2)) continue;
                return null;
            }
            Properties properties = FileTemplateManager.getDefaultInstance().getDefaultProperties();
            for (WizardInputField field : this.myAdditionalFields) {
                properties.putAll((Map<?, ?>)field.getValues());
            }
            if (projectName != null) {
                properties.put("IJ_PROJECT_NAME", projectName);
            }
            String string = FileTemplateUtil.mergeTemplate(properties, content, true, exceptionConsumer);
            patchedContent = string.replace("\\$", "$").replace("\\#", "#");
        } else {
            int i = content.indexOf("<IntelliJ_File_Header>");
            if (i != -1) {
                FileTemplate fileTemplate = FileTemplateManager.getDefaultInstance().getDefaultTemplate(SaveProjectAsTemplateAction.getFileHeaderTemplateName());
                Properties properties = FileTemplateManager.getDefaultInstance().getDefaultProperties();
                String templateText = fileTemplate.getText(properties);
                patchedContent = patchedContent.substring(0, i) + templateText + patchedContent.substring(i + "<IntelliJ_File_Header>".length());
            }
        }
        return StringUtilRt.convertLineSeparators((String)patchedContent, (String)CodeStyleFacade.getInstance().getLineSeparator()).getBytes(CharsetToolkit.UTF8_CHARSET);
    }

    @Nullable
    public Project createProject(final String name, final String path) {
        final File location = new File(FileUtil.toSystemDependentName((String)path));
        LOG.assertTrue(location.exists());
        final VirtualFile baseDir = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(location);
            }
        });
        if (baseDir == null) {
            LOG.error("Couldn't find path '" + path + "' in VFS");
            return null;
        }
        VirtualFile[] children2 = baseDir.getChildren();
        final boolean isSomehowOverwriting = children2.length > 1 || children2.length == 1 && !".idea".equals(children2[0].getName());
        final Ref canceledRef = new Ref();
        final Ref projectRef = new Ref();
        Task.Modal task = new Task.Modal(null, "Applying Template", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/platform/templates/TemplateModuleBuilder$3", "run"));
                }
                try {
                    projectRef.set((Object)TemplateModuleBuilder.this.createProject(name, path, indicator));
                }
                finally {
                    TemplateModuleBuilder.this.cleanup();
                    if (indicator.isCanceled()) {
                        canceledRef.set((Object)true);
                        if (!isSomehowOverwriting) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                try (AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(TemplateProjectDirectoryGenerator.class);){
                                    baseDir.delete(TemplateProjectDirectoryGenerator.class);
                                }
                            });
                        }
                    }
                }
            }
        };
        ProgressManager.getInstance().run((Task)task);
        if (canceledRef.get() == Boolean.TRUE) {
            throw new ProcessCanceledException();
        }
        return (Project)projectRef.get();
    }

    @Nullable
    private Project createProject(String name, final String path, @Nullable ProgressIndicator progressIndicator) {
        this.myProjectMode = true;
        this.unzip(name, path, false, progressIndicator, false);
        Ref projectRef = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> projectRef.set(ApplicationManager.getApplication().runWriteAction((Computable)new NullableComputable<Project>(){

            @Nullable
            public Project compute() {
                try {
                    return ProjectManagerEx.getInstanceEx().convertAndLoadProject(path);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
        })), ModalityState.any());
        return (Project)projectRef.get();
    }
}

