/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CompositeSequentialTask;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.SequentialTaskWithFixedIterationsNumber;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSettingsCodeFragmentFilter {
    private static final Logger LOG = Logger.getInstance(CodeStyleSettingsCodeFragmentFilter.class);
    private final Project myProject;
    private final PsiFile myFile;
    private final Document myDocument;
    private final RangeMarker myTextRangeMarker;
    private final LanguageCodeStyleSettingsProvider myProvider;
    private CommonCodeStyleSettings myCommonSettings;

    public CodeStyleSettingsCodeFragmentFilter(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/CodeStyleSettingsCodeFragmentFilter", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/codeStyle/CodeStyleSettingsCodeFragmentFilter", "<init>"));
        }
        this.myProvider = LanguageCodeStyleSettingsProvider.forLanguage((Language)file2.getLanguage());
        this.myProject = file2.getProject();
        this.myFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("copy" + file2.getName(), file2.getLanguage(), (CharSequence)file2.getText(), true, false);
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myFile);
        LOG.assertTrue(this.myDocument != null);
        this.myTextRangeMarker = this.myDocument.createRangeMarker(range.getStartOffset(), range.getEndOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CodeStyleSettingsToShow getFieldNamesAffectingCodeFragment(LanguageCodeStyleSettingsProvider.SettingsType ... types) {
        CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance((Project)this.myProject);
        CodeStyleSettings clonedSettings = codeStyleSettingsManager.getCurrentSettings().clone();
        this.myCommonSettings = clonedSettings.getCommonSettings(this.myProvider.getLanguage());
        codeStyleSettingsManager.setTemporarySettings(clonedSettings);
        String title = CodeInsightBundle.message((String)"configure.code.style.on.fragment.dialog.title", (Object[])new Object[0]);
        SequentialModalProgressTask progressTask = new SequentialModalProgressTask(this.myProject, StringUtil.capitalizeWords((String)title, (boolean)true));
        progressTask.setCancelText(CodeInsightBundle.message((String)"configure.code.style.on.fragment.dialog.cancel", (Object[])new Object[0]));
        CompositeSequentialTask compositeTask = new CompositeSequentialTask(progressTask);
        compositeTask.setProgressText(CodeInsightBundle.message((String)"configure.code.style.on.fragment.dialog.progress.text", (Object[])new Object[0]));
        compositeTask.setProgressText2(CodeInsightBundle.message((String)"configure.code.style.on.fragment.dialog.progress.text.under", (Object[])new Object[0]));
        final HashMap typeToTask = ContainerUtil.newHashMap();
        for (LanguageCodeStyleSettingsProvider.SettingsType type : types) {
            Set fields = this.myProvider.getSupportedFields(type);
            FilterFieldsTask task = new FilterFieldsTask(fields);
            compositeTask.addTask(task);
            typeToTask.put(type, task);
        }
        progressTask.setTask(compositeTask);
        progressTask.setMinIterationTime(10L);
        ProgressManager.getInstance().run((Task)progressTask);
        CodeStyleSettingsToShow codeStyleSettingsToShow = new CodeStyleSettingsToShow(){

            @Override
            public List<String> getSettings(LanguageCodeStyleSettingsProvider.SettingsType type) {
                FilterFieldsTask task = (FilterFieldsTask)typeToTask.get(type);
                return task.getAffectedFields();
            }
        };
        CodeStyleSettingsToShow codeStyleSettingsToShow2 = codeStyleSettingsToShow;
        if (codeStyleSettingsToShow2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettingsCodeFragmentFilter", "getFieldNamesAffectingCodeFragment"));
        }
        return codeStyleSettingsToShow2;
        finally {
            codeStyleSettingsManager.dropTemporarySettings();
        }
    }

    private boolean formattingChangedFragment() {
        CharSequence fragmentAfter;
        int rangeStart = this.myTextRangeMarker.getStartOffset();
        int rangeEnd = this.myTextRangeMarker.getEndOffset();
        CharSequence textBefore = this.myDocument.getCharsSequence();
        ApplicationManager.getApplication().runWriteAction(() -> CodeStyleManager.getInstance((Project)this.myProject).reformatText(this.myFile, rangeStart, rangeEnd));
        if (rangeStart != this.myTextRangeMarker.getStartOffset() || rangeEnd != this.myTextRangeMarker.getEndOffset()) {
            return true;
        }
        CharSequence fragmentBefore = textBefore.subSequence(rangeStart, rangeEnd);
        return !StringUtil.equals((CharSequence)fragmentBefore, (CharSequence)(fragmentAfter = this.myDocument.getCharsSequence().subSequence(rangeStart, rangeEnd)));
    }

    public static interface CodeStyleSettingsToShow {
        public List<String> getSettings(LanguageCodeStyleSettingsProvider.SettingsType var1);
    }

    private class FilterFieldsTask
    implements SequentialTaskWithFixedIterationsNumber {
        private final Iterator<String> myIterator;
        private final int myTotalFieldsNumber;
        private final Collection<String> myAllFields;
        private List<String> myAffectingFields;

        public FilterFieldsTask(Collection<String> fields) {
            if (fields == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "com/intellij/psi/codeStyle/CodeStyleSettingsCodeFragmentFilter$FilterFieldsTask", "<init>"));
            }
            this.myAffectingFields = ContainerUtil.newArrayList();
            this.myAllFields = fields;
            this.myIterator = fields.iterator();
            this.myTotalFieldsNumber = fields.size();
        }

        public List<String> getAffectedFields() {
            return this.myAffectingFields;
        }

        @Override
        public int getTotalIterationsNumber() {
            return this.myTotalFieldsNumber;
        }

        public void stop() {
            if (!this.isDone()) {
                this.myAffectingFields = ContainerUtil.newArrayList(this.myAllFields);
            }
        }

        public boolean isDone() {
            return !this.myIterator.hasNext();
        }

        public boolean iteration() {
            if (!this.myIterator.hasNext()) {
                return true;
            }
            String field = this.myIterator.next();
            try {
                Field classField = CommonCodeStyleSettings.class.getField(field);
                if (classField.getType() == Integer.TYPE) {
                    int oldValue = classField.getInt(CodeStyleSettingsCodeFragmentFilter.this.myCommonSettings);
                    int newValue = this.getNewIntValue(classField, oldValue);
                    if (newValue == oldValue) {
                        return true;
                    }
                    classField.set(CodeStyleSettingsCodeFragmentFilter.this.myCommonSettings, newValue);
                } else if (classField.getType() == Boolean.TYPE) {
                    boolean value = classField.getBoolean(CodeStyleSettingsCodeFragmentFilter.this.myCommonSettings);
                    classField.set(CodeStyleSettingsCodeFragmentFilter.this.myCommonSettings, !value);
                } else {
                    return true;
                }
                if (CodeStyleSettingsCodeFragmentFilter.this.formattingChangedFragment()) {
                    this.myAffectingFields.add(field);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        private int getNewIntValue(Field classField, int oldValue) throws IllegalAccessException {
            int newValue = oldValue;
            String fieldName = classField.getName();
            if (fieldName.contains("WRAP")) {
                newValue = oldValue == 2 ? 0 : 2;
            } else if (fieldName.contains("BRACE")) {
                newValue = oldValue == 3 ? 0 : 2;
            }
            return newValue;
        }

        public void prepare() {
        }
    }
}

