/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.common.InjectedLanguageBlockBuilder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultInjectedLanguageBlockBuilder
extends InjectedLanguageBlockBuilder {
    @NotNull
    private final CodeStyleSettings mySettings;

    public DefaultInjectedLanguageBlockBuilder(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/formatter/common/DefaultInjectedLanguageBlockBuilder", "<init>"));
        }
        this.mySettings = settings;
    }

    @Override
    @NotNull
    public CodeStyleSettings getSettings() {
        CodeStyleSettings codeStyleSettings = this.mySettings;
        if (codeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/common/DefaultInjectedLanguageBlockBuilder", "getSettings"));
        }
        return codeStyleSettings;
    }

    @Override
    public boolean canProcessFragment(String text, ASTNode injectionHost) {
        return true;
    }

    @Override
    public Block createBlockBeforeInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range) {
        return new GlueBlock(node, wrap, alignment, indent, range);
    }

    @Override
    public Block createBlockAfterInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range) {
        return new GlueBlock(node, wrap, alignment, Indent.getNoneIndent(), range);
    }

    private static class GlueBlock
    extends AbstractBlock {
        @NotNull
        private final Indent myIndent;
        @NotNull
        private final TextRange myRange;

        private GlueBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, @NotNull Indent indent, @NotNull TextRange range) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/formatter/common/DefaultInjectedLanguageBlockBuilder$GlueBlock", "<init>"));
            }
            if (indent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "com/intellij/psi/formatter/common/DefaultInjectedLanguageBlockBuilder$GlueBlock", "<init>"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/formatter/common/DefaultInjectedLanguageBlockBuilder$GlueBlock", "<init>"));
            }
            super(node, wrap, alignment);
            this.myIndent = indent;
            this.myRange = range;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/common/DefaultInjectedLanguageBlockBuilder$GlueBlock", "getTextRange"));
            }
            return textRange;
        }

        @Override
        protected List<Block> buildChildren() {
            return AbstractBlock.EMPTY;
        }

        @Override
        @NotNull
        public Indent getIndent() {
            Indent indent = this.myIndent;
            if (indent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/common/DefaultInjectedLanguageBlockBuilder$GlueBlock", "getIndent"));
            }
            return indent;
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/formatter/common/DefaultInjectedLanguageBlockBuilder$GlueBlock", "getSpacing"));
            }
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    }
}

