/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import org.jetbrains.annotations.NotNull;

public abstract class PsiTreeChangePreprocessorBase
implements PsiTreeChangePreprocessor {
    @NotNull
    private final Project myProject;

    public PsiTreeChangePreprocessorBase(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/PsiTreeChangePreprocessorBase", "<init>"));
        }
        this.myProject = project2;
    }

    @NotNull
    protected Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiTreeChangePreprocessorBase", "getProject"));
        }
        return project2;
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/PsiTreeChangePreprocessorBase", "treeChanged"));
        }
        boolean changedInsideCodeBlock = false;
        switch (event.getCode()) {
            case BEFORE_CHILDREN_CHANGE: {
                if (event.getParent() instanceof PsiFile) {
                    changedInsideCodeBlock = true;
                    break;
                }
            }
            case CHILDREN_CHANGED: {
                if (event.isGenericChange()) {
                    return;
                }
                changedInsideCodeBlock = this.isInsideCodeBlock(event.getParent());
                break;
            }
            case BEFORE_CHILD_ADDITION: 
            case BEFORE_CHILD_REMOVAL: 
            case CHILD_ADDED: 
            case CHILD_REMOVED: 
            case BEFORE_CHILD_REPLACEMENT: 
            case CHILD_REPLACED: {
                changedInsideCodeBlock = this.isInsideCodeBlock(event.getParent()) && this.isInsideCodeBlock(event.getChild()) && this.isInsideCodeBlock(event.getOldChild()) && this.isInsideCodeBlock(event.getNewChild());
                break;
            }
            case BEFORE_PROPERTY_CHANGE: 
            case PROPERTY_CHANGED: {
                changedInsideCodeBlock = false;
                break;
            }
            case BEFORE_CHILD_MOVEMENT: 
            case CHILD_MOVED: {
                boolean bl = changedInsideCodeBlock = this.isInsideCodeBlock(event.getOldParent()) && this.isInsideCodeBlock(event.getNewParent()) && this.isInsideCodeBlock(event.getChild());
            }
        }
        if (!changedInsideCodeBlock) {
            this.processOutOfCodeBlockModification(event);
        }
    }

    @NotNull
    private PsiModificationTrackerImpl getModificationTracker() {
        PsiModificationTrackerImpl psiModificationTrackerImpl = (PsiModificationTrackerImpl)PsiManager.getInstance((Project)this.myProject).getModificationTracker();
        if (psiModificationTrackerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiTreeChangePreprocessorBase", "getModificationTracker"));
        }
        return psiModificationTrackerImpl;
    }

    protected void processOutOfCodeBlockModification(PsiTreeChangeEventImpl event) {
        this.getModificationTracker().incOutOfCodeBlockModificationCounter();
    }

    protected abstract boolean isInsideCodeBlock(PsiElement var1);
}

