/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsMemberImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsMethodImpl
extends ClsMemberImpl<PsiMethodStub>
implements PsiAnnotationMethod {
    private final NotNullLazyValue<PsiTypeElement> myReturnType = this.isConstructor() ? null : new AtomicNotNullLazyValue<PsiTypeElement>(){

        @NotNull
        protected PsiTypeElement compute() {
            PsiMethodStub stub = (PsiMethodStub)ClsMethodImpl.this.getStub();
            String typeText = TypeInfo.createTypeText(stub.getReturnTypeText(false));
            assert (typeText != null) : stub;
            ClsTypeElementImpl clsTypeElementImpl = new ClsTypeElementImpl((PsiElement)ClsMethodImpl.this, typeText, '\u0000');
            if (clsTypeElementImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl$1", "compute"));
            }
            return clsTypeElementImpl;
        }
    };
    private final NotNullLazyValue<PsiAnnotationMemberValue> myDefaultValue;

    public ClsMethodImpl(PsiMethodStub stub) {
        super(stub);
        final String text = ((PsiMethodStub)this.getStub()).getDefaultValueText();
        this.myDefaultValue = StringUtil.isEmptyOrSpaces((String)text) ? null : new AtomicNotNullLazyValue<PsiAnnotationMemberValue>(){

            @NotNull
            protected PsiAnnotationMemberValue compute() {
                PsiAnnotationMemberValue psiAnnotationMemberValue = ClsParsingUtil.createMemberValueFromText(text, ClsMethodImpl.this.getManager(), ClsMethodImpl.this);
                if (psiAnnotationMemberValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl$2", "compute"));
                }
                return psiAnnotationMemberValue;
            }
        };
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getChildren(new PsiElement[]{this.getDocComment(), this.getModifierList(), this.getReturnTypeElement(), this.getNameIdentifier(), this.getParameterList(), this.getThrowsList(), this.getDefaultValue()});
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "getChildren"));
        }
        return psiElementArray;
    }

    public PsiClass getContainingClass() {
        return (PsiClass)this.getParent();
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic((PsiMethod)this, checkAccess);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "findSuperMethodSignaturesIncludingStatic"));
        }
        return list;
    }

    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod((PsiMethod)this);
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findDeepestSuperMethods((PsiMethod)this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "findDeepestSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)this);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "getHierarchicalMethodSignature"));
        }
        return hierarchicalMethodSignature;
    }

    public PsiTypeElement getReturnTypeElement() {
        return this.myReturnType != null ? (PsiTypeElement)this.myReturnType.getValue() : null;
    }

    public PsiType getReturnType() {
        PsiTypeElement typeElement = this.getReturnTypeElement();
        return typeElement == null ? null : typeElement.getType();
    }

    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = (PsiModifierList)((PsiMethodStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST).getPsi();
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "getModifierList"));
        }
        return psiModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/compiled/ClsMethodImpl", "hasModifierProperty"));
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = (PsiParameterList)((PsiMethodStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.PARAMETER_LIST).getPsi();
        if (psiParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "getParameterList"));
        }
        return psiParameterList;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = (PsiReferenceList)((PsiMethodStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.THROWS_LIST).getPsi();
        if (psiReferenceList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "getThrowsList"));
        }
        return psiReferenceList;
    }

    public PsiTypeParameterList getTypeParameterList() {
        return (PsiTypeParameterList)((PsiMethodStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.TYPE_PARAMETER_LIST).getPsi();
    }

    public PsiCodeBlock getBody() {
        return null;
    }

    public boolean isDeprecated() {
        return ((PsiMethodStub)this.getStub()).isDeprecated() || PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public PsiAnnotationMemberValue getDefaultValue() {
        return this.myDefaultValue != null ? (PsiAnnotationMemberValue)this.myDefaultValue.getValue() : null;
    }

    public boolean isConstructor() {
        return ((PsiMethodStub)this.getStub()).isConstructor();
    }

    public boolean isVarArgs() {
        return ((PsiMethodStub)this.getStub()).isVarArgs();
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/compiled/ClsMethodImpl", "getSignature"));
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "getSignature"));
        }
        return methodSignatureBackedByPsiMethod;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        PsiAnnotationMemberValue defaultValue;
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsMethodImpl", "appendMirrorText"));
        }
        ClsMethodImpl.appendText((PsiElement)this.getDocComment(), indentLevel, buffer, "go_to_next_line_and_indent");
        ClsMethodImpl.appendText((PsiElement)this.getModifierList(), indentLevel, buffer, "");
        ClsMethodImpl.appendText((PsiElement)this.getTypeParameterList(), indentLevel, buffer, " ");
        if (!this.isConstructor()) {
            ClsMethodImpl.appendText((PsiElement)this.getReturnTypeElement(), indentLevel, buffer, " ");
        }
        ClsMethodImpl.appendText((PsiElement)this.getNameIdentifier(), indentLevel, buffer, "");
        ClsMethodImpl.appendText((PsiElement)this.getParameterList(), indentLevel, buffer);
        PsiReferenceList throwsList = this.getThrowsList();
        if (throwsList.getReferencedTypes().length > 0) {
            buffer.append(' ');
            ClsMethodImpl.appendText((PsiElement)throwsList, indentLevel, buffer);
        }
        if ((defaultValue = this.getDefaultValue()) != null) {
            buffer.append(" default ");
            ClsMethodImpl.appendText((PsiElement)defaultValue, indentLevel, buffer);
        }
        if (this.hasModifierProperty("abstract") || this.hasModifierProperty("native")) {
            buffer.append(";");
        } else {
            buffer.append(" { /* compiled code */ }");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsMethodImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, null);
        PsiMethod mirror = (PsiMethod)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsMethodImpl.setMirrorIfPresent(this.getDocComment(), mirror.getDocComment());
        ClsMethodImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsMethodImpl.setMirror(this.getTypeParameterList(), mirror.getTypeParameterList());
        if (!this.isConstructor()) {
            ClsMethodImpl.setMirror(this.getReturnTypeElement(), mirror.getReturnTypeElement());
        }
        ClsMethodImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
        ClsMethodImpl.setMirror(this.getParameterList(), mirror.getParameterList());
        ClsMethodImpl.setMirror(this.getThrowsList(), mirror.getThrowsList());
        PsiAnnotationMemberValue defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            assert (mirror instanceof PsiAnnotationMethod) : this;
            ClsMethodImpl.setMirror(defaultValue, ((PsiAnnotationMethod)mirror).getDefaultValue());
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/compiled/ClsMethodImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod((PsiMethod)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiParameter[] parameters;
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/compiled/ClsMethodImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/compiled/ClsMethodImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/compiled/ClsMethodImpl", "processDeclarations"));
        }
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent == null) {
            return true;
        }
        if (!PsiScopesUtil.walkChildrenScopes((PsiElement)this, processor2, state, lastParent, place)) {
            return false;
        }
        for (PsiParameter parameter : parameters = this.getParameterList().getParameters()) {
            if (processor2.execute((PsiElement)parameter, state)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public PsiMethod getSourceMirrorMethod() {
        return (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiMethod>(){

            @Nullable
            public CachedValueProvider.Result<PsiMethod> compute() {
                return CachedValueProvider.Result.create((Object)ClsMethodImpl.this.calcSourceMirrorMethod(), (Object[])new Object[]{ClsMethodImpl.this.getContainingFile(), ClsMethodImpl.this.getContainingFile().getNavigationElement(), FileIndexFacade.getInstance((Project)ClsMethodImpl.this.getProject()).getRootModificationTracker()});
            }
        });
    }

    @Nullable
    private PsiMethod calcSourceMirrorMethod() {
        PsiClass sourceClassMirror = ((ClsClassImpl)this.getParent()).getSourceMirrorClass();
        if (sourceClassMirror == null) {
            return null;
        }
        for (PsiMethod sourceMethod : sourceClassMirror.findMethodsByName(this.getName(), false)) {
            if (!MethodSignatureUtil.areParametersErasureEqual((PsiMethod)this, (PsiMethod)sourceMethod)) continue;
            return sourceMethod;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        ClsMethodImpl clsMethodImpl;
        for (ClsCustomNavigationPolicy customNavigationPolicy : (ClsCustomNavigationPolicy[])Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            PsiElement psiElement;
            try {
                PsiElement navigationElement = customNavigationPolicy.getNavigationElement(this);
                if (navigationElement == null) continue;
                psiElement = navigationElement;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "getNavigationElement"));
            }
            return psiElement;
        }
        try {
            PsiMethod method = this.getSourceMirrorMethod();
            clsMethodImpl = method != null ? method.getNavigationElement() : this;
        }
        catch (IndexNotReadyException e) {
            ClsMethodImpl clsMethodImpl2 = this;
            if (clsMethodImpl2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "getNavigationElement"));
            }
            return clsMethodImpl2;
        }
        if (clsMethodImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "getNavigationElement"));
        }
        return clsMethodImpl;
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "getTypeParameters"));
        }
        return psiTypeParameterArray;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(methodIcon, (PsiModifierListOwner)this, false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo((PsiMethod)this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMethodImpl", "getUseScope"));
        }
        return searchScope;
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public String toString() {
        return "PsiMethod:" + this.getName();
    }
}

