/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PackagePrefixElementFinder;
import com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PsiPackageImplementationHelperImpl
extends PsiPackageImplementationHelper {
    @Override
    @NotNull
    public GlobalSearchScope adjustAllScope(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope globalSearchScope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "adjustAllScope"));
        }
        if (globalSearchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalSearchScope", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "adjustAllScope"));
        }
        GlobalSearchScope globalSearchScope2 = NonClasspathClassFinder.addNonClasspathScope(psiPackage.getProject(), globalSearchScope);
        if (globalSearchScope2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "adjustAllScope"));
        }
        return globalSearchScope2;
    }

    @Override
    @NotNull
    public VirtualFile[] occursInPackagePrefixes(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "occursInPackagePrefixes"));
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        Module[] modules = ModuleManager.getInstance((Project)psiPackage.getProject()).getModules();
        String qualifiedName = psiPackage.getQualifiedName();
        for (Module module2 : modules) {
            for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module2).getContentEntries()) {
                List sourceFolders = contentEntry.getSourceFolders(JavaModuleSourceRootTypes.SOURCES);
                for (SourceFolder sourceFolder : sourceFolders) {
                    VirtualFile file2;
                    String packagePrefix = sourceFolder.getPackagePrefix();
                    if (!packagePrefix.startsWith(qualifiedName) || (file2 = sourceFolder.getFile()) == null) continue;
                    result2.add(file2);
                }
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "occursInPackagePrefixes"));
        }
        return virtualFileArray;
    }

    @Override
    public void handleQualifiedNameChange(final @NotNull PsiPackage psiPackage, final @NotNull String newQualifiedName) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "handleQualifiedNameChange"));
        }
        if (newQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newQualifiedName", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "handleQualifiedNameChange"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        final String oldQualifedName = psiPackage.getQualifiedName();
        boolean anyChanged = PsiPackageImplementationHelperImpl.changePackagePrefixes(psiPackage, oldQualifedName, newQualifiedName);
        if (anyChanged) {
            UndoManager.getInstance((Project)psiPackage.getProject()).undoableActionPerformed((UndoableAction)new GlobalUndoableAction(){

                public void undo() {
                    PsiPackageImplementationHelperImpl.changePackagePrefixes(psiPackage, newQualifiedName, oldQualifedName);
                }

                public void redo() {
                    PsiPackageImplementationHelperImpl.changePackagePrefixes(psiPackage, oldQualifedName, newQualifiedName);
                }
            });
        }
    }

    private static boolean changePackagePrefixes(@NotNull PsiPackage psiPackage, @NotNull String oldQualifiedName, @NotNull String newQualifiedName) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "changePackagePrefixes"));
        }
        if (oldQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "changePackagePrefixes"));
        }
        if (newQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newQualifiedName", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "changePackagePrefixes"));
        }
        Module[] modules = ModuleManager.getInstance((Project)psiPackage.getProject()).getModules();
        ArrayList<ModifiableRootModel> modelsToCommit = new ArrayList<ModifiableRootModel>();
        for (Module module2 : modules) {
            boolean anyChange = false;
            ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
            for (ContentEntry contentEntry : rootModel.getContentEntries()) {
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                    String packagePrefix = sourceFolder.getPackagePrefix();
                    if (!packagePrefix.startsWith(oldQualifiedName)) continue;
                    sourceFolder.setPackagePrefix(newQualifiedName + packagePrefix.substring(oldQualifiedName.length()));
                    anyChange = true;
                }
            }
            if (anyChange) {
                modelsToCommit.add(rootModel);
                continue;
            }
            rootModel.dispose();
        }
        if (!modelsToCommit.isEmpty()) {
            ModifiableRootModel[] rootModels = modelsToCommit.toArray(new ModifiableRootModel[modelsToCommit.size()]);
            if (rootModels.length > 0) {
                ModifiableModelCommitter.multiCommit(rootModels, ModuleManager.getInstance((Project)rootModels[0].getProject()).getModifiableModel());
            }
            return true;
        }
        return false;
    }

    @Override
    public void navigate(@NotNull PsiPackage psiPackage, boolean requestFocus) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "navigate"));
        }
        Project project2 = psiPackage.getProject();
        ToolWindow window = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.PROJECT_VIEW);
        window.activate(null);
        window.getActivation().doWhenDone(() -> {
            if (psiPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "lambda$navigate$0"));
            }
            ProjectView projectView = ProjectView.getInstance(project2);
            PsiDirectory[] directories = PsiPackageImplementationHelperImpl.suggestMostAppropriateDirectories(psiPackage);
            if (directories.length == 0) {
                return;
            }
            projectView.select(directories[0], directories[0].getVirtualFile(), requestFocus);
        });
    }

    @NotNull
    private static PsiDirectory[] suggestMostAppropriateDirectories(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "suggestMostAppropriateDirectories"));
        }
        Project project2 = psiPackage.getProject();
        PsiDirectory[] directories = null;
        Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        if (editor != null) {
            Document document2 = editor.getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
            if (psiFile != null) {
                Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
                if (module2 != null) {
                    boolean isInTests;
                    VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiFile);
                    boolean bl = isInTests = virtualFile != null && ModuleRootManager.getInstance((Module)module2).getFileIndex().isInTestSourceContent(virtualFile);
                    if (isInTests) {
                        directories = psiPackage.getDirectories(GlobalSearchScope.moduleTestsWithDependentsScope((Module)module2));
                    }
                    if (directories == null || directories.length == 0) {
                        directories = psiPackage.getDirectories(GlobalSearchScope.moduleWithDependenciesScope((Module)module2));
                    }
                } else {
                    directories = psiPackage.getDirectories(GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.projectScope((Project)project2)));
                }
            }
        }
        if (directories == null || directories.length == 0) {
            directories = psiPackage.getDirectories();
        }
        if (directories == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "suggestMostAppropriateDirectories"));
        }
        return directories;
    }

    @Override
    public boolean packagePrefixExists(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "packagePrefixExists"));
        }
        return PackagePrefixElementFinder.getInstance(psiPackage.getProject()).packagePrefixExists(psiPackage.getQualifiedName());
    }

    @Override
    @NotNull
    public Object[] getDirectoryCachedValueDependencies(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "getDirectoryCachedValueDependencies"));
        }
        Object[] objectArray = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)psiPackage.getProject())};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImplementationHelperImpl", "getDirectoryCachedValueDependencies"));
        }
        return objectArray;
    }
}

