/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NonNls;

class SimpleDocTagInfo
implements JavadocTagInfo {
    private final String myName;
    private final Class myContext;
    private final Class myAdditionalContext;
    private final boolean myInline;
    private final LanguageLevel myLanguageLevel;

    public SimpleDocTagInfo(@NonNls String name, Class context, boolean isInline, LanguageLevel level) {
        this.myName = name;
        this.myContext = context;
        this.myAdditionalContext = null;
        this.myInline = isInline;
        this.myLanguageLevel = level;
    }

    public SimpleDocTagInfo(@NonNls String name, Class context, Class additionalContext, LanguageLevel level) {
        this.myName = name;
        this.myContext = context;
        this.myAdditionalContext = additionalContext;
        this.myInline = false;
        this.myLanguageLevel = level;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isInline() {
        return this.myInline;
    }

    public boolean isValidInContext(PsiElement element) {
        if (element != null && PsiUtil.getLanguageLevel((PsiElement)element).compareTo((Enum)this.myLanguageLevel) < 0) {
            return false;
        }
        return this.myContext.isInstance(element) || this.myAdditionalContext != null && this.myAdditionalContext.isInstance(element);
    }

    public String checkTagValue(PsiDocTagValue value) {
        return null;
    }

    public PsiReference getReference(PsiDocTagValue value) {
        return null;
    }
}

