/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReferenceSet {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet");
    private static final FileType[] EMPTY_FILE_TYPES = new FileType[0];
    public static final CustomizableReferenceProvider.CustomizationKey<Function<PsiFile, Collection<PsiFileSystemItem>>> DEFAULT_PATH_EVALUATOR_OPTION = new CustomizableReferenceProvider.CustomizationKey(PsiBundle.message((String)"default.path.evaluator.option", (Object[])new Object[0]));
    public static final Function<PsiFile, Collection<PsiFileSystemItem>> ABSOLUTE_TOP_LEVEL = file2 -> FileReferenceSet.getAbsoluteTopLevelDirLocations(file2);
    public static final Condition<PsiFileSystemItem> FILE_FILTER = item -> item instanceof PsiFile;
    public static final Condition<PsiFileSystemItem> DIRECTORY_FILTER = item -> item instanceof PsiDirectory;
    protected FileReference[] myReferences;
    private PsiElement myElement;
    private final int myStartInElement;
    private final boolean myCaseSensitive;
    private final String myPathStringNonTrimmed;
    private final String myPathString;
    private Collection<PsiFileSystemItem> myDefaultContexts;
    private final boolean myEndingSlashNotAllowed;
    private boolean myEmptyPathAllowed;
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;
    @Nullable
    private FileType[] mySuitableFileTypes;

    public FileReferenceSet(String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean caseSensitive, boolean endingSlashNotAllowed, @Nullable FileType[] suitableFileTypes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "<init>"));
        }
        this(str, element, startInElement, provider, caseSensitive, endingSlashNotAllowed, suitableFileTypes, true);
    }

    public FileReferenceSet(String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean caseSensitive, boolean endingSlashNotAllowed, @Nullable FileType[] suitableFileTypes, boolean init) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "<init>"));
        }
        this.myElement = element;
        this.myStartInElement = startInElement;
        this.myCaseSensitive = caseSensitive;
        this.myPathStringNonTrimmed = str;
        this.myPathString = str.trim();
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
        this.myEmptyPathAllowed = !endingSlashNotAllowed;
        this.myOptions = provider instanceof CustomizableReferenceProvider ? ((CustomizableReferenceProvider)provider).getOptions() : null;
        this.mySuitableFileTypes = suitableFileTypes;
        if (init) {
            this.reparse();
        }
    }

    protected String getNewAbsolutePath(PsiFileSystemItem root, String relativePath) {
        return this.absoluteUrlNeedsStartSlash() ? "/" + relativePath : relativePath;
    }

    public String getSeparatorString() {
        return "/";
    }

    protected int findSeparatorLength(@NotNull CharSequence sequence, int atOffset) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "findSeparatorLength"));
        }
        return StringUtil.startsWith((CharSequence)sequence, (int)atOffset, (CharSequence)this.getSeparatorString()) ? this.getSeparatorString().length() : 0;
    }

    protected int findSeparatorOffset(@NotNull CharSequence sequence, int startingFrom) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "findSeparatorOffset"));
        }
        return StringUtil.indexOf((CharSequence)sequence, (CharSequence)this.getSeparatorString(), (int)startingFrom);
    }

    @Deprecated
    protected Collection<PsiFileSystemItem> getExtraContexts() {
        return Collections.emptyList();
    }

    public static FileReferenceSet createSet(@NotNull PsiElement element, final boolean soft, boolean endingSlashNotAllowed, final boolean urlEncoded) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "createSet"));
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        assert (manipulator != null);
        TextRange range = manipulator.getRangeInElement(element);
        int offset = range.getStartOffset();
        String text = range.substring(element.getText());
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            text = helper.trimUrl(text);
        }
        return new FileReferenceSet(text, element, offset, null, true, endingSlashNotAllowed){

            @Override
            protected boolean isUrlEncoded() {
                return urlEncoded;
            }

            @Override
            protected boolean isSoft() {
                return soft;
            }
        };
    }

    public FileReferenceSet(String str, @NotNull PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider, boolean isCaseSensitive) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "<init>"));
        }
        this(str, element, startInElement, provider, isCaseSensitive, true);
    }

    public FileReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "<init>"));
        }
        this(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed, null);
    }

    public FileReferenceSet(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "<init>"));
        }
        this.myElement = element;
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
        this.myStartInElement = range.getStartOffset();
        this.myPathStringNonTrimmed = range.substring(element.getText());
        this.myPathString = this.myPathStringNonTrimmed.trim();
        this.myEndingSlashNotAllowed = true;
        this.myCaseSensitive = false;
        this.reparse();
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getElement"));
        }
        return psiElement;
    }

    void setElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "setElement"));
        }
        this.myElement = element;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isEndingSlashNotAllowed() {
        return this.myEndingSlashNotAllowed;
    }

    public int getStartInElement() {
        return this.myStartInElement;
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new FileReference(this, range, index, text);
    }

    protected void reparse() {
        List<FileReference> referencesList = this.reparse(this.myPathStringNonTrimmed, this.myStartInElement);
        this.myReferences = referencesList.toArray(new FileReference[referencesList.size()]);
    }

    protected List<FileReference> reparse(String str, int startInElement) {
        int sepLen;
        int i;
        CharSequence decoded;
        TextRange valueRange;
        LiteralTextEscaper escaper;
        int wsHead = 0;
        int wsTail = 0;
        if (this.myElement instanceof PsiLanguageInjectionHost && !StringUtil.startsWith((CharSequence)this.myElement.getText(), (int)startInElement, (CharSequence)str)) {
            escaper = ((PsiLanguageInjectionHost)this.myElement).createLiteralTextEscaper();
            valueRange = ElementManipulators.getValueTextRange((PsiElement)this.myElement);
            StringBuilder sb = new StringBuilder();
            escaper.decode(valueRange, sb);
            decoded = sb;
            wsHead += Math.max(0, startInElement - valueRange.getStartOffset());
        } else {
            escaper = null;
            decoded = str;
            valueRange = TextRange.from((int)startInElement, (int)decoded.length());
        }
        ArrayList referencesList = ContainerUtil.newArrayList();
        for (i = wsHead; i < decoded.length() && Character.isWhitespace(decoded.charAt(i)); ++i) {
            ++wsHead;
        }
        for (i = decoded.length() - 1; i >= 0 && Character.isWhitespace(decoded.charAt(i)); --i) {
            ++wsTail;
        }
        int index = 0;
        int curSep = this.findSeparatorOffset(decoded, wsHead);
        int n = sepLen = curSep >= wsHead ? this.findSeparatorLength(decoded, curSep) : 0;
        if (curSep >= 0 && decoded.length() == wsHead + sepLen + wsTail) {
            TextRange r = TextRange.create((int)startInElement, (int)(FileReferenceSet.offset(curSep + Math.max(0, sepLen - 1), (LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, valueRange) + 1));
            referencesList.add(this.createFileReference(r, index++, decoded.subSequence(curSep, curSep + sepLen).toString()));
        }
        curSep = curSep == wsHead ? curSep + sepLen : wsHead;
        sepLen = 0;
        while (curSep >= 0) {
            int nextSep = this.findSeparatorOffset(decoded, curSep + sepLen);
            int start = curSep + sepLen;
            int endTrimmed = nextSep > 0 ? nextSep : Math.max(start, decoded.length() - wsTail);
            int endInclusive = nextSep > 0 ? nextSep : Math.max(start, decoded.length() - 1 - wsTail);
            String refText = index == 0 && nextSep < 0 && !StringUtil.contains((CharSequence)decoded, (CharSequence)str) ? str : decoded.subSequence(start, endTrimmed).toString();
            TextRange r = new TextRange(FileReferenceSet.offset(start, (LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, valueRange), FileReferenceSet.offset(endInclusive, (LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, valueRange) + (nextSep < 0 && refText.length() > 0 ? 1 : 0));
            referencesList.add(this.createFileReference(r, index++, refText));
            curSep = nextSep;
            sepLen = curSep > 0 ? this.findSeparatorLength(decoded, curSep) : 0;
        }
        return referencesList;
    }

    private static int offset(int offset, LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper, TextRange valueRange) {
        return escaper == null ? offset + valueRange.getStartOffset() : escaper.getOffsetInHost(offset, valueRange);
    }

    public FileReference getReference(int index) {
        return this.myReferences[index];
    }

    @NotNull
    public FileReference[] getAllReferences() {
        if (this.myReferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getAllReferences"));
        }
        return this.myReferences;
    }

    protected boolean isSoft() {
        return false;
    }

    protected boolean isUrlEncoded() {
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getDefaultContexts() {
        if (this.myDefaultContexts == null) {
            this.myDefaultContexts = this.computeDefaultContexts();
        }
        Collection<PsiFileSystemItem> collection = this.myDefaultContexts;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getDefaultContexts"));
        }
        return collection;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        Collection roots;
        Function<PsiFile, Collection<PsiFileSystemItem>> value;
        PsiFile file2 = this.getContainingFile();
        if (file2 == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "computeDefaultContexts"));
            }
            return list;
        }
        if (this.myOptions != null && (value = DEFAULT_PATH_EVALUATOR_OPTION.getValue(this.myOptions)) != null && (roots = (Collection)value.fun((Object)file2)) != null) {
            for (PsiFileSystemItem root : roots) {
                if (root != null) continue;
                LOG.error("Default path evaluator " + value + " produced a null root for " + file2);
            }
            Collection collection = roots;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "computeDefaultContexts"));
            }
            return collection;
        }
        if (this.isAbsolutePathReference()) {
            Collection<PsiFileSystemItem> collection = FileReferenceSet.getAbsoluteTopLevelDirLocations(file2);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "computeDefaultContexts"));
            }
            return collection;
        }
        Collection<PsiFileSystemItem> collection = this.getContextByFile(file2);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "computeDefaultContexts"));
        }
        return collection;
    }

    @Nullable
    protected PsiFile getContainingFile() {
        PsiFile cf = this.myElement.getContainingFile();
        PsiFile file2 = InjectedLanguageManager.getInstance((Project)cf.getProject()).getTopLevelFile((PsiElement)cf);
        if (file2 != null) {
            return file2.getOriginalFile();
        }
        LOG.error("Invalid element: " + this.myElement);
        return null;
    }

    @NotNull
    private Collection<PsiFileSystemItem> getContextByFile(@NotNull PsiFile file2) {
        FileContextProvider contextProvider;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getContextByFile"));
        }
        PsiElement context = file2.getContext();
        if (context != null) {
            file2 = context.getContainingFile();
        }
        if (this.useIncludingFileAsContext() && (contextProvider = FileContextProvider.getProvider((PsiFile)file2)) != null) {
            Collection folders = contextProvider.getContextFolders(file2);
            if (!folders.isEmpty()) {
                Collection collection = folders;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getContextByFile"));
                }
                return collection;
            }
            PsiFile contextFile = contextProvider.getContextFile(file2);
            if (contextFile != null) {
                Set<PsiDirectory> set = Collections.singleton(contextFile.getParent());
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getContextByFile"));
                }
                return set;
            }
        }
        Collection<PsiFileSystemItem> collection = this.getContextByFileSystemItem((PsiFileSystemItem)file2.getOriginalFile());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getContextByFile"));
        }
        return collection;
    }

    @NotNull
    protected final Collection<PsiFileSystemItem> getContextByFileSystemItem(@NotNull PsiFileSystemItem file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getContextByFileSystemItem"));
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null) {
            PsiDirectory directory;
            FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
            ArrayList<PsiFileSystemItem> list = new ArrayList<PsiFileSystemItem>();
            Project project2 = file2.getProject();
            for (FileReferenceHelper helper : helpers) {
                if (!helper.isMine(project2, virtualFile) || !list.isEmpty() && helper.isFallback()) continue;
                list.addAll(helper.getContexts(project2, virtualFile));
            }
            if (!list.isEmpty()) {
                ArrayList<PsiFileSystemItem> arrayList = list;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getContextByFileSystemItem"));
                }
                return arrayList;
            }
            VirtualFile parent = virtualFile.getParent();
            if (parent != null && (directory = file2.getManager().findDirectory(parent)) != null) {
                Set<PsiDirectory> set = Collections.singleton(directory);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getContextByFileSystemItem"));
                }
                return set;
            }
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getContextByFileSystemItem"));
        }
        return list;
    }

    public String getPathString() {
        return this.myPathString;
    }

    public boolean isAbsolutePathReference() {
        return this.myPathString.startsWith(this.getSeparatorString());
    }

    protected boolean useIncludingFileAsContext() {
        return true;
    }

    @Nullable
    public PsiFileSystemItem resolve() {
        FileReference lastReference = this.getLastReference();
        return lastReference == null ? null : lastReference.resolve();
    }

    @Nullable
    public FileReference getLastReference() {
        return this.myReferences == null || this.myReferences.length == 0 ? null : this.myReferences[this.myReferences.length - 1];
    }

    @NotNull
    public static Collection<PsiFileSystemItem> getAbsoluteTopLevelDirLocations(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getAbsoluteTopLevelDirLocations"));
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getAbsoluteTopLevelDirLocations"));
            }
            return list;
        }
        PsiDirectory parent = file2.getParent();
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)(parent == null ? file2 : parent));
        if (module2 == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getAbsoluteTopLevelDirLocations"));
            }
            return list;
        }
        ArrayList<PsiFileSystemItem> list = new ArrayList<PsiFileSystemItem>();
        Project project2 = file2.getProject();
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            if (!helper.isMine(project2, virtualFile) || helper.isFallback() && !list.isEmpty()) continue;
            Collection<PsiFileSystemItem> roots = helper.getRoots(module2);
            for (PsiFileSystemItem root : roots) {
                if (root != null) continue;
                LOG.error("Helper " + helper + " produced a null root for " + file2);
            }
            list.addAll(roots);
        }
        ArrayList<PsiFileSystemItem> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getAbsoluteTopLevelDirLocations"));
        }
        return arrayList;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> toFileSystemItems(VirtualFile ... files) {
        Collection<PsiFileSystemItem> collection = this.toFileSystemItems(Arrays.asList(files));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "toFileSystemItems"));
        }
        return collection;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> toFileSystemItems(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "toFileSystemItems"));
        }
        PsiManager manager = this.getElement().getManager();
        List list = ContainerUtil.mapNotNull(files, (Function)((NullableFunction)file2 -> file2 != null ? manager.findDirectory(file2) : null));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "toFileSystemItems"));
        }
        return list;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return Conditions.alwaysTrue();
    }

    public <Option> void addCustomization(CustomizableReferenceProvider.CustomizationKey<Option> key2, Option value) {
        if (this.myOptions == null) {
            this.myOptions = new HashMap<CustomizableReferenceProvider.CustomizationKey, Object>(5);
        }
        this.myOptions.put(key2, value);
    }

    public boolean couldBeConvertedTo(boolean relative) {
        return true;
    }

    public boolean absoluteUrlNeedsStartSlash() {
        return true;
    }

    @NotNull
    public FileType[] getSuitableFileTypes() {
        FileType[] fileTypeArray = this.mySuitableFileTypes == null ? EMPTY_FILE_TYPES : this.mySuitableFileTypes;
        if (fileTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet", "getSuitableFileTypes"));
        }
        return fileTypeArray;
    }

    public boolean isEmptyPathAllowed() {
        return this.myEmptyPathAllowed;
    }

    public void setEmptyPathAllowed(boolean emptyPathAllowed) {
        this.myEmptyPathAllowed = emptyPathAllowed;
    }

    public boolean supportsExtendedCompletion() {
        return true;
    }
}

