/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ReferenceSetBase;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageReferenceSet
extends ReferenceSetBase<PsiPackageReference> {
    private final GlobalSearchScope mySearchScope;

    public PackageReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackageReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackageReferenceSet", "<init>"));
        }
        this(str, element, startInElement, element.getResolveScope());
    }

    public PackageReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, @NotNull GlobalSearchScope scope) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackageReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackageReferenceSet", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackageReferenceSet", "<init>"));
        }
        super(str, element, startInElement, '.');
        this.mySearchScope = scope;
    }

    @NotNull
    protected PsiPackageReference createReference(TextRange range, int index) {
        PsiPackageReference psiPackageReference = new PsiPackageReference(this, range, index);
        if (psiPackageReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackageReferenceSet", "createReference"));
        }
        return psiPackageReference;
    }

    public Collection<PsiPackage> resolvePackageName(@Nullable PsiPackage context, String packageName) {
        if (context != null) {
            return ContainerUtil.filter((Object[])context.getSubPackages(this.getResolveScope()), aPackage -> Comparing.equal((String)aPackage.getName(), (String)packageName));
        }
        return Collections.emptyList();
    }

    @NotNull
    protected GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.mySearchScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackageReferenceSet", "getResolveScope"));
        }
        return globalSearchScope;
    }

    public Collection<PsiPackage> resolvePackage() {
        PsiPackageReference packageReference = (PsiPackageReference)this.getLastReference();
        if (packageReference == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.map2List((Object[])packageReference.multiResolve(false), (Function)((NullableFunction)resolveResult -> (PsiPackage)resolveResult.getElement()));
    }

    public Set<PsiPackage> getInitialContext() {
        return Collections.singleton(JavaPsiFacade.getInstance((Project)this.getElement().getProject()).findPackage(""));
    }
}

